/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content.rules;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.io.IOUtils;
import org.drools.core.FactException;
import org.drools.core.spi.KnowledgeHelper;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaService;
import org.jahia.services.cache.Cache;
import org.jahia.services.cache.CacheService;
import org.jahia.services.content.JCRAutoSplitUtils;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.rules.ActionJob;
import org.jahia.services.content.rules.AddedNodeFact;
import org.jahia.services.content.rules.BackgroundAction;
import org.jahia.services.content.rules.ChangedPropertyFact;
import org.jahia.services.content.rules.DeletedNodeFact;
import org.jahia.services.content.rules.NodeFact;
import org.jahia.services.content.rules.RuleJob;
import org.jahia.services.content.rules.User;
import org.jahia.services.importexport.SiteImportJob;
import org.jahia.services.pwdpolicy.JahiaPasswordPolicyService;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.tags.TaggingService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.services.workflow.WorkflowService;
import org.jahia.utils.Patterns;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Service
extends JahiaService {
    private static final Logger logger = LoggerFactory.getLogger(Service.class);
    private static volatile Service instance;
    private TaggingService taggingService;
    private JahiaSitesService sitesService;
    private SchedulerService schedulerService;
    private CacheService cacheService;
    private JahiaUserManagerService userManagerService;
    private JahiaGroupManagerService groupManagerService;
    private JahiaPasswordPolicyService passwordPolicyService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Service getInstance() {
        if (instance != null) return instance;
        Class<Service> clazz = Service.class;
        synchronized (Service.class) {
            if (instance != null) return instance;
            instance = new Service();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void grantRoleToUser(AddedNodeFact node, String user, String role, KnowledgeHelper drools) {
        try {
            node.getNode().grantRoles("u:" + user, Collections.singleton(role));
            node.getNode().getSession().save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void grantRoleToGroup(AddedNodeFact node, String group, String role, KnowledgeHelper drools) {
        try {
            node.getNode().grantRoles("g:" + group, Collections.singleton(role));
            node.getNode().getSession().save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void revokeRoleFromEverybody(AddedNodeFact node, String role, KnowledgeHelper drools) {
        for (String s : node.getNode().getAclEntries().keySet()) {
            try {
                node.getNode().denyRoles(s, Collections.singleton(role));
                node.getNode().getSession().save();
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void revokeAllPermissions(AddedNodeFact node) {
        try {
            node.getNode().revokeAllRoles();
            node.getNode().getSession().save();
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setAclInheritanceBreak(AddedNodeFact node, boolean aclInheritanceBreak) {
        try {
            node.getNode().setAclInheritanceBreak(aclInheritanceBreak);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void importNode(AddedNodeFact node, KnowledgeHelper drools) throws RepositoryException {
        User user = (User)drools.getWorkingMemory().getGlobal("user");
        JobDetail jobDetail = BackgroundJob.createJahiaJob("xx", SiteImportJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("userkey", user.getJahiaUser().getUserKey());
        jobDataMap.put("nodepath", node.getPath());
        try {
            ServicesRegistry.getInstance().getSchedulerService().scheduleJobNow(jobDetail);
        }
        catch (SchedulerException e) {
            logger.error("Cannot schedult import for " + node.getPath(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importXML(AddedNodeFact targetNode, String path, KnowledgeHelper drools) throws RepositoryException {
        InputStream is = null;
        try {
            is = JahiaContextLoaderListener.getServletContext().getResourceAsStream(path);
            if (is == null) {
                throw new FileNotFoundException("Unable to locate resource at the specified path: " + path);
            }
            JCRSessionWrapper session = targetNode.getNode().getSession();
            session.importXML(targetNode.getPath(), is, 0, 0);
            session.save();
        }
        catch (Exception e) {
            logger.error("Error reading content of file " + path, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        logger.info("Content of the file '" + path + "' for target node " + targetNode + " imported successfully");
    }

    public void incrementProperty(AddedNodeFact node, String propertyName, KnowledgeHelper drools) {
        JCRNodeWrapper jcrNode = node.getNode();
        try {
            long aLong = 0L;
            try {
                Property property = jcrNode.getProperty(propertyName);
                aLong = property.getLong();
            }
            catch (PathNotFoundException e) {
                logger.debug("The property to increment " + propertyName + " does not exist yet", (Throwable)e);
            }
            jcrNode.setProperty(propertyName, aLong + 1L);
        }
        catch (RepositoryException e) {
            logger.error("Error during increment of property " + propertyName + " for node " + node, (Throwable)e);
        }
    }

    public void addToProperty(AddedNodeFact node, String propertyName, List<?> value, KnowledgeHelper drools) {
        JCRNodeWrapper jcrNode = node.getNode();
        try {
            long aLong = 0L;
            try {
                Property property = jcrNode.getProperty(propertyName);
                aLong = property.getLong();
            }
            catch (PathNotFoundException e) {
                logger.debug("The property to increment " + propertyName + " does not exist yet", (Throwable)e);
            }
            jcrNode.setProperty(propertyName, aLong + Long.valueOf((String)value.get(0)));
        }
        catch (RepositoryException e) {
            logger.error("Error while adding " + value + " to property " + propertyName + " for node " + node, (Throwable)e);
        }
    }

    public void addNewTag(AddedNodeFact node, String value, KnowledgeHelper drools) throws RepositoryException {
        this.taggingService.tag(node.getNode(), Arrays.asList(Patterns.COMMA.split(value)));
    }

    public void executeRuleLater(AddedNodeFact node, String propertyName, String ruleToExecute, KnowledgeHelper drools) throws SchedulerException, RepositoryException {
        String uuid = node.getNode().getIdentifier();
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Rule job: " + ruleToExecute + " on node " + uuid, RuleJob.class);
        jobDetail.setName(ruleToExecute + "-" + uuid);
        jobDetail.setGroup(BackgroundJob.getGroupName(RuleJob.class) + "." + ruleToExecute);
        JobDataMap map = jobDetail.getJobDataMap();
        map.put("ruleToExecute", ruleToExecute);
        map.put("node", uuid);
        map.put("user", ((User)drools.getWorkingMemory().getGlobal("user")).getName());
        map.put("userrealm", ((User)drools.getWorkingMemory().getGlobal("user")).getRealm());
        map.put("workspace", (String)drools.getWorkingMemory().getGlobal("workspace"));
        this.schedulerService.getScheduler().deleteJob(jobDetail.getName(), jobDetail.getGroup());
        try {
            JCRPropertyWrapper property = node.getNode().getProperty(propertyName);
            this.schedulerService.getScheduler().scheduleJob(jobDetail, this.getTrigger(node, property.getType() == 5 ? property.getDate().getTime() : property.getString(), jobDetail.getName(), jobDetail.getGroup()));
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void executeActionLater(AddedNodeFact node, String propertyName, String actionToExecute, KnowledgeHelper drools) throws SchedulerException, RepositoryException {
        JCRPropertyWrapper property = node.getNode().hasProperty(propertyName) ? node.getNode().getProperty(propertyName) : null;
        try {
            this.doScheduleAction(node, actionToExecute, this.getTrigger(node, property != null ? (property.getType() == 5 ? property.getDate().getTime() : property.getString()) : null, null, null), drools);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void scheduleAction(AddedNodeFact node, String actionToExecute, String cronExpression, KnowledgeHelper drools) throws SchedulerException, RepositoryException {
        try {
            this.doScheduleAction(node, actionToExecute, this.getTrigger(node, cronExpression, null, null), drools);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void doScheduleAction(AddedNodeFact node, String actionToExecute, Trigger trigger, KnowledgeHelper drools) throws SchedulerException, RepositoryException {
        String uuid = node.getNode().getIdentifier();
        JobDetail jobDetail = BackgroundJob.createJahiaJob("Action job: " + actionToExecute + " on node " + uuid, ActionJob.class);
        jobDetail.setName(ActionJob.getJobName(actionToExecute, uuid));
        jobDetail.setGroup(ActionJob.getJobGroup(actionToExecute));
        JobDataMap map = jobDetail.getJobDataMap();
        map.put("actionToExecute", actionToExecute);
        map.put("node", uuid);
        map.put("workspace", (String)drools.getWorkingMemory().getGlobal("workspace"));
        this.schedulerService.getScheduler().deleteJob(jobDetail.getName(), jobDetail.getGroup());
        if (trigger != null) {
            trigger.setName(jobDetail.getName() + "TRIGGER");
            this.schedulerService.getScheduler().scheduleJob(jobDetail, trigger);
        }
    }

    public void cancelActionExecution(NodeFact node, String actionToCancel, KnowledgeHelper drools) throws RepositoryException, SchedulerException {
        String jobGroup = ActionJob.getJobGroup(actionToCancel);
        String jobName = ActionJob.getJobName(actionToCancel, node.getIdentifier());
        if (this.schedulerService.getScheduler().deleteJob(jobName, jobGroup)) {
            logger.info("Action job with the name {} and group {} canceled successfully", (Object)jobName, (Object)jobGroup);
        }
    }

    private Trigger getTrigger(AddedNodeFact node, Object schedule, String jobName, String group) throws ParseException, RepositoryException {
        if (schedule == null) {
            return null;
        }
        if (schedule instanceof Date) {
            return new SimpleTrigger(jobName + "TRIGGER", group, (Date)schedule);
        }
        return String.valueOf(schedule).length() > 0 ? new CronTrigger(jobName + "TRIGGER", group, String.valueOf(schedule)) : null;
    }

    public void moveSubnodesToSplitFolder(AddedNodeFact n, KnowledgeHelper drools) throws RepositoryException {
        JCRAutoSplitUtils.applyAutoSplitRulesOnSubnodes(n.getNode());
    }

    public void moveToSplitFolder(AddedNodeFact n, KnowledgeHelper drools) throws RepositoryException {
        JCRNodeWrapper newNode;
        if (n.getNode().getParent().isNodeType("jmix:autoSplitFolders") && (newNode = JCRAutoSplitUtils.applyAutoSplitRules(n.getNode())) != null) {
            drools.delete((Object)n);
            drools.insert((Object)new AddedNodeFact(newNode));
        }
    }

    public void enableAutoSplitting(AddedNodeFact n, String splitConfig, String splitFolderNodeType, KnowledgeHelper drools) throws RepositoryException {
        JCRAutoSplitUtils.enableAutoSplitting(n.getNode(), splitConfig, splitFolderNodeType);
        Map<JCRNodeWrapper, JCRNodeWrapper> modifiedNodes = JCRAutoSplitUtils.applyAutoSplitRulesOnSubnodes(n.getNode());
        for (Map.Entry<JCRNodeWrapper, JCRNodeWrapper> modifiedNodeEntry : modifiedNodes.entrySet()) {
            try {
                drools.delete((Object)new AddedNodeFact(modifiedNodeEntry.getKey()));
                drools.insert((Object)new AddedNodeFact(modifiedNodeEntry.getValue()));
            }
            catch (FactException fe) {
                logger.debug("Seems node " + modifiedNodeEntry.getKey() + " was not in working memory, will not insert replacement.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishNode(AddedNodeFact node, KnowledgeHelper drools) throws RepositoryException {
        JCRNodeWrapper nodeWrapper = node.getNode();
        JCRSessionWrapper jcrSessionWrapper = nodeWrapper.getSession();
        jcrSessionWrapper.save();
        Set<String> languages = null;
        if (jcrSessionWrapper.getLocale() != null) {
            languages = Collections.singleton(jcrSessionWrapper.getLocale().toString());
        }
        boolean resetUser = false;
        if (JCRSessionFactory.getInstance().getCurrentUser() == null) {
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
            resetUser = true;
        }
        try {
            JCRPublicationService.getInstance().publishByMainId(nodeWrapper.getIdentifier(), jcrSessionWrapper.getWorkspace().getName(), "live", languages, false, new ArrayList<String>());
        }
        catch (Exception e) {
            logger.error("Cannot publish node : " + nodeWrapper.getPath(), (Throwable)e);
        }
        finally {
            if (resetUser) {
                JCRSessionFactory.getInstance().setCurrentUser(null);
            }
        }
    }

    public void startWorkflowOnNode(AddedNodeFact node, String processKey, String provider, KnowledgeHelper drools) throws RepositoryException {
        JCRNodeWrapper nodeWrapper = node.getNode();
        try {
            WorkflowService.getInstance().startProcessAsJob(Arrays.asList(nodeWrapper.getIdentifier()), nodeWrapper.getSession(), processKey, provider, new HashMap<String, Object>(), null);
        }
        catch (SchedulerException e) {
            logger.error("Cannot schedule job ", (Throwable)e);
        }
    }

    public void flushCache(String cacheId, KnowledgeHelper drools) {
        try {
            Cache cache = this.cacheService.getCache(cacheId, true);
            if (cache != null) {
                cache.flush();
                logger.info("Cache '" + cacheId + "' flushed.");
            } else {
                logger.debug("No cache found for name '" + cacheId + "'. Skip flushing.");
            }
        }
        catch (JahiaInitializationException e) {
            logger.debug("Cannot get cache", (Throwable)e);
        }
    }

    public void flushCacheEntry(String cacheId, String cacheEntryKey, KnowledgeHelper drools) {
        try {
            Cache cache = this.cacheService.getCache(cacheId, true);
            if (cache != null) {
                cache.remove(cacheEntryKey);
            } else {
                logger.debug("No cache found for name '" + cacheId + "'. Skip flushing.");
            }
        }
        catch (JahiaInitializationException e) {
            logger.debug("Cannot get cache", (Throwable)e);
        }
    }

    public void flushAllCaches(KnowledgeHelper drools) {
        this.cacheService.flushAllCaches();
        logger.info("All caches flushed.");
    }

    public void storeUserPasswordHistory(AddedNodeFact user, KnowledgeHelper drools) throws RepositoryException {
        this.passwordPolicyService.storePasswordHistory((JCRUserNode)user.getNode());
    }

    public void deployModule(String moduleId, AddedNodeFact site, KnowledgeHelper drools) {
        User user = (User)drools.getWorkingMemory().getGlobal("user");
        try {
            JahiaTemplateManagerService managerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
            managerService.installModule(moduleId, site.getPath(), user.getName());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    public void setSitesService(JahiaSitesService sitesService) {
        this.sitesService = sitesService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setUserManagerService(JahiaUserManagerService userMgrService) {
        this.userManagerService = userMgrService;
    }

    @Override
    public void start() throws JahiaInitializationException {
    }

    @Override
    public void stop() throws JahiaException {
    }

    public void setPasswordPolicyService(JahiaPasswordPolicyService passwordPolicyService) {
        this.passwordPolicyService = passwordPolicyService;
    }

    public void createPermission(final String path, final String name, KnowledgeHelper drools) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<String>(){

            @Override
            public String doInJCR(JCRSessionWrapper session) throws RepositoryException {
                String replacedname;
                JCRNodeWrapper node = session.getNode(path);
                if (!node.hasNode(replacedname = name.replace(":", "_"))) {
                    node.addNode(replacedname, "jnt:permission");
                }
                session.save();
                return null;
            }
        });
    }

    public void updateDependencies(AddedNodeFact node) throws RepositoryException {
        JahiaTemplatesPackage pack = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().lookupByIdAndVersion(node.getNode().getParent().getName(), new ModuleVersion(node.getName()));
        if (pack != null) {
            JCRValueWrapper[] dependencies = node.getNode().getProperty("j:dependencies").getValues();
            ArrayList<String> depends = new ArrayList<String>();
            for (JCRValueWrapper dependency : dependencies) {
                depends.add(dependency.getString());
            }
            if (!depends.equals(pack.getDepends())) {
                ServicesRegistry.getInstance().getJahiaTemplateManagerService().updateDependencies(pack, depends);
            }
        }
    }

    public void flushUserCache(NodeFact node) {
        try {
            if (node instanceof AddedNodeFact) {
                this.userManagerService.updatePathCacheAdded(node.getPath());
            } else if (node instanceof DeletedNodeFact) {
                this.userManagerService.updatePathCacheRemoved(node.getPath());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void flushGroupCache(NodeFact node) {
        try {
            if (node instanceof AddedNodeFact) {
                this.groupManagerService.updatePathCacheAdded(node.getPath());
            } else if (node instanceof DeletedNodeFact) {
                this.groupManagerService.updatePathCacheRemoved(node.getPath());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void flushGroupMembershipCache(NodeFact node) {
        try {
            this.groupManagerService.flushMembershipCache(node.getPath(), node.getSession());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSite(AddedNodeFact node) {
        try {
            this.sitesService.updateSystemSitePermissions((JCRSiteNode)node.getNode(), node.getNode().getSession());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void updateSystemSiteLanguages(AddedNodeFact node, KnowledgeHelper drools) {
        try {
            JCRSessionWrapper session = node.getNode().getSession();
            if (!node.getName().equals("systemsite") && this.sitesService.updateSystemSiteLanguages((JCRSiteNode)node.getNode(), session)) {
                JCRSiteNode siteByKey = this.sitesService.getSiteByKey("systemsite", session);
                this.sitesService.updateSystemSitePermissions(siteByKey, session);
                drools.insert((Object)new ChangedPropertyFact(new AddedNodeFact(siteByKey), siteByKey.getProperty("j:languages")));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void executeActionNow(NodeFact node, String actionToExecute, KnowledgeHelper drools) throws SchedulerException, RepositoryException {
        BackgroundAction action = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getBackgroundActions().get(actionToExecute);
        if (action != null) {
            if (node instanceof AddedNodeFact) {
                action.executeBackgroundAction(((AddedNodeFact)node).getNode());
            } else {
                action.executeBackgroundAction(node.getParent().getNode());
            }
        }
    }

    public void deleteNodesWithReference(final String nodetype, final String propertyName, final NodeFact node) throws RepositoryException {
        JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Object>(){

            @Override
            public Object doInJCR(JCRSessionWrapper session) throws RepositoryException {
                QueryManagerWrapper q = session.getWorkspace().getQueryManager();
                String sql = "select * from [" + nodetype + "] where [" + propertyName + "] = '" + node.getIdentifier() + "'";
                QueryResult qr = q.createQuery(sql, "JCR-SQL2").execute();
                NodeIterator ni = qr.getNodes();
                while (ni.hasNext()) {
                    JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
                    next.remove();
                }
                session.save();
                return null;
            }
        });
    }

    public void checkHomePage(AddedNodeFact nodeFact, KnowledgeHelper drools) throws RepositoryException {
        JCRNodeWrapper n = nodeFact.getNode();
        JCRSiteNode site = n.getResolveSite();
        JCRNodeIteratorWrapper ni = site.getNodes();
        while (ni.hasNext()) {
            JCRNodeWrapper next = (JCRNodeWrapper)ni.next();
            if (!next.hasProperty("j:isHomePage") || !next.getProperty("j:isHomePage").getBoolean() || n.getIdentifier().equals(next.getIdentifier())) continue;
            n.getProperty("j:isHomePage").remove();
            n.getSession().save();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishProfilePicture(AddedNodeFact node, KnowledgeHelper drools) throws RepositoryException {
        JCRNodeWrapper nodeWrapper = node.getNode();
        if (nodeWrapper.getPath().matches(".*/users/.*/files/profile/.*")) {
            JCRSessionWrapper jcrSessionWrapper = nodeWrapper.getSession();
            jcrSessionWrapper.save();
            boolean resetUser = false;
            if (JCRSessionFactory.getInstance().getCurrentUser() == null) {
                JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
                resetUser = true;
            }
            try {
                ArrayList<String> uuidsToPublish = new ArrayList<String>();
                uuidsToPublish.add(nodeWrapper.getIdentifier());
                uuidsToPublish.add(nodeWrapper.getParent().getIdentifier());
                uuidsToPublish.add(nodeWrapper.getParent().getParent().getIdentifier());
                JCRPublicationService.getInstance().publish(uuidsToPublish, jcrSessionWrapper.getWorkspace().getName(), "live", false, false, Collections.emptyList());
            }
            catch (Exception e) {
                logger.error("Cannot publish node : " + nodeWrapper.getPath(), (Throwable)e);
            }
            finally {
                if (resetUser) {
                    JCRSessionFactory.getInstance().setCurrentUser(null);
                }
            }
        }
    }

    public void setGroupManagerService(JahiaGroupManagerService groupManagerService) {
        this.groupManagerService = groupManagerService;
    }
}

