/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.xml.transform.TransformerException;
import org.jahia.exceptions.JahiaException;
import org.jahia.services.categories.Category;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.importexport.validation.ValidationResults;
import org.jahia.services.sites.JahiaSite;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public interface ImportExportService {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String JAHIA_URI = "http://www.jahia.org/";
    public static final String FROM = "from";
    public static final String TO = "to";
    public static final String INCLUDE_TEMPLATES = "templates";
    public static final String INCLUDE_SITE_INFOS = "siteinfos";
    public static final String INCLUDE_ALL_FILES = "allfiles";
    public static final String INCLUDE_DEFINITIONS = "definitions";
    public static final String INCLUDE_LIVE_EXPORT = "includeLive";
    public static final String INCLUDE_USERS = "includeUsers";
    public static final String INCLUDE_ROLES = "includeRoles";
    public static final String INCLUDE_MOUNTS = "includeMounts";
    public static final String VIEW_CONTENT = "content";
    public static final String VIEW_VERSION = "version";
    public static final String VIEW_METADATA = "metadata";
    public static final String VIEW_JAHIALINKS = "links";
    public static final String VIEW_ACL = "acl";
    public static final String VIEW_WORKFLOW = "wf";
    public static final String VIEW_PID = "pid";
    public static final String XSL_PATH = "xsl_path";
    public static final String NO_RECURSE = "noRecurse";
    public static final String SKIP_BINARY = "skipBinary";
    public static final String SYSTEM_VIEW = "systemView";
    public static final String SERVER_DIRECTORY = "serverDirectory";

    public void exportAll(OutputStream var1, Map<String, Object> var2) throws JahiaException, RepositoryException, SAXException, IOException, TransformerException;

    public void exportSites(OutputStream var1, Map<String, Object> var2, List<JCRSiteNode> var3) throws RepositoryException, IOException, SAXException, TransformerException;

    public void exportNode(JCRNodeWrapper var1, JCRNodeWrapper var2, OutputStream var3, Map<String, Object> var4) throws RepositoryException, SAXException, IOException, TransformerException;

    public void exportZip(JCRNodeWrapper var1, JCRNodeWrapper var2, OutputStream var3, Map<String, Object> var4) throws RepositoryException, SAXException, IOException, TransformerException;

    public void importXML(String var1, InputStream var2, int var3) throws IOException, RepositoryException, JahiaException;

    public void importZip(String var1, Resource var2, int var3) throws IOException, RepositoryException;

    public void importZip(String var1, Resource var2, int var3, JCRSessionWrapper var4) throws IOException, RepositoryException;

    public void importZip(String var1, Resource var2, int var3, JCRSessionWrapper var4, Set<String> var5, boolean var6) throws IOException, RepositoryException;

    public ValidationResults validateImportFile(JCRSessionWrapper var1, InputStream var2, String var3, List<String> var4);

    public void importSiteZip(JCRNodeWrapper var1) throws RepositoryException, IOException, JahiaException;

    public void importSiteZip(File var1, JCRSessionWrapper var2) throws RepositoryException, IOException, JahiaException;

    public void importSiteZip(Resource var1) throws RepositoryException, IOException, JahiaException;

    public void importSiteZip(Resource var1, JCRSessionWrapper var2) throws RepositoryException, IOException, JahiaException;

    public void importSiteZip(Resource var1, JahiaSite var2, Map<Object, Object> var3) throws RepositoryException, IOException;

    public void importSiteZip(Resource var1, JahiaSite var2, Map<Object, Object> var3, Resource var4, Resource var5) throws RepositoryException, IOException;

    public void importCategories(Category var1, InputStream var2);

    public List<String[]> importUsers(File var1) throws IOException, RepositoryException;
}

