/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.data.templates.ModuleState;
import org.jahia.osgi.BundleLifecycleUtils;
import org.jahia.osgi.BundleState;
import org.jahia.osgi.BundleUtils;
import org.jahia.osgi.FrameworkService;
import org.jahia.services.modulemanager.BundleBucketInfo;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.BundlePersistentInfo;
import org.jahia.services.modulemanager.InvalidModuleException;
import org.jahia.services.modulemanager.InvalidModuleKeyException;
import org.jahia.services.modulemanager.ModuleManagementException;
import org.jahia.services.modulemanager.ModuleManager;
import org.jahia.services.modulemanager.ModuleNotFoundException;
import org.jahia.services.modulemanager.OperationResult;
import org.jahia.services.modulemanager.persistence.BundlePersister;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.services.modulemanager.persistence.PersistentBundleInfoBuilder;
import org.jahia.services.modulemanager.persistence.jcr.BundleInfoJcrHelper;
import org.jahia.services.modulemanager.spi.BundleService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class ModuleManagerImpl
implements ModuleManager,
ReadOnlyModeCapable {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerImpl.class);
    private final ReadWriteLock readOnlyModeLock = new ReentrantReadWriteLock();
    private BundleService bundleService;
    private BundlePersister persister;
    private JahiaTemplateManagerService templateManagerService;
    private boolean readOnly;

    private static BundleInfo toBundleInfo(PersistentBundle persistentBundle) {
        return new BundleInfo(persistentBundle.getGroupId(), persistentBundle.getSymbolicName(), persistentBundle.getVersion());
    }

    private BundleInfo findTargetBundle(String bundleKey, String symbolicName, String version) {
        Bundle[] allBundles;
        BundleInfo targetInfo = null;
        ArrayList<Bundle> matches = new ArrayList<Bundle>();
        for (Bundle b : allBundles = FrameworkService.getBundleContext().getBundles()) {
            if (!symbolicName.equals(b.getSymbolicName()) || version != null && !version.equals(b.getVersion().toString()) || b.getState() == 1) continue;
            matches.add(b);
        }
        if (matches.size() > 1) {
            logger.warn("Found multiple bundles matching the key {}. Unable to uniquely identify target bundle", (Object)bundleKey);
        } else if (!matches.isEmpty()) {
            Bundle target = (Bundle)matches.get(0);
            targetInfo = new BundleInfo(BundleUtils.getModuleGroupId(target), target.getSymbolicName(), target.getVersion().toString());
        }
        return targetInfo;
    }

    private BundleInfo getBundleInfoGuessIfNeeded(String bundleKey) {
        BundleInfo info = null;
        if (bundleKey.indexOf(47) != -1 && (info = BundleInfo.fromKey(bundleKey)).getGroupId() != null && info.getSymbolicName() != null && info.getVersion() != null) {
            return info;
        }
        return this.findTargetBundle(bundleKey, info != null ? info.getSymbolicName() : bundleKey, info != null ? info.getVersion() : null);
    }

    private static BundleBucketInfo getBundleBucketInfo(String bundleBucketKey) {
        try {
            return BundleBucketInfo.fromKey(bundleBucketKey);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModuleKeyException(bundleBucketKey);
        }
    }

    private static BundleInfo getBundleInfo(String bundleKey) {
        try {
            return BundleInfo.fromKey(bundleKey);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidModuleKeyException(bundleKey);
        }
    }

    private OperationResult doInstall(Collection<PersistentBundle> infos, String target, boolean start, int startLevel) {
        ArrayList<BundleInfo> bundleInfos = new ArrayList<BundleInfo>(infos.size());
        for (PersistentBundle info : infos) {
            this.bundleService.install(info.getLocation(), target, false, startLevel);
            bundleInfos.add(ModuleManagerImpl.toBundleInfo(info));
        }
        if (start) {
            for (PersistentBundle info : infos) {
                this.bundleService.resolve(info, target);
            }
            for (PersistentBundle info : infos) {
                this.stopPreviousVersions(info, target);
            }
            this.refreshOtherVersions(bundleInfos, target);
            for (PersistentBundle info : infos) {
                this.bundleService.start(info, target);
            }
        }
        return OperationResult.success(bundleInfos);
    }

    @Override
    public OperationResult install(Resource bundleResource, String target) {
        return this.install(bundleResource, target, false);
    }

    @Override
    public OperationResult install(Resource bundleResource, String target, boolean start) {
        return this.install(Collections.singleton(bundleResource), target, start);
    }

    @Override
    public OperationResult install(Collection<Resource> bundleResources, String target, boolean start) {
        return this.install(bundleResources, target, start, SettingsBean.getInstance().getModuleStartLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OperationResult install(Collection<Resource> bundleResources, String target, boolean start, int startLevel) {
        this.readOnlyModeLock.readLock().lock();
        try {
            long startTime = System.currentTimeMillis();
            logger.info("Performing installation of bundles {} on target {}", bundleResources, (Object)target);
            OperationResult result = null;
            Exception error = null;
            try {
                this.assertWritable();
                ArrayList<PersistentBundle> bundleInfos = new ArrayList<PersistentBundle>(bundleResources.size());
                Iterator<Resource> iterator = bundleResources.iterator();
                while (iterator.hasNext()) {
                    Resource bundleResource;
                    boolean requiresPersisting = !((bundleResource = iterator.next()) instanceof UrlResource) || !bundleResource.getURL().getProtocol().equals("dx");
                    PersistentBundle bundleInfo = PersistentBundleInfoBuilder.build(bundleResource, requiresPersisting, requiresPersisting);
                    if (bundleInfo == null) {
                        throw new InvalidModuleException();
                    }
                    if (requiresPersisting) {
                        this.persister.store(bundleInfo);
                    }
                    bundleInfos.add(bundleInfo);
                }
                result = this.doInstall(bundleInfos, target, start, startLevel);
            }
            catch (ModuleManagementException e) {
                try {
                    error = e;
                    throw e;
                    catch (Exception e2) {
                        error = e2;
                        throw new ModuleManagementException(e2);
                    }
                }
                catch (Throwable throwable) {
                    long timeTaken = System.currentTimeMillis() - startTime;
                    if (error == null) {
                        logger.info("Installation completed for bundles {} on target {} in {} ms. Operation result: {}", new Object[]{bundleResources, target, timeTaken, result});
                        throw throwable;
                    }
                    logger.info("Installation failed for bundles {} on target {} (took {} ms). Operation error: {}", new Object[]{bundleResources, target, timeTaken, error});
                    throw throwable;
                }
            }
            long timeTaken = System.currentTimeMillis() - startTime;
            if (error == null) {
                logger.info("Installation completed for bundles {} on target {} in {} ms. Operation result: {}", new Object[]{bundleResources, target, timeTaken, result});
            } else {
                logger.info("Installation failed for bundles {} on target {} (took {} ms). Operation error: {}", new Object[]{bundleResources, target, timeTaken, error});
            }
            if (FrameworkService.getInstance().isStarted()) {
                try {
                    this.storeAllLocalPersistentStates();
                }
                catch (ModuleManagementException e) {
                    logger.warn("Failed to persist modules state", (Throwable)e);
                }
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationResult performOperation(String bundleKey, String target, BundleOperation operation) {
        OperationResult result;
        block12: {
            Exception error;
            long startTime;
            block11: {
                if (StringUtils.isEmpty((String)bundleKey)) {
                    throw new IllegalArgumentException("Bundle '" + bundleKey + "' key in invalid");
                }
                startTime = System.currentTimeMillis();
                logger.info("Performing {} operation for bundle {} on target {}", new Object[]{operation.getName(), bundleKey, target});
                result = null;
                BundleInfo info = null;
                error = null;
                try {
                    if (operation.changesModuleState()) {
                        this.assertWritable();
                    }
                    if ((info = this.getBundleInfoGuessIfNeeded(bundleKey)) == null) {
                        throw new ModuleNotFoundException(bundleKey);
                    }
                    operation.perform(info, target);
                    result = OperationResult.success(info);
                    if (error != null) break block11;
                }
                catch (ModuleManagementException e) {
                    try {
                        this.checkForMissingDependency(e, info);
                        error = e;
                        throw e;
                        catch (Exception e2) {
                            error = e2;
                            throw new ModuleManagementException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        if (error == null) {
                            logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
                            throw throwable;
                        }
                        logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
                        throw throwable;
                    }
                }
                logger.info("{} operation completed for bundle {} on target {} in {} ms. Opearation result: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, result});
                break block12;
            }
            logger.info("{} operation failed for bundle {} on target {} (took {} ms). Opearation error: {}", new Object[]{operation.getName(), bundleKey, target, System.currentTimeMillis() - startTime, error});
        }
        if (!FrameworkService.getInstance().isStarted()) return result;
        if (!operation.changesModuleState()) return result;
        try {
            this.storeAllLocalPersistentStates();
            return result;
        }
        catch (ModuleManagementException e) {
            logger.warn("Failed to persist modules state", (Throwable)e);
        }
        return result;
    }

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }

    public void setPersister(BundlePersister persister) {
        this.persister = persister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult start(String bundleKey, String target) {
        this.readOnlyModeLock.readLock().lock();
        try {
            OperationResult operationResult = this.performOperation(bundleKey, target, new BundleOperation(){

                @Override
                public String getName() {
                    return "Start";
                }

                @Override
                public boolean changesModuleState() {
                    return true;
                }

                @Override
                public void perform(BundleInfo info, String target) {
                    ModuleManagerImpl.this.bundleService.stop(info, target);
                    ModuleManagerImpl.this.stopPreviousVersions(info, target);
                    ModuleManagerImpl.this.bundleService.start(info, target);
                    ModuleManagerImpl.this.refreshOtherVersions(Collections.singleton(info), target);
                }
            });
            return operationResult;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult stop(String bundleKey, String target) {
        this.readOnlyModeLock.readLock().lock();
        try {
            OperationResult operationResult = this.performOperation(bundleKey, target, new BundleOperation(){

                @Override
                public String getName() {
                    return "Stop";
                }

                @Override
                public boolean changesModuleState() {
                    return true;
                }

                @Override
                public void perform(BundleInfo info, String target) {
                    ModuleManagerImpl.this.bundleService.stop(info, target);
                }
            });
            return operationResult;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    private void stopPreviousVersions(BundleInfo info, String target) {
        Bundle activeBundle;
        JahiaTemplatesPackage activePackage = this.templateManagerService.getTemplatePackageRegistry().lookupById(info.getSymbolicName());
        Bundle bundle = activeBundle = activePackage != null ? activePackage.getBundle() : null;
        if (activeBundle != null && activeBundle.getState() == 32) {
            BundleInfo otherInfo = BundleInfo.fromBundle(activeBundle);
            this.stopExistingVersion(info, otherInfo, target);
        }
        for (Map.Entry<Bundle, ModuleState> entry : this.templateManagerService.getModuleStates().entrySet()) {
            Bundle bundle2 = entry.getKey();
            if (bundle2 == activeBundle || bundle2.getState() != 32 || !bundle2.getSymbolicName().equals(info.getSymbolicName()) || bundle2.getVersion().toString().equals(info.getVersion())) continue;
            BundleInfo otherInfo = BundleInfo.fromBundle(bundle2);
            this.stopExistingVersion(info, otherInfo, target);
        }
    }

    private void stopExistingVersion(BundleInfo info, BundleInfo otherInfo, String target) {
        String key = info.getKey();
        String otherKey = otherInfo.getKey();
        try {
            logger.info("Stopping existing version of the module {} before starting {}...", (Object)otherKey, (Object)key);
            this.bundleService.stop(otherInfo, target);
            logger.info("...done stopping existing version of the module {} before starting {}", (Object)otherKey, (Object)key);
        }
        catch (Exception e) {
            logger.warn("Unable to stop existing version of the module " + otherKey + " before starting " + key, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult uninstall(String bundleKey, String target) {
        this.readOnlyModeLock.readLock().lock();
        try {
            OperationResult operationResult = this.performOperation(bundleKey, target, new BundleOperation(){

                @Override
                public String getName() {
                    return "Uninstall";
                }

                @Override
                public boolean changesModuleState() {
                    return true;
                }

                @Override
                public void perform(BundleInfo info, String target) {
                    ModuleManagerImpl.this.bundleService.uninstall(info, target);
                }
            });
            return operationResult;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    @Override
    public OperationResult refresh(String bundleKey, String target) {
        return this.performOperation(bundleKey, target, new BundleOperation(){

            @Override
            public String getName() {
                return "Refresh";
            }

            @Override
            public boolean changesModuleState() {
                return false;
            }

            @Override
            public void perform(BundleInfo info, String target) {
                ModuleManagerImpl.this.bundleService.refresh(info, target);
            }
        });
    }

    private void refreshOtherVersions(Collection<BundleInfo> theseVersionInfos, String target) {
        LinkedList<Bundle> otherVersions = new LinkedList<Bundle>();
        for (BundleInfo bundleInfo : theseVersionInfos) {
            otherVersions.addAll(this.getOtherVersionsToRefresh(bundleInfo));
        }
        if (otherVersions.isEmpty()) {
            return;
        }
        ArrayList<BundleInfo> otherVersionInfos = new ArrayList<BundleInfo>(otherVersions.size());
        for (Bundle otherVersion : otherVersions) {
            otherVersionInfos.add(BundleInfo.fromBundle(otherVersion));
        }
        logger.info("Refreshing bundles {} as their other versions are currently active...", otherVersionInfos);
        try {
            this.bundleService.refresh(otherVersionInfos, target);
        }
        catch (Exception exception) {
            logger.error("Error refreshing bundles", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult update(String bundleKey, String target) {
        this.readOnlyModeLock.readLock().lock();
        try {
            OperationResult operationResult = this.performOperation(bundleKey, target, new BundleOperation(){

                @Override
                public String getName() {
                    return "Update";
                }

                @Override
                public boolean changesModuleState() {
                    return true;
                }

                @Override
                public void perform(BundleInfo info, String target) {
                    ModuleManagerImpl.this.bundleService.update(info, target);
                }
            });
            return operationResult;
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, BundleService.BundleInformation> getInfo(String bundleKey, String target) {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getInfo(bundleInfo, target);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getInfos(Collection<String> bundleKeys, String target) {
        LinkedHashSet<BundleInfo> bundleInfos = new LinkedHashSet<BundleInfo>(bundleKeys.size());
        for (String bundleKey : bundleKeys) {
            BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
            bundleInfos.add(bundleInfo);
        }
        return this.bundleService.getInfos(bundleInfos, target);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getBucketInfos(String bundleBucketKey, String target) {
        BundleBucketInfo bundleBucketInfo = ModuleManagerImpl.getBundleBucketInfo(bundleBucketKey);
        return this.bundleService.getInfos(bundleBucketInfo, target);
    }

    @Override
    public Map<String, Map<String, BundleService.BundleInformation>> getAllInfos(String target) {
        return this.bundleService.getAllInfos(target);
    }

    @Override
    public BundleState getLocalState(String bundleKey) {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getLocalState(bundleInfo);
    }

    @Override
    public BundleService.BundleInformation getLocalInfo(String bundleKey) {
        BundleInfo bundleInfo = ModuleManagerImpl.getBundleInfo(bundleKey);
        return this.bundleService.getLocalInfo(bundleInfo);
    }

    @Override
    public Map<String, BundleService.BundleInformation> getBucketLocalInfos(String bundleBucketKey) {
        BundleBucketInfo bundleBucketInfo = ModuleManagerImpl.getBundleBucketInfo(bundleBucketKey);
        return this.bundleService.getLocalInfos(bundleBucketInfo);
    }

    @Override
    public Map<String, BundleService.BundleInformation> getAllLocalInfos() {
        return this.bundleService.getAllLocalInfos();
    }

    private List<Bundle> getOtherVersionsToRefresh(BundleInfo thisVersionInfo) {
        LinkedList<Bundle> result = new LinkedList<Bundle>();
        Map allModuleVersions = this.templateManagerService.getTemplatePackageRegistry().getAllModuleVersions().get(thisVersionInfo.getSymbolicName());
        if (allModuleVersions != null && allModuleVersions.size() > 1) {
            for (JahiaTemplatesPackage pkg : allModuleVersions.values()) {
                Bundle otherVersion = pkg.getBundle();
                if (otherVersion == null || otherVersion.getState() != 4 || otherVersion.getVersion().toString().equals(thisVersionInfo.getVersion()) || !this.shouldRefresh(otherVersion, thisVersionInfo)) continue;
                result.add(otherVersion);
            }
        }
        return result;
    }

    private boolean shouldRefresh(Bundle otherVersion, BundleInfo thisVersionInfo) {
        FrameworkWiring frameworkWiring = BundleLifecycleUtils.getFrameworkWiring();
        Collection dependencies = frameworkWiring.getDependencyClosure(Collections.singleton(otherVersion));
        for (Bundle dependency : dependencies) {
            if (!dependency.getSymbolicName().equals(thisVersionInfo.getSymbolicName()) || !dependency.getVersion().toString().equals(thisVersionInfo.getVersion())) continue;
            return false;
        }
        return true;
    }

    public void setTemplateManagerService(JahiaTemplateManagerService templateManagerService) {
        this.templateManagerService = templateManagerService;
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        this.readOnlyModeLock.writeLock().lock();
        try {
            this.readOnly = enable;
        }
        finally {
            this.readOnlyModeLock.writeLock().unlock();
        }
    }

    @Override
    public int getReadOnlyModePriority() {
        return 900;
    }

    private void assertWritable() {
        if (this.readOnly) {
            throw new ReadOnlyModeException("The Module Manager is in read only mode: no operations that change module state are available");
        }
    }

    @Override
    public Collection<BundlePersistentInfo> storeAllLocalPersistentStates() {
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            Collection bundleInfos = Arrays.stream(FrameworkService.getBundleContext().getBundles()).map(BundlePersistentInfo::new).collect(Collectors.toSet());
            BundleInfoJcrHelper.storePersistentStates(bundleInfos);
            Collection collection = bundleInfos;
            return collection;
        }
        catch (ModuleManagementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleManagementException(e);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    @Override
    public OperationResult applyBundlesPersistentStates(String target) {
        Predicate<BundlePersistentInfo> persistentStateFilter = bundle -> bundle.getStartLevel() > 0 && "dx".equals(bundle.getLocationProtocol());
        this.readOnlyModeLock.readLock().lock();
        try {
            this.assertWritable();
            Collection persistentStates = BundleInfoJcrHelper.getPersistentStates().stream().filter(persistentStateFilter).collect(Collectors.toList());
            List<BundleInfo> installedAndUpdatedBundles = this.installMissingBundlesFromPersistentStates(persistentStates, target);
            Collection bundles = Arrays.stream(FrameworkService.getBundleContext().getBundles()).map(BundlePersistentInfo::new).collect(Collectors.toSet());
            for (BundlePersistentInfo persistentState : persistentStates) {
                bundles.stream().filter(bundle -> bundle.isSameVersionAs(persistentState)).findFirst().ifPresent(bundle -> {
                    try {
                        OperationResult result = this.applyPersistentState(bundle.getLocation(), bundle.getState(), persistentState.getState(), target);
                        installedAndUpdatedBundles.addAll(result.getBundleInfos());
                    }
                    catch (Exception e) {
                        logger.info("Cannot apply state for bundle {} reason: {}", (Object)bundle.getSymbolicName(), (Object)e.getMessage());
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                });
            }
            OperationResult operationResult = OperationResult.success(Lists.newArrayList((Iterable)Sets.newHashSet(installedAndUpdatedBundles)));
            return operationResult;
        }
        catch (ModuleManagementException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleManagementException(e);
        }
        finally {
            this.readOnlyModeLock.readLock().unlock();
        }
    }

    private List<BundleInfo> installMissingBundlesFromPersistentStates(Collection<BundlePersistentInfo> persistentStates, String target) {
        Map installedBundles = Arrays.stream(FrameworkService.getBundleContext().getBundles()).map(BundlePersistentInfo::new).collect(Collectors.groupingBy(BundlePersistentInfo::getSymbolicName, Collectors.mapping(BundlePersistentInfo::getVersion, Collectors.toSet())));
        ArrayList<BundleInfo> installedBundlesInfo = new ArrayList<BundleInfo>();
        for (BundlePersistentInfo persistentState : persistentStates) {
            Set installedVersions = installedBundles.get(persistentState.getSymbolicName());
            if (installedVersions != null && installedVersions.contains(persistentState.getVersion())) continue;
            try {
                this.bundleService.install(persistentState.getLocation(), target, false, persistentState.getStartLevel());
                installedBundlesInfo.add(BundleInfo.fromKey(persistentState.getLocation()));
            }
            catch (Exception e) {
                logger.error("Cannot install {}", (Object)persistentState.getLocation(), (Object)e);
            }
        }
        return installedBundlesInfo;
    }

    private OperationResult applyPersistentState(String bundleLocation, int currentState, int persistentState, String target) {
        if (currentState != persistentState) {
            switch (persistentState) {
                case 32: {
                    return this.start(bundleLocation, target);
                }
                case 2: {
                    return this.stop(bundleLocation, target);
                }
            }
            return OperationResult.success(Collections.emptyList());
        }
        return OperationResult.success(Collections.emptyList());
    }

    private Map<String, Object> missingDependency(BundleInfo info) {
        for (Bundle b : this.templateManagerService.getInstalledBundles()) {
            String[] dependencies;
            List missing;
            if (!b.getSymbolicName().equals(info.getSymbolicName()) || (missing = Arrays.stream(dependencies = ((String)b.getHeaders().get("Jahia-Depends")).split(",")).filter(dep -> this.templateManagerService.getAnyDeployedTemplatePackage((String)dep) == null).collect(Collectors.toList())).isEmpty()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("bundle", b);
            map.put("dependency", missing.get(0));
            return map;
        }
        return Collections.emptyMap();
    }

    private void checkForMissingDependency(Exception e, BundleInfo info) {
        Map<String, Object> missing;
        if (e.getCause() instanceof BundleException && ((BundleException)e.getCause()).getType() == 4 && !(missing = this.missingDependency(info)).isEmpty()) {
            throw new ModuleManagementException(String.format("Bundle %s has unresolved dependency %s and won't be started", missing.get("bundle"), missing.get("dependency")));
        }
    }

    private static interface BundleOperation {
        public static final String REFRESH = "Refresh";
        public static final String STOP = "Stop";
        public static final String START = "Start";
        public static final String UNINSTALL = "Uninstall";

        public String getName();

        public boolean changesModuleState();

        public void perform(BundleInfo var1, String var2);
    }
}

