/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.jahia.services.modulemanager.BundleInfo;
import org.springframework.core.io.Resource;

public class PersistentBundle
extends BundleInfo {
    private static final long serialVersionUID = -1719708168071531703L;
    private String checksum;
    private String displayName;
    private long lastModified;
    private Resource resource;
    private boolean transformationRequired;

    public PersistentBundle(String groupId, String symbolicName, String version) {
        super(groupId, symbolicName, version);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof PersistentBundle && StringUtils.equals((String)this.getChecksum(), (String)((PersistentBundle)obj).getChecksum());
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return "dx:" + this.getKey();
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getKey()).append((Object)this.getChecksum()).toHashCode();
    }

    public boolean isTransformationRequired() {
        return this.transformationRequired;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setResource(Resource jarFile) {
        this.resource = jarFile;
    }

    public void setTransformationRequired(boolean transformationRequired) {
        this.transformationRequired = transformationRequired;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

