/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.persistence.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.modulemanager.BundleInfo;
import org.jahia.services.modulemanager.BundlePersistentInfo;
import org.jahia.services.modulemanager.persistence.PersistentBundle;
import org.jahia.settings.SettingsBean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingFunction;

public final class BundleInfoJcrHelper {
    private static final Logger logger = LoggerFactory.getLogger(BundleInfoJcrHelper.class);
    private static final String NODE_TYPE_BUNDLE = "jnt:moduleManagementBundle";
    public static final String NODE_TYPE_FOLDER = "jnt:moduleManagementBundleFolder";
    public static final String NODE_TYPE_ROOT = "jnt:moduleManagement";
    public static final String NODE_MODULE_MANAGENENT = "module-management";
    public static final String NODE_BUNDLES = "bundles";
    public static final String PATH_MODULE_MANAGEMENT = "/module-management";
    public static final String PATH_BUNDLES = "/module-management/bundles";
    public static final String PROP_BUNDLES_PERSISTENT_STATE = "j:bundlesPersistentState";

    public static void storePersistentStates(Collection<BundlePersistentInfo> bundles) throws RepositoryException {
        JSONArray bundleListJson = new JSONArray((Collection)bundles.stream().map(ThrowingFunction.unchecked(bundle -> {
            JSONObject obj = new JSONObject();
            obj.put("symbolicName", (Object)bundle.getSymbolicName());
            obj.put("version", (Object)bundle.getVersion());
            obj.put("location", (Object)bundle.getLocation());
            obj.put("state", bundle.getState());
            obj.put("startLevel", bundle.getStartLevel());
            return obj;
        })).collect(Collectors.toList()));
        JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            session.getNode(PATH_MODULE_MANAGEMENT).setProperty(PROP_BUNDLES_PERSISTENT_STATE, bundleListJson.toString());
            session.save();
            return null;
        });
    }

    public static Collection<BundlePersistentInfo> getPersistentStates() throws JSONException, RepositoryException {
        String propertyValue = JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            JCRNodeWrapper node = session.getNode(PATH_MODULE_MANAGEMENT);
            return node.hasProperty(PROP_BUNDLES_PERSISTENT_STATE) ? node.getProperty(PROP_BUNDLES_PERSISTENT_STATE).getValue().getString() : "";
        });
        if (StringUtils.isEmpty((String)propertyValue)) {
            return Collections.emptyList();
        }
        ArrayList<BundlePersistentInfo> persistentStates = new ArrayList<BundlePersistentInfo>();
        JSONArray jsonArray = new JSONArray(propertyValue);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject o = jsonArray.getJSONObject(i);
            persistentStates.add(new BundlePersistentInfo(o.getString("location"), o.getString("symbolicName"), o.getString("version"), o.getInt("state"), o.optInt("startLevel", 0)));
        }
        return persistentStates;
    }

    static JCRNodeWrapper findTargetNode(String bundleKey, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper target = null;
        String path = BundleInfoJcrHelper.getJcrPath(BundleInfo.fromKey(bundleKey));
        if (session.nodeExists(path)) {
            target = session.getNode(path);
        }
        if (target == null && SettingsBean.getInstance().isClusterActivated()) {
            session.refresh(true);
            JCRNodeWrapper jCRNodeWrapper = target = session.nodeExists(path) ? session.getNode(path) : null;
        }
        if (target != null) {
            logger.debug("Bundle node for key {} found at {}", (Object)bundleKey, (Object)path);
        }
        return target;
    }

    static String getJcrPath(BundleInfo bundleInfo) {
        StringBuilder path = new StringBuilder();
        path.append("/module-management/bundles/");
        if (StringUtils.isNotEmpty((String)bundleInfo.getGroupId())) {
            path.append(bundleInfo.getGroupId().replace('.', '/')).append('/');
        }
        path.append(bundleInfo.getSymbolicName()).append('/').append(bundleInfo.getVersion()).append('/').append(bundleInfo.getSymbolicName()).append('-').append(bundleInfo.getVersion()).append(".jar");
        return path.toString();
    }

    static String getJcrPath(PersistentBundle bundleInfo) {
        StringBuilder path = new StringBuilder();
        path.append("/module-management/bundles/");
        if (StringUtils.isNotEmpty((String)bundleInfo.getGroupId())) {
            path.append(bundleInfo.getGroupId().replace('.', '/')).append('/');
        }
        path.append(bundleInfo.getSymbolicName()).append('/').append(bundleInfo.getVersion()).append('/').append(bundleInfo.getSymbolicName()).append('-').append(bundleInfo.getVersion()).append(".jar");
        return path.toString();
    }

    static String getJcrPath(String bundleKey) {
        return BundleInfoJcrHelper.getJcrPath(BundleInfo.fromKey(bundleKey));
    }

    static JCRNodeWrapper getOrCreateTargetNode(PersistentBundle bundleInfo, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper target = session.getNode(PATH_BUNDLES);
        if (bundleInfo.getGroupId() != null) {
            target = BundleInfoJcrHelper.mkdirs(target, StringUtils.split((String)bundleInfo.getGroupId(), (char)'.'), session);
        }
        target = BundleInfoJcrHelper.mkdir(target, bundleInfo.getSymbolicName(), session);
        target = BundleInfoJcrHelper.mkdir(target, bundleInfo.getVersion(), session);
        String nodeName = bundleInfo.getSymbolicName() + '-' + bundleInfo.getVersion() + ".jar";
        try {
            target = target.getNode(nodeName);
        }
        catch (PathNotFoundException e) {
            target = target.addNode(nodeName, NODE_TYPE_BUNDLE);
        }
        return target;
    }

    public static JCRNodeWrapper getRootNode(JCRSessionWrapper session) throws RepositoryException {
        return session.getNode(PATH_MODULE_MANAGEMENT);
    }

    private static JCRNodeWrapper mkdir(JCRNodeWrapper startNode, String childName, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper child = null;
        try {
            child = startNode.getNode(childName);
        }
        catch (PathNotFoundException e) {
            child = startNode.addNode(childName, NODE_TYPE_FOLDER);
        }
        return child;
    }

    private static JCRNodeWrapper mkdirs(JCRNodeWrapper startNode, String[] pathSegments, JCRSessionWrapper session) throws RepositoryException {
        for (String childName : pathSegments) {
            startNode = BundleInfoJcrHelper.mkdir(startNode, childName, session);
        }
        return startNode;
    }

    private BundleInfoJcrHelper() {
    }
}

