/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.modulemanager.util;

import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.modulemanager.util.PropertiesList;
import org.jahia.services.modulemanager.util.PropertiesValues;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PropertiesManager {
    private Map<String, String> props;

    public PropertiesManager(Map<String, String> props) {
        this.props = props;
    }

    public PropertiesValues getValues() {
        return new PropertiesValuesImpl("", '.');
    }

    private class PropertiesListImpl
    implements PropertiesList {
        private PropertiesValuesImpl values;
        private int size;

        public PropertiesListImpl(String path) {
            this.values = new PropertiesValuesImpl(path, '[');
            this.size = this.values.getKeys().stream().map(k -> Integer.parseInt(k.substring(0, k.indexOf(93)))).max(Comparator.naturalOrder()).orElse(-1) + 1;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        private String getKey(int index) {
            if (index >= this.size) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return index + "]";
        }

        private String getNextKey() {
            return this.size + "]";
        }

        @Override
        public String getProperty(int index) {
            return this.values.getProperty(this.getKey(index));
        }

        @Override
        public void addProperty(String value) {
            this.values.setProperty(this.getNextKey(), value);
            ++this.size;
        }

        @Override
        public void setProperty(int index, String value) {
            this.values.setProperty(this.getKey(index), value);
        }

        @Override
        public Boolean getBooleanProperty(int index) {
            return this.values.getBooleanProperty(this.getKey(index));
        }

        @Override
        public void addBooleanProperty(boolean value) {
            this.values.setBooleanProperty(this.getNextKey(), value);
            ++this.size;
        }

        @Override
        public void setBooleanProperty(int index, boolean value) {
            this.values.setBooleanProperty(this.getKey(index), value);
        }

        @Override
        public Integer getIntegerProperty(int index) {
            return this.values.getIntegerProperty(this.getKey(index));
        }

        @Override
        public void addIntegerProperty(int value) {
            this.values.setIntegerProperty(this.getNextKey(), value);
            ++this.size;
        }

        @Override
        public void setIntegerProperty(int index, int value) {
            this.values.setIntegerProperty(this.getKey(index), value);
        }

        @Override
        public byte[] getBinaryProperty(int index) {
            return this.values.getBinaryProperty(this.getKey(index));
        }

        @Override
        public void addBinaryProperty(byte[] value) {
            this.values.setBinaryProperty(this.getNextKey(), value);
            ++this.size;
        }

        @Override
        public void setBinaryProperty(int index, byte[] value) {
            this.values.setBinaryProperty(this.getKey(index), value);
        }

        @Override
        public PropertiesValuesImpl getValues(int index) {
            return this.values.getValues(this.getKey(index));
        }

        @Override
        public PropertiesValuesImpl addValues() {
            PropertiesValuesImpl v = this.values.getValues(this.getNextKey());
            ++this.size;
            return v;
        }

        @Override
        public PropertiesListImpl getList(int index) {
            return this.values.getList(this.getKey(index));
        }

        @Override
        public PropertiesListImpl addList() {
            PropertiesListImpl v = this.values.getList(this.getNextKey());
            ++this.size;
            return v;
        }

        @Override
        public JSONArray toJSON() throws JSONException {
            JSONArray response = new JSONArray();
            for (int i = 0; i < this.size; ++i) {
                if (this.getList((int)i).size > 0) {
                    response.put((Object)this.getList(i).toJSON());
                    continue;
                }
                if (!this.getValues(i).isEmpty()) {
                    response.put((Object)this.getValues(i).toJSON());
                    continue;
                }
                if (this.getProperty(i) != null) {
                    response.put((Object)this.getProperty(i));
                    continue;
                }
                response.put(null);
            }
            return response;
        }

        @Override
        public void updateFromJSON(JSONArray array) throws JSONException {
            int length = array.length();
            for (int index = 0; index < length; ++index) {
                Object value = array.get(index);
                if (value instanceof JSONObject) {
                    this.getValues(index).updateFromJSON((JSONObject)value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    this.getList(index).updateFromJSON((JSONArray)value);
                    continue;
                }
                this.setProperty(index, value.toString());
            }
        }
    }

    private class PropertiesValuesImpl
    implements PropertiesValues {
        private String path;
        private Map<String, String> currentProps;
        private char delimiter;

        public PropertiesValuesImpl(String path, char delimiter) {
            this.path = path;
            this.delimiter = delimiter;
            this.initProps();
        }

        private void initProps() {
            this.currentProps = this.path.length() == 0 ? PropertiesManager.this.props : PropertiesManager.this.props.keySet().stream().filter(k -> k.startsWith(this.path + this.delimiter)).collect(Collectors.toMap(s -> s.substring(this.path.length() + 1), PropertiesManager.this.props::get));
        }

        private String getKey(String name) {
            return this.path.length() == 0 ? name : this.path + this.delimiter + name;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public String getProperty(String name) {
            return this.currentProps.get(name);
        }

        @Override
        public Boolean getBooleanProperty(String name) {
            return this.currentProps.containsKey(name) ? Boolean.valueOf(this.currentProps.get(name)) : null;
        }

        @Override
        public Integer getIntegerProperty(String name) {
            return this.currentProps.containsKey(name) ? Integer.valueOf(this.currentProps.get(name)) : null;
        }

        @Override
        public byte[] getBinaryProperty(String name) {
            return this.currentProps.containsKey(name) ? Base64.getDecoder().decode(this.currentProps.get(name)) : null;
        }

        @Override
        public void setProperty(String name, String value) {
            PropertiesManager.this.props.put(this.getKey(name), value);
            this.initProps();
        }

        @Override
        public void setBooleanProperty(String name, boolean value) {
            this.setProperty(name, Boolean.toString(value));
        }

        @Override
        public void setIntegerProperty(String name, int value) {
            this.setProperty(name, Integer.toString(value));
        }

        @Override
        public void setBinaryProperty(String name, byte[] data) {
            this.setProperty(name, Base64.getEncoder().encodeToString(data));
        }

        @Override
        public String removeProperty(String name) {
            return (String)PropertiesManager.this.props.remove(this.getKey(name));
        }

        @Override
        public PropertiesListImpl getList(String name) {
            String subPath = this.getKey(name);
            return new PropertiesListImpl(subPath);
        }

        @Override
        public PropertiesValuesImpl getValues(String name) {
            String subPath = this.getKey(name);
            return new PropertiesValuesImpl(subPath, '.');
        }

        @Override
        public void remove(String name) {
            String k = this.getKey(name);
            PropertiesManager.this.props.keySet().removeAll(PropertiesManager.this.props.keySet().stream().filter(key -> key.equals(k) || key.startsWith(k + '.') || key.startsWith(k + '[')).collect(Collectors.toList()));
        }

        @Override
        public Set<String> getKeys() {
            this.initProps();
            return this.currentProps.keySet().stream().flatMap(s -> Arrays.stream(StringUtils.split((String)s, (String)"[.")).limit(1L)).collect(Collectors.toSet());
        }

        @Override
        public JSONObject toJSON() throws JSONException {
            JSONObject response = new JSONObject();
            for (String key : this.getKeys()) {
                if (this.getList(key).size > 0) {
                    response.put(key, (Object)this.getList(key).toJSON());
                    continue;
                }
                if (!this.getValues(key).isEmpty()) {
                    response.put(key, (Object)this.getValues(key).toJSON());
                    continue;
                }
                response.put(key, (Object)this.getProperty(key));
            }
            return response;
        }

        @Override
        public void updateFromJSON(JSONObject object) throws JSONException {
            Iterator it = object.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = object.get(key);
                if (value instanceof JSONObject) {
                    this.getValues(key).updateFromJSON((JSONObject)value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    this.getList(key).updateFromJSON((JSONArray)value);
                    continue;
                }
                this.setProperty(key, value.toString());
            }
        }

        public boolean isEmpty() {
            return this.currentProps.isEmpty();
        }
    }
}

