/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.jahia.services.notification.ProxyAddressSelector;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.StringResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class HttpClientService
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    private HttpClient fallbackHttpClient;
    private Map<String, HttpClient> httpClients = new HashMap<String, HttpClient>(3);
    private ServletContext servletContext;

    private static HttpClient cloneHttpClient(HttpClient source) {
        Credentials proxyCredentials;
        HttpClient cloned = new HttpClient(source.getParams(), source.getHttpConnectionManager());
        String sourceProxyHost = source.getHostConfiguration().getProxyHost();
        if (sourceProxyHost != null) {
            cloned.getHostConfiguration().setProxy(sourceProxyHost, source.getHostConfiguration().getProxyPort());
        }
        if ((proxyCredentials = source.getState().getProxyCredentials(AuthScope.ANY)) != null) {
            HttpState state = new HttpState();
            state.setProxyCredentials(AuthScope.ANY, proxyCredentials);
            cloned.setState(state);
        }
        return cloned;
    }

    private static String initHttpClient(HttpClient client, String protocol) {
        String host = System.getProperty(protocol + ".proxyHost");
        int port = Integer.getInteger(protocol + ".proxyPort", -1);
        port = port != -1 ? port : Protocol.getProtocol((String)protocol).getDefaultPort();
        client.getHostConfiguration().setProxy(host, port);
        String key = host + ':' + port;
        UsernamePasswordCredentials credentials = null;
        String user = System.getProperty(protocol + ".proxyUser");
        if (StringUtils.isNotEmpty((String)user)) {
            credentials = new UsernamePasswordCredentials(user, System.getProperty(protocol + ".proxyPassword"));
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
        }
        logger.info("Initialized HttpClient for {} protocol using proxy {} {} credentials", (Object[])new String[]{protocol.toUpperCase(), key, credentials != null ? "with" : "without"});
        return key;
    }

    public static boolean isAbsoluteUrl(String url) {
        return ImportSupport.isAbsoluteUrl((String)url);
    }

    public String executeGet(String url) throws IllegalArgumentException {
        return this.executeGet(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url, Map<String, String> headers) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using GET method", (Object)url);
        }
        String content = null;
        GetMethod httpMethod = new GetMethod(url);
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addRequestHeader(header.getKey(), header.getValue());
            }
        }
        try {
            this.getHttpClient(url).executeMethod((HttpMethod)httpMethod);
            StatusLine statusLine = httpMethod.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                content = httpMethod.getResponseBodyAsString();
            } else {
                logger.warn("Connection to URL: " + url + " failed with status " + statusLine);
            }
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public String executePost(String url, Map<String, String> parameters, Map<String, String> headers) throws IllegalArgumentException {
        return this.executePost(url, parameters, headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executePost(String url, Map<String, String> parameters, Map<String, String> headers, HttpState state) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the URL {} using POST method with parameters {}", (Object)url, parameters);
        }
        String content = null;
        PostMethod httpMethod = new PostMethod(url);
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                httpMethod.addParameter(param.getKey(), param.getValue());
            }
        }
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpMethod.addRequestHeader(header.getKey(), header.getValue());
            }
        }
        try {
            this.getHttpClient(url).executeMethod(null, (HttpMethod)httpMethod, state);
            StatusLine statusLine = httpMethod.getStatusLine();
            if (statusLine != null && statusLine.getStatusCode() == 200) {
                content = httpMethod.getResponseBodyAsString();
            } else {
                logger.warn("Connection to URL: " + url + " failed with status " + statusLine);
            }
        }
        catch (HttpException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to get the content of the URL: " + url + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public String getAbsoluteResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (!HttpClientService.isAbsoluteUrl(url)) {
            throw new IllegalArgumentException("Cannot handle non-absolute URL: " + url);
        }
        return this.executeGet(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContextResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Asked to get content from the context resource: " + url);
        }
        String content = null;
        InputStream is = this.servletContext.getResourceAsStream(url);
        if (is != null) {
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)SettingsBean.getInstance().getCharacterEncoding());
                content = writer.toString();
            }
            catch (IOException e) {
                logger.warn("Error reading content of the resource " + url + ". Cause: " + e.getMessage(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        } else {
            logger.warn("Unable to find context resource at path " + url);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    @Deprecated
    public HttpClient getHttpClient() {
        return this.getHttpClient(null);
    }

    public HttpClient getHttpClient(String url) {
        HttpClient selectedClient = null;
        if (url == null) {
            selectedClient = this.fallbackHttpClient;
        } else if (this.httpClients.size() > 1) {
            try {
                String key = ProxyAddressSelector.getProxyForUrl(url);
                logger.debug("Using proxy address {} for URL {}", (Object)key, (Object)url);
                selectedClient = this.httpClients.get(key);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (selectedClient == null) {
            selectedClient = this.httpClients.get(null);
        }
        return selectedClient;
    }

    public String getResourceAsString(String url) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalArgumentException("Provided URL is null");
        }
        return HttpClientService.isAbsoluteUrl(url) ? this.getAbsoluteResourceAsString(url) : this.getContextResourceAsString(url);
    }

    public String getResourceAsString(String url, HttpServletRequest request, HttpServletResponse response) throws IllegalArgumentException {
        String content;
        block11: {
            if (StringUtils.isEmpty((String)url)) {
                throw new IllegalArgumentException("Provided URL is null");
            }
            if (HttpClientService.isAbsoluteUrl(url)) {
                return this.getAbsoluteResourceAsString(url);
            }
            if (!url.startsWith("/")) {
                throw new IllegalArgumentException("Provided relative URL does not start with a '/'");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Asked to get content from the URL: " + url);
            }
            content = null;
            RequestDispatcher rd = request.getRequestDispatcher(url);
            if (rd != null) {
                StringResponseWrapper wrapper = new StringResponseWrapper(response);
                try {
                    rd.include((ServletRequest)request, (ServletResponse)wrapper);
                    if (wrapper.getStatus() < 200 || wrapper.getStatus() > 299) {
                        logger.warn("Unable to get the content of the resource " + url + ". Got response status code: " + wrapper.getStatus());
                        break block11;
                    }
                    content = wrapper.getString();
                }
                catch (Exception e) {
                    logger.warn("Unable to get the content of the resource " + url + ". Cause: " + e.getMessage(), (Throwable)e);
                }
            } else {
                logger.warn("Unable to get a RequestDispatcher for the path " + url);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieved " + (content != null ? content.length() : 0) + " characters as a response");
            if (logger.isTraceEnabled()) {
                logger.trace("Content:\n" + content);
            }
        }
        return content;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClients.put(null, httpClient);
        if (StringUtils.isNotEmpty((String)System.getProperty("https.proxyHost"))) {
            HttpClient httpsProxyClient = HttpClientService.cloneHttpClient(httpClient);
            String key = HttpClientService.initHttpClient(httpsProxyClient, "https");
            this.httpClients.put(key, httpsProxyClient);
            this.fallbackHttpClient = httpsProxyClient;
        }
        if (StringUtils.isNotEmpty((String)System.getProperty("http.proxyHost"))) {
            HttpClient httpProxyClient = HttpClientService.cloneHttpClient(httpClient);
            this.httpClients.put(HttpClientService.initHttpClient(httpProxyClient, "http"), httpProxyClient);
            if (this.fallbackHttpClient == null) {
                this.fallbackHttpClient = httpProxyClient;
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void shutdown() {
        logger.info("Shutting down HttpClient...");
        try {
            for (Map.Entry<String, HttpClient> client : this.httpClients.entrySet()) {
                this.shutdown(client.getValue());
            }
            MultiThreadedHttpConnectionManager.shutdownAll();
        }
        catch (Exception e) {
            logger.warn("Error shutting down HttpClient. Cause: " + e.getMessage(), (Throwable)e);
        }
        logger.info("...done");
    }

    private void shutdown(HttpClient client) {
        try {
            if (client.getHttpConnectionManager() instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)client.getHttpConnectionManager()).shutdown();
            } else if (client.getHttpConnectionManager() instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)client.getHttpConnectionManager()).shutdown();
            }
        }
        catch (Exception e) {
            logger.warn("Error shutting down HttpClient. Cause: " + e.getMessage(), (Throwable)e);
        }
    }
}

