/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.notification;

import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

final class ProxyAddressSelector {
    private static final ProxySelector PROXY_SELECTOR = ProxySelector.getDefault();

    private static Proxy filter(List<Proxy> proxies) {
        Object result = null;
        for (int i = 0; result == null && i < proxies.size(); ++i) {
            Proxy p = proxies.get(i);
            if (p.type() != Proxy.Type.HTTP) continue;
            return p;
        }
        return null;
    }

    public static String getProxyForUrl(String url) throws IllegalArgumentException {
        Proxy proxy = null;
        if (url != null && url.length() > 0 && url.charAt(0) != '/') {
            try {
                proxy = ProxyAddressSelector.filter(PROXY_SELECTOR.select(new URI(ProxyAddressSelector.normalizeUrl(url))));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Cannot convert URL to URI: " + url, e);
            }
        }
        return proxy != null && proxy.address() != null ? proxy.address().toString() : null;
    }

    private static String normalizeUrl(String url) {
        if (!url.regionMatches(true, 0, "http://", 0, "http://".length()) && !url.regionMatches(true, 0, "https://", 0, "https://".length())) {
            return "http://" + url;
        }
        return url;
    }

    private ProxyAddressSelector() {
    }
}

