/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.query;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;

public class QOMBuilder {
    private List<Column> columns;
    private Constraint constraint;
    private List<Ordering> orderings;
    private QueryObjectModelFactory qomFactory;
    private Source source;
    private ValueFactory valueFactory;

    public QOMBuilder(QueryObjectModelFactory qomFactory, ValueFactory valueFactory) {
        this.qomFactory = qomFactory;
        this.valueFactory = valueFactory;
        this.orderings = new LinkedList<Ordering>();
        this.columns = new LinkedList<Column>();
    }

    public void andConstraint(Constraint c) throws InvalidQueryException, RepositoryException {
        if (c == null) {
            return;
        }
        this.constraint = this.constraint != null ? this.getQOMFactory().and(this.constraint, c) : c;
    }

    public QueryObjectModel createQOM() throws InvalidQueryException, RepositoryException {
        return this.getQOMFactory().createQuery(this.source, this.constraint, this.orderings.toArray(new Ordering[this.getOrderings().size()]), this.columns.toArray(new Column[this.getColumns().size()]));
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public List<Ordering> getOrderings() {
        return this.orderings;
    }

    public QueryObjectModelFactory getQOMFactory() {
        return this.qomFactory;
    }

    public Source getSource() {
        return this.source;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void orConstraint(Constraint c) throws InvalidQueryException, RepositoryException {
        if (c == null) {
            return;
        }
        this.constraint = this.constraint != null ? this.getQOMFactory().or(this.constraint, c) : c;
    }

    public void setSource(Source s) {
        this.source = s;
    }
}

