/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Captcha;
import org.jahia.bin.DocumentConverter;
import org.jahia.bin.Find;
import org.jahia.bin.FindPrincipal;
import org.jahia.bin.FindUser;
import org.jahia.bin.FindUsersAndGroups;
import org.jahia.bin.FindUsersAndGroupsInAcl;
import org.jahia.bin.Initializers;
import org.jahia.bin.Login;
import org.jahia.bin.Logout;
import org.jahia.bin.Render;
import org.jahia.params.valves.LoginConfig;
import org.jahia.params.valves.LogoutConfig;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.View;
import org.jahia.services.render.scripting.Script;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Url;

public class URLGenerator {
    private static final String SLASH_LIVE_SLASH = "/live/";
    private static final String SLASH_EDIT_SLASH = "/default/";
    private String base;
    private String live;
    private String edit;
    private String preview;
    private String contribute;
    private String studio;
    private String studioVisual;
    private String find;
    private String initializers;
    private Resource resource;
    private RenderContext context;
    private Map<String, String> languages;
    private Map<String, String> templates;
    private Map<String, String> templateTypes;
    private Map<String, String> bases;
    private String templatesPath;
    private String baseLive;
    private String baseContribute;
    private String baseEdit;
    private String basePreview;
    private String baseUserBoardEdit;
    private String baseUserBoardLive;
    private String baseUserBoardFrameEdit;
    private String baseUserBoardFrameLive;
    private String convert;
    private String myProfile;
    private String server;
    private String login;
    private String logout;
    private String languageCode;

    public URLGenerator(RenderContext context, Resource resource) {
        this.context = context;
        this.resource = resource;
        this.initURL();
        if (context.getURLGenerator() == null) {
            context.setURLGenerator(this);
        }
    }

    public boolean uses(Resource resource) {
        return this.resource.equals(resource);
    }

    protected void initURL() {
        this.languageCode = this.resource.getLocale().toString();
        this.base = this.getBase(this.languageCode);
        String resourcePath = this.getResourcePath();
        String renderServletPath = Render.getRenderServletPath();
        String liveLanguage = SLASH_LIVE_SLASH + this.languageCode;
        String editLanguage = SLASH_EDIT_SLASH + this.languageCode;
        this.baseLive = renderServletPath + liveLanguage;
        this.live = this.baseLive + resourcePath;
        if (!SettingsBean.getInstance().isDistantPublicationServerMode()) {
            this.baseEdit = "/cms/edit" + editLanguage;
            this.edit = this.baseEdit + resourcePath;
            this.baseContribute = "/jahia/page-composer" + editLanguage;
            this.contribute = this.baseContribute + resourcePath;
        }
        this.basePreview = renderServletPath + editLanguage;
        this.preview = this.basePreview + resourcePath;
        String workspaceLanguage = "/" + this.resource.getWorkspace() + "/" + this.languageCode;
        this.find = Find.getFindServletPath() + workspaceLanguage;
        this.initializers = Initializers.getInitializersServletPath() + workspaceLanguage;
        this.convert = DocumentConverter.getPath() + "/" + this.resource.getWorkspace();
        this.templatesPath = "/modules";
        this.baseUserBoardEdit = "/cms/dashboard" + editLanguage;
        this.baseUserBoardLive = "/cms/dashboard" + liveLanguage;
        this.baseUserBoardFrameEdit = "/cms/dashboardframe" + editLanguage;
        this.baseUserBoardFrameLive = "/cms/dashboardframe" + liveLanguage;
    }

    public String getResourcePath() {
        return this.context.getMainResource().getNode().getPath() + (!"default".equals(this.context.getMainResource().getTemplate()) ? "." + this.context.getMainResource().getTemplate() + "." : ".") + this.context.getMainResource().getTemplateType();
    }

    public String getContext() {
        return this.context.getRequest().getContextPath();
    }

    public String getFiles() {
        return "/files/" + this.resource.getWorkspace();
    }

    public String getFilesPlaceholders() {
        return "/files/{workspace}";
    }

    public String getBase() {
        return this.base;
    }

    public String getBasePlaceholders() {
        return StringUtils.substringBeforeLast((String)this.context.getServletPath(), (String)"/") + "/{mode}/{lang}";
    }

    public String getLive() {
        return this.live;
    }

    public String getEdit() {
        return this.edit;
    }

    public String getPreview() {
        return this.preview;
    }

    public String getContribute() {
        return this.contribute;
    }

    public String getStudio() {
        if (this.studio == null) {
            this.studio = this.getStudio(false);
        }
        return this.studio;
    }

    private String getStudio(boolean isVisual) {
        String path;
        String mode = isVisual ? "studiovisual" : "studio";
        SettingsBean cfg = SettingsBean.getInstance();
        if (cfg.isDistantPublicationServerMode() || cfg.isProductionMode()) {
            return null;
        }
        JCRSiteNode site = this.context.getSite();
        if (site != null && (path = site.getPath()).startsWith("/modules/")) {
            return "/cms/" + mode + SLASH_EDIT_SLASH + this.languageCode + path + ".html";
        }
        return isVisual ? "/welcome/studiovisualmode" : "/welcome/studiomode";
    }

    public String getStudioVisual() {
        if (this.studioVisual == null) {
            this.studioVisual = this.getStudio(true);
        }
        return this.studioVisual;
    }

    public String getFind() {
        return this.find;
    }

    public String getFindPrincipal() {
        return FindPrincipal.getFindPrincipalServletPath();
    }

    public String getLogout() {
        if (this.logout == null) {
            this.logout = StringUtils.defaultIfEmpty((String)LogoutConfig.getInstance().getCustomLogoutUrl(this.context.getRequest()), (String)Logout.getLogoutServletPath());
        }
        return this.logout;
    }

    public String getCurrentModule() {
        View view = ((Script)this.context.getRequest().getAttribute("script")).getView();
        return view.getModule().getRootFolderPath();
    }

    public String getCurrent() {
        return this.buildURL(this.resource.getNode(), this.resource.getResolvedTemplate(), this.resource.getTemplateType());
    }

    public Map<String, String> getLanguages() {
        if (this.languages == null) {
            this.languages = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object lang) {
                    return URLGenerator.this.getLanguage((String)lang);
                }
            });
        }
        return this.languages;
    }

    public String getLanguage(String languageCode) {
        String template = this.resource.getTemplate();
        return this.getContext() + this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode + this.context.getMainResource().getNode().getPath() + this.getTemplateExtensionFrom(template) + ".html";
    }

    private String getTemplateExtensionFrom(String template) {
        return template != null && !"default".equals(template) ? "." + template : "";
    }

    public Map<String, String> getTemplates() {
        if (this.templates == null) {
            this.templates = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object template) {
                    return URLGenerator.this.getTemplate((String)template);
                }
            });
        }
        return this.templates;
    }

    public String getTemplate(String template) {
        return this.buildURL(this.resource.getNode(), template, this.resource.getTemplateType());
    }

    public Map<String, String> getTemplateTypes() {
        if (this.templateTypes == null) {
            this.templateTypes = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object templateType) {
                    return URLGenerator.this.getTemplateType((String)templateType);
                }
            });
        }
        return this.templateTypes;
    }

    public String getTemplateType(String templateType) {
        return this.buildURL(this.resource.getNode(), this.resource.getResolvedTemplate(), templateType);
    }

    public Map<String, String> getBases() {
        if (this.bases == null) {
            this.bases = LazyMap.decorate(new HashMap(), (Transformer)new Transformer(){

                public Object transform(Object lang) {
                    return URLGenerator.this.getBase((String)lang);
                }
            });
        }
        return this.bases;
    }

    public String getBase(String languageCode) {
        return this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode;
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public String getMainResource() {
        return this.base + this.context.getMainResource().getNode().getPath() + "." + this.context.getMainResource().getResolvedTemplate() + ".html";
    }

    public String buildURL(JCRNodeWrapper node, String template, String templateType) {
        return this.buildURL(node, null, template, templateType);
    }

    public String buildURL(JCRNodeWrapper node, String languageCode, String template, String templateType) {
        return this.buildURL(node.getPath(), languageCode, template, templateType);
    }

    public String buildURL(String nodePath, String languageCode, String template, String templateType) {
        String baseURL = this.base;
        if (!StringUtils.isEmpty((String)languageCode)) {
            baseURL = this.context.getServletPath() + "/" + this.resource.getWorkspace() + "/" + languageCode;
        }
        return baseURL + nodePath + this.getTemplateExtensionFrom(template) + "." + templateType;
    }

    public String getInitializers() {
        return this.initializers;
    }

    public String getCaptcha() {
        return Captcha.getCaptchaServletPath();
    }

    public String getBaseContribute() {
        return this.baseContribute;
    }

    public String getBaseEdit() {
        return this.baseEdit;
    }

    public String getBaseLive() {
        return this.baseLive;
    }

    public String getBasePreview() {
        return this.basePreview;
    }

    public String getConvert() {
        return this.convert;
    }

    public String getBaseUserBoardEdit() {
        return this.baseUserBoardEdit;
    }

    public String getBaseUserBoardLive() {
        return this.baseUserBoardLive;
    }

    public String getBaseUserBoardFrameEdit() {
        return this.baseUserBoardFrameEdit;
    }

    public String getBaseUserBoardFrameLive() {
        return this.baseUserBoardFrameLive;
    }

    public String getRealResource() {
        Resource ajaxResource = this.context.getAjaxResource();
        if (this.context.isAjaxRequest() && ajaxResource != null) {
            String path = ajaxResource.getNode().getPath();
            if (this.context.isEditMode()) {
                return this.baseEdit + path + ".html";
            }
            if (this.context.isContributionMode()) {
                return this.baseContribute + path + ".html";
            }
            return ("live".equals(ajaxResource.getWorkspace()) ? this.baseLive : this.basePreview) + path + ".html";
        }
        if (this.context.isEditMode()) {
            if (this.context.getEditModeConfigName().equals("studiomode")) {
                return this.getStudio();
            }
            return this.getEdit();
        }
        return "live".equals(this.resource.getWorkspace()) ? this.live : this.preview;
    }

    public String getServer() {
        if (this.server == null) {
            int port;
            StringBuilder url = new StringBuilder(255);
            HttpServletRequest request = this.context.getRequest();
            String scheme = request.getScheme();
            String host = this.context.getSite().getServerName();
            if (Url.isLocalhost(host)) {
                host = request.getServerName();
            }
            if ((port = SettingsBean.getInstance().getSiteURLPortOverride()) == 0) {
                port = request.getServerPort();
            }
            url.append(scheme).append("://").append(host);
            if (!(port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                url.append(":").append(port);
            }
            this.server = url.toString();
        }
        return this.server;
    }

    public String getMyProfile() {
        if (this.myProfile == null) {
            JahiaUser user = this.context.getUser();
            JCRUserNode userNode = JahiaUserManagerService.getInstance().lookupUserByPath(user.getLocalPath());
            this.myProfile = !JahiaUserManagerService.isGuest(user) && userNode != null && userNode.isMemberOfGroup(null, "privileged") ? "/start" : "";
        }
        return this.myProfile;
    }

    public String getLogin() {
        if (this.login == null) {
            this.login = StringUtils.defaultIfEmpty((String)LoginConfig.getInstance().getCustomLoginUrl(this.context.getRequest()), (String)Login.getServletPath());
        }
        return this.login;
    }

    public String getFindUser() {
        return FindUser.getFindUserServletPath();
    }

    public String getFindUsersAndGroups() {
        return FindUsersAndGroups.getFindUsersAndGroupsServletPath();
    }

    public String getFindUsersAndGroupsInAcl() {
        return FindUsersAndGroupsInAcl.getFindUsersAndGroupsInAclServletPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("URLGenerator");
        sb.append("{base='").append(this.base).append('\'');
        sb.append(", live='").append(this.live).append('\'');
        sb.append(", edit='").append(this.edit).append('\'');
        sb.append(", preview='").append(this.preview).append('\'');
        sb.append(", contribute='").append(this.contribute).append('\'');
        sb.append(", studio='").append(this.studio).append('\'');
        sb.append(", find='").append(this.find).append('\'');
        sb.append(", initializers='").append(this.initializers).append('\'');
        sb.append(", resource=").append(this.resource);
        sb.append(", context=").append(this.context);
        sb.append(", languages=").append(this.languages);
        sb.append(", templates=").append(this.templates);
        sb.append(", templateTypes=").append(this.templateTypes);
        sb.append(", templatesPath='").append(this.templatesPath).append('\'');
        sb.append(", baseLive='").append(this.baseLive).append('\'');
        sb.append(", baseContribute='").append(this.baseContribute).append('\'');
        sb.append(", baseEdit='").append(this.baseEdit).append('\'');
        sb.append(", basePreview='").append(this.basePreview).append('\'');
        sb.append(", convert='").append(this.convert).append('\'');
        sb.append(", myProfile='").append(this.myProfile).append('\'');
        sb.append(", server='").append(this.server).append('\'');
        sb.append(", login='").append(this.login).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

