/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.org.mozilla.javascript.ErrorReporter;
import com.yahoo.platform.yui.org.mozilla.javascript.EvaluatorException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.apache.commons.collections.map.LazySortedMap;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.utils.GWTInitializer;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.render.AssetsMapFactory;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.cache.AggregateCacheFilter;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.Patterns;
import org.jahia.utils.ScriptEngineUtils;
import org.jahia.utils.WebUtils;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.FileSystemResource;

public class StaticAssetsFilter
extends AbstractFilter
implements ApplicationListener<JahiaTemplateManagerService.TemplatePackageRedeployedEvent>,
InitializingBean {
    private String jahiaContext = null;
    private boolean addLastModifiedDate = false;
    private File generatedResourcesFolder;
    private String ajaxResolvedTemplate;
    private String ajaxTemplate;
    private String ajaxTemplateExtension;
    private String ckeditorJavaScript = "/modules/ckeditor/javascript/ckeditor.js";
    private String resolvedTemplate;
    private ScriptEngineUtils scriptEngineUtils;
    private String template;
    private String templateExtension;
    private boolean aggregateAssets;
    private boolean compressDuringAggregation;
    private List<String> excludesFromAggregateAndCompress = new ArrayList<String>();
    private Set<String> ieHeaderRecognitions = new HashSet<String>();
    private boolean forceLiveIEcompatiblity;
    private Set<String> aggregateSupportedMedias = new HashSet<String>();
    private static final Pattern CLEANUP_REGEXP = Pattern.compile("<!-- jahia:temp value=\".*?\" -->");
    private static final FastHashMap RANK = new FastHashMap();
    private static final Pattern URL_PATTERN_1;
    private static final Pattern URL_PATTERN_2;
    private static final Pattern URL_PATTERN_3;
    private static final Pattern URL_PATTERN_4;
    private static final String[] OPTIONAL_ATTRIBUTES;
    private static final List<String> OPTIONS_SUPPORTED_BY_AGGREGATION;
    private static final String TARGET_TAG = "targetTag";
    private static final String STATIC_ASSETS = "staticAssets";
    private static final String ASSET_ENCODING = "UTF-8";
    private static final String GENERATED_RESOURCES_URL_PATH = "/generated-resources/";
    private static final Logger logger;
    private static final Transformer LOW_CASE_TRANSFORMER;
    private static final Comparator<String> ASSET_COMPARATOR;

    private static void atomicMove(File src, File dest) throws IOException {
        if (src.exists()) {
            try {
                Files.move(Paths.get(src.toURI()), Paths.get(dest.toURI()), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (Exception e) {
                logger.warn("Unable to move the file {} into {}. Copying it instead.", (Object)src, (Object)dest);
                try {
                    FileUtils.copyFile((File)src, (File)dest);
                }
                finally {
                    FileUtils.deleteQuietly((File)src);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) throws Exception {
        String out = previousOut;
        Source source = new Source((CharSequence)previousOut);
        LinkedHashMap<String, SortedMap> assetsByTarget = new LinkedHashMap<String, SortedMap>();
        List esiResourceElements = source.getAllElements("jahia:resource");
        HashSet<String> keys = new HashSet<String>();
        for (Element esiResourceElement : esiResourceElements) {
            LinkedHashMap<String, Map<String, String>> my;
            void var13_14;
            StartTag esiResourceStartTag = esiResourceElement.getStartTag();
            String targetTag = esiResourceStartTag.getAttributeValue(TARGET_TAG);
            targetTag = targetTag == null ? "HEAD" : targetTag.toUpperCase();
            if (!assetsByTarget.containsKey(targetTag)) {
                SortedMap sortedMap = LazySortedMap.decorate((SortedMap)TransformedSortedMap.decorate(new TreeMap(ASSET_COMPARATOR), (Transformer)LOW_CASE_TRANSFORMER, (Transformer)NOPTransformer.INSTANCE), (Factory)new AssetsMapFactory());
                assetsByTarget.put(targetTag, sortedMap);
            } else {
                Map map = (Map)assetsByTarget.get(targetTag);
            }
            String type = esiResourceStartTag.getAttributeValue("type");
            String path = StringUtils.equals((String)type, (String)"inline") ? StringUtils.substring((String)out, (int)esiResourceStartTag.getEnd(), (int)esiResourceElement.getEndTag().getBegin()) : URLDecoder.decode(esiResourceStartTag.getAttributeValue("path"), ASSET_ENCODING);
            Boolean insert = Boolean.parseBoolean(esiResourceStartTag.getAttributeValue("insert"));
            String key = esiResourceStartTag.getAttributeValue("key");
            Map<String, String> optionsMap = StaticAssetsFilter.getOptionMaps(esiResourceStartTag);
            LinkedHashMap<String, Map<String, String>> stringMap = (LinkedHashMap<String, Map<String, String>>)var13_14.get(type);
            if (stringMap == null) {
                LinkedHashMap assetMap = new LinkedHashMap();
                stringMap = var13_14.put(type, assetMap);
            }
            if (insert.booleanValue()) {
                my = new LinkedHashMap<String, Map<String, String>>();
                my.put(path, optionsMap);
                my.putAll(stringMap);
                stringMap = my;
            } else if ("".equals(key) || !keys.contains(key)) {
                my = new LinkedHashMap();
                my.put(path, optionsMap);
                stringMap.putAll(my);
                keys.add(key);
            }
            var13_14.put(type, stringMap);
        }
        renderContext.getRequest().setAttribute(STATIC_ASSETS, assetsByTarget.get("HEAD"));
        OutputDocument outputDocument = new OutputDocument(source);
        if (renderContext.isAjaxRequest()) {
            String templateContent = this.getAjaxResolvedTemplate();
            if (templateContent != null) {
                for (Map.Entry entry : assetsByTarget.entrySet()) {
                    renderContext.getRequest().setAttribute(STATIC_ASSETS, entry.getValue());
                    Element element = source.getFirstElement(TARGET_TAG);
                    EndTag tag = element != null ? element.getEndTag() : null;
                    ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.ajaxTemplateExtension);
                    AssetsScriptContext scriptContext = new AssetsScriptContext();
                    Bindings bindings = scriptEngine.createBindings();
                    bindings.put(TARGET_TAG, entry.getKey());
                    bindings.put("renderContext", (Object)renderContext);
                    bindings.put("resource", (Object)resource);
                    scriptContext.setBindings(bindings, 200);
                    bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
                    scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
                    StringWriter writer = (StringWriter)scriptContext.getWriter();
                    String staticsAsset = writer.toString();
                    if (!StringUtils.isNotBlank((String)staticsAsset)) continue;
                    if (tag != null) {
                        outputDocument.replace(tag.getBegin(), tag.getBegin() + 1, (CharSequence)("\n" + staticsAsset + "\n<"));
                        out = outputDocument.toString();
                        continue;
                    }
                    out = staticsAsset + "\n" + previousOut;
                }
            }
        } else if (resource.getContextConfiguration().equals("page")) {
            if (renderContext.isEditMode() && renderContext.getServletPath().endsWith("frame")) {
                List bodyElementList;
                boolean doParse = true;
                if (renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing() != null) {
                    for (String string : renderContext.getEditModeConfig().getSkipMainModuleTypesDomParsing()) {
                        doParse = !resource.getNode().isNodeType(string);
                        if (doParse) continue;
                        break;
                    }
                }
                if ((bodyElementList = source.getAllElements("body")).size() > 0) {
                    Element element = (Element)bodyElementList.get(bodyElementList.size() - 1);
                    EndTag bodyEndTag = element.getEndTag();
                    outputDocument.replace(bodyEndTag.getBegin(), bodyEndTag.getBegin() + 1, (CharSequence)"</div><");
                    Element element2 = (Element)bodyElementList.get(0);
                    StartTag bodyStartTag = element2.getStartTag();
                    JCRNodeWrapper currentTemplateNode = (JCRNodeWrapper)renderContext.getRequest().getAttribute("currentTemplateNode");
                    outputDocument.replace(bodyStartTag.getEnd(), bodyStartTag.getEnd(), (CharSequence)("\n<div jahiatype=\"mainmodule\" path=\"" + resource.getNode().getPath() + "\" locale=\"" + resource.getLocale() + "\" template=\"" + (resource.getTemplate() != null && !resource.getTemplate().equals("default") ? resource.getTemplate() : "") + "\" templateName=\"" + (currentTemplateNode != null ? StringEscapeUtils.escapeHtml((String)currentTemplateNode.getDisplayableName()) : "") + "\" nodetypes=\"" + ConstraintsHelper.getConstraints(renderContext.getMainResource().getNode()) + "\">"));
                    if (doParse) {
                        outputDocument.replace(bodyStartTag.getEnd() - 1, bodyStartTag.getEnd(), (CharSequence)" jahia-parse-html=\"true\">");
                    }
                }
            }
            if (!assetsByTarget.containsKey("HEAD")) {
                this.addResources(renderContext, resource, source, outputDocument, "HEAD", new HashMap<String, Map<String, Map<String, String>>>());
            }
            for (Map.Entry entry : assetsByTarget.entrySet()) {
                String string = (String)entry.getKey();
                Map assets = (Map)entry.getValue();
                this.addResources(renderContext, resource, source, outputDocument, string, assets);
            }
            out = outputDocument.toString();
        }
        source = new Source((CharSequence)out);
        outputDocument = new OutputDocument(source);
        for (Element el : source.getAllElements("jahia:resource")) {
            outputDocument.replace((Segment)el, (CharSequence)"");
        }
        String s = outputDocument.toString();
        s = StaticAssetsFilter.removeTempTags(s);
        return s.trim();
    }

    private void addResources(RenderContext renderContext, Resource resource, Source source, OutputDocument outputDocument, String targetTag, Map<String, Map<String, Map<String, String>>> assetsByType) throws IOException, ScriptException {
        renderContext.getRequest().setAttribute(STATIC_ASSETS, assetsByType);
        Element element = source.getFirstElement(targetTag);
        String templateContent = this.getResolvedTemplate();
        if (element == null) {
            logger.warn("WARNING: Trying to add resources to output but didn't find the HTML tag '{}' while rendering resource '{}'. Please check the structure of your HTML template", (Object)targetTag, (Object)renderContext.getRequest().getRequestURL());
            return;
        }
        if (templateContent != null) {
            EndTag headEndTag = element.getEndTag();
            if (headEndTag == null) {
                logger.warn("WARNING: Trying to add resources to HTML tag '{}', but didn't find corresponding end tag while rendering resource '{}'. Please check the structure of your HTML template", (Object)targetTag, (Object)renderContext.getRequest().getRequestURL());
                return;
            }
            ScriptEngine scriptEngine = this.scriptEngineUtils.scriptEngine(this.templateExtension);
            AssetsScriptContext scriptContext = new AssetsScriptContext();
            Bindings bindings = scriptEngine.createBindings();
            bindings.put("contextJsParameters", this.getContextJsParameters(assetsByType, renderContext));
            if (this.aggregateAssets && resource.getWorkspace().equals("live")) {
                Map<String, Map<String, String>> javascriptAssets;
                Map<String, Map<String, String>> cssAssets = assetsByType.get("css");
                if (cssAssets != null) {
                    assetsByType.put("css", this.aggregate(cssAssets, "css"));
                }
                if ((javascriptAssets = assetsByType.get("javascript")) != null) {
                    LinkedHashMap<String, Map<String, String>> scripts = new LinkedHashMap<String, Map<String, String>>(javascriptAssets);
                    Map<String, Map<String, String>> newScripts = this.aggregate(javascriptAssets, "js");
                    assetsByType.put("javascript", newScripts);
                    scripts.keySet().removeAll(newScripts.keySet());
                    assetsByType.put("aggregatedjavascript", scripts);
                }
            } else if (this.addLastModifiedDate) {
                this.addLastModified(assetsByType);
            }
            bindings.put(TARGET_TAG, (Object)targetTag);
            bindings.put("renderContext", (Object)renderContext);
            bindings.put("resource", (Object)resource);
            bindings.put("contextPath", (Object)renderContext.getRequest().getContextPath());
            scriptContext.setBindings(bindings, 200);
            bindings.put("out", (Object)new PrintWriter(scriptContext.getWriter()));
            scriptEngine.eval(templateContent, (ScriptContext)scriptContext);
            StringWriter writer = (StringWriter)scriptContext.getWriter();
            String staticsAsset = writer.toString();
            if (StringUtils.isNotBlank((String)staticsAsset)) {
                outputDocument.replace(headEndTag.getBegin(), headEndTag.getBegin() + 1, (CharSequence)("\n" + AggregateCacheFilter.removeCacheTags(staticsAsset) + "\n<"));
            }
        }
        if (this.isEnforceIECompatibilityMode(renderContext)) {
            int idx = element.getBegin() + element.toString().indexOf(">");
            String str = ">\n<meta http-equiv=\"X-UA-Compatible\" content=\"" + WebUtils.getInternetExplorerCompatibility(renderContext.getRequest()) + "\"/>";
            outputDocument.replace(idx, idx + 1, (CharSequence)str);
        }
        if (renderContext.isPreviewMode() && !Boolean.valueOf((String)renderContext.getRequest().getAttribute("org.jahia.StaticAssetFilter.doNotModifyDocumentTitle")).booleanValue()) {
            for (Element title : element.getAllElements("title")) {
                int idx = title.getBegin() + title.toString().indexOf(">");
                String str = Messages.getInternal("label.preview", renderContext.getUILocale());
                str = ">" + str + " - ";
                outputDocument.replace(idx, idx + 1, (CharSequence)str);
            }
        }
    }

    private static Map<String, String> getOptionMaps(StartTag esiResourceTag) {
        Map<String, String> optionsMap = null;
        for (String attributeName : OPTIONAL_ATTRIBUTES) {
            String attribute = esiResourceTag.getAttributeValue(attributeName);
            if (attribute == null || (attribute = attribute.trim()).isEmpty()) continue;
            if (optionsMap == null) {
                optionsMap = new HashMap<String, String>(OPTIONAL_ATTRIBUTES.length);
            }
            if ((!attributeName.equals("async") && !attributeName.equals("defer") || !attribute.equals("true")) && (attributeName.equals("async") || attributeName.equals("defer"))) continue;
            optionsMap.put(attributeName, attribute);
        }
        return optionsMap != null ? optionsMap : Collections.emptyMap();
    }

    private void addLastModified(Map<String, Map<String, Map<String, String>>> assets) throws IOException {
        for (Map.Entry<String, Map<String, Map<String, String>>> assetsEntry : assets.entrySet()) {
            if (!assetsEntry.getKey().equals("css") && !assetsEntry.getKey().equals("javascript")) continue;
            LinkedHashMap<String, Map<String, String>> newMap = new LinkedHashMap<String, Map<String, String>>();
            for (Map.Entry<String, Map<String, String>> entry : assetsEntry.getValue().entrySet()) {
                org.springframework.core.io.Resource r = StaticAssetsFilter.getResource(this.getKey(entry.getKey()));
                if (r != null) {
                    newMap.put(entry.getKey() + "?" + r.lastModified(), entry.getValue());
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            assetsEntry.getValue().clear();
            assetsEntry.getValue().putAll(newMap);
        }
    }

    private Object getContextJsParameters(Map<String, Map<String, Map<String, String>>> assets, RenderContext ctx) {
        String customCkeditorConfig;
        StringBuilder params = new StringBuilder(1024);
        params.append("{\"contextPath\":\"").append(ctx.getRequest().getContextPath()).append("\",\"lang\":\"").append(ctx.getMainResourceLocale()).append("\",\"uilang\":\"").append(ctx.getUILocale());
        try {
            params.append("\",\"siteUuid\":\"").append(ctx.getSite() != null ? ctx.getSite().getIdentifier() : "''");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        params.append("\",\"wcag\":").append(ctx.getSiteInfo() != null ? Boolean.valueOf(ctx.getSiteInfo().isWCAGComplianceCheckEnabled()) : "false");
        Map<String, Map<String, String>> js = assets.get("javascript");
        if (js != null && js.containsKey(this.ckeditorJavaScript) && (customCkeditorConfig = GWTInitializer.getCustomCKEditorConfig(ctx)) != null) {
            params.append(",\"ckeCfg\":\"").append(customCkeditorConfig).append("\"");
        }
        params.append(",\"ckeCfg\":\"\"}");
        return params.toString();
    }

    private boolean isEnforceIECompatibilityMode(RenderContext renderContext) {
        if (!this.forceLiveIEcompatiblity && !renderContext.isEditMode()) {
            return false;
        }
        String header = renderContext.getRequest().getHeader("user-agent");
        if (header == null || header.length() == 0) {
            return false;
        }
        header = header.toLowerCase();
        for (String ieHeaderRecognition : this.getIeHeaderRecognitions()) {
            if (!header.contains(ieHeaderRecognition)) continue;
            return true;
        }
        return false;
    }

    public static String removeTempTags(String content) {
        if (StringUtils.isNotEmpty((String)content)) {
            return CLEANUP_REGEXP.matcher(content).replaceAll("");
        }
        return content;
    }

    private Map<String, Map<String, String>> aggregate(Map<String, Map<String, String>> assets, String type) throws IOException {
        ArrayList<Map.Entry<String, Map<String, String>>> entries = new ArrayList<Map.Entry<String, Map<String, String>>>(assets.entrySet());
        LinkedHashMap<String, Map<String, String>> newEntries = new LinkedHashMap<String, Map<String, String>>();
        int mapKeyIndex = 0;
        String previousMedia = null;
        ArrayList<String> aggregatedKey = new ArrayList<String>();
        LinkedHashMap<String, ResourcesToAggregate> resourcesToAggregateMap = new LinkedHashMap<String, ResourcesToAggregate>();
        for (Map.Entry entry : entries) {
            boolean canAggregate;
            String key = this.getKey((String)entry.getKey());
            org.springframework.core.io.Resource resource = StaticAssetsFilter.getResource(key);
            String media = (String)((Map)entry.getValue()).get("media");
            boolean supportedOption = true;
            if (!((Map)entry.getValue()).isEmpty()) {
                for (String option : ((Map)entry.getValue()).keySet()) {
                    if (OPTIONS_SUPPORTED_BY_AGGREGATION.contains(option)) continue;
                    supportedOption = false;
                }
            }
            boolean async = ((Map)entry.getValue()).get("async") != null && ((String)((Map)entry.getValue()).get("async")).equals("true");
            boolean defer = ((Map)entry.getValue()).get("defer") != null && ((String)((Map)entry.getValue()).get("defer")).equals("true");
            String mapKey = type + (StringUtils.isNotBlank(previousMedia) ? "-" + previousMedia : "") + (async ? "-async" : "") + (defer ? "-defer" : "") + (async || defer ? "" : Integer.valueOf(mapKeyIndex));
            boolean pathExcluded = this.excludesFromAggregateAndCompress.contains(key) || resource == null;
            boolean bl = canAggregate = supportedOption && !pathExcluded && (media == null || this.aggregateSupportedMedias.contains(media));
            if (canAggregate) {
                boolean sameMedia = StringUtils.equals(previousMedia, (String)media);
                if (!sameMedia) {
                    if (resourcesToAggregateMap.containsKey(mapKey) && !aggregatedKey.contains(mapKey)) {
                        this.aggregatePathsAndPopulateNewEntries((ResourcesToAggregate)resourcesToAggregateMap.get(mapKey), newEntries, type);
                        aggregatedKey.add(mapKey);
                    }
                    previousMedia = media;
                    mapKeyIndex = entries.indexOf(entry);
                    mapKey = type + (StringUtils.isNotBlank((String)media) ? "-" + media : "") + (async ? "-async" : "") + (defer ? "-defer" : "") + (async || defer ? "" : Integer.valueOf(mapKeyIndex));
                }
                if (!resourcesToAggregateMap.containsKey(mapKey)) {
                    resourcesToAggregateMap.put(mapKey, new ResourcesToAggregate(new LinkedHashMap<String, org.springframework.core.io.Resource>(), media, async, defer));
                }
                this.addResourceToAggregation(key, resource, (ResourcesToAggregate)resourcesToAggregateMap.get(mapKey));
                continue;
            }
            if (resourcesToAggregateMap.containsKey(mapKey) && !aggregatedKey.contains(mapKey)) {
                this.aggregatePathsAndPopulateNewEntries((ResourcesToAggregate)resourcesToAggregateMap.get(mapKey), newEntries, type);
                aggregatedKey.add(mapKey);
                mapKeyIndex = entries.indexOf(entry);
            }
            if (this.addLastModifiedDate && (resource = StaticAssetsFilter.getResource(this.getKey((String)entry.getKey()))) != null) {
                newEntries.put((String)entry.getKey() + "?lastModified=" + resource.lastModified(), (Map<String, String>)entry.getValue());
                continue;
            }
            newEntries.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
        }
        for (Map.Entry entry : resourcesToAggregateMap.entrySet()) {
            if (aggregatedKey.contains(entry.getKey())) continue;
            this.aggregatePathsAndPopulateNewEntries((ResourcesToAggregate)entry.getValue(), newEntries, type);
            aggregatedKey.add((String)entry.getKey());
        }
        return newEntries;
    }

    private void addResourceToAggregation(String key, org.springframework.core.io.Resource resource, ResourcesToAggregate resourcesToAggregate) throws IOException {
        long lastModified = resource.lastModified();
        resourcesToAggregate.getPathsToAggregate().put(key + "_" + lastModified, resource);
        if (lastModified > resourcesToAggregate.getMaxLastModified()) {
            resourcesToAggregate.setMaxLastModified(lastModified);
        }
    }

    private void aggregatePathsAndPopulateNewEntries(ResourcesToAggregate resourcesToAggregate, Map<String, Map<String, String>> newEntries, String type) throws IOException {
        if (!resourcesToAggregate.getPathsToAggregate().isEmpty()) {
            String minifiedAggregatedPath = this.performAggregation(resourcesToAggregate.getPathsToAggregate(), type, resourcesToAggregate.getMaxLastModified(), resourcesToAggregate.isAsync(), resourcesToAggregate.isDefer());
            HashMap<String, String> options = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)resourcesToAggregate.getMedia())) {
                options.put("media", resourcesToAggregate.getMedia());
            }
            if (resourcesToAggregate.isAsync()) {
                options.put("async", "true");
            }
            if (resourcesToAggregate.isDefer()) {
                options.put("defer", "true");
            }
            newEntries.put(Jahia.getContextPath() + minifiedAggregatedPath, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performAggregation(Map<String, org.springframework.core.io.Resource> pathsToAggregate, String type, long maxLastModified, boolean async, boolean defer) throws IOException {
        String aggregatedKey = StaticAssetsFilter.generateAggregateName(pathsToAggregate.keySet());
        String minifiedAggregatedFileName = aggregatedKey + (async ? "-async" : "") + (defer ? "-defer" : "") + ".min." + type;
        String minifiedAggregatedRealPath = StaticAssetsFilter.getFileSystemPath(minifiedAggregatedFileName);
        File minifiedAggregatedFile = new File(minifiedAggregatedRealPath);
        String minifiedAggregatedPath = GENERATED_RESOURCES_URL_PATH + minifiedAggregatedFileName;
        if (this.addLastModifiedDate) {
            minifiedAggregatedPath = minifiedAggregatedPath + "?" + maxLastModified;
        }
        if (!minifiedAggregatedFile.exists()) {
            this.generatedResourcesFolder.mkdirs();
            LinkedHashMap<String, String> minifiedFileNames = new LinkedHashMap<String, String>();
            for (Map.Entry<String, org.springframework.core.io.Resource> entry : pathsToAggregate.entrySet()) {
                String path = entry.getKey();
                org.springframework.core.io.Resource resource = entry.getValue();
                String minifiedFileName = Patterns.SLASH.matcher(path).replaceAll("_") + ".min." + type;
                File minifiedFile = new File(StaticAssetsFilter.getFileSystemPath(minifiedFileName));
                if (!minifiedFile.exists()) {
                    StaticAssetsFilter.minify(path, resource, type, minifiedFile, this.compressDuringAggregation);
                }
                minifiedFileNames.put(path, minifiedFileName);
            }
            try {
                File tmpMinifiedAggregatedFile = new File(minifiedAggregatedFile.getParentFile(), minifiedAggregatedFile.getName() + "." + System.nanoTime());
                BufferedOutputStream outMerged = new BufferedOutputStream(new FileOutputStream(tmpMinifiedAggregatedFile));
                FileInputStream is = null;
                try {
                    for (Map.Entry entry : minifiedFileNames.entrySet()) {
                        if (type.equals("js")) {
                            ((OutputStream)outMerged).write("//".getBytes(ASSET_ENCODING));
                            ((OutputStream)outMerged).write(((String)entry.getValue()).getBytes(ASSET_ENCODING));
                            ((OutputStream)outMerged).write("\n".getBytes(ASSET_ENCODING));
                        }
                        is = new FileInputStream(StaticAssetsFilter.getFileSystemPath((String)entry.getValue()));
                        IOUtils.copy((InputStream)is, (OutputStream)outMerged);
                        if (type.equals("js")) {
                            ((OutputStream)outMerged).write(";\n".getBytes(ASSET_ENCODING));
                        }
                        IOUtils.closeQuietly((InputStream)is);
                    }
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outMerged);
                    IOUtils.closeQuietly(is);
                    StaticAssetsFilter.atomicMove(tmpMinifiedAggregatedFile, minifiedAggregatedFile);
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return minifiedAggregatedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void minify(String path, org.springframework.core.io.Resource resource, String type, File minifiedFile, boolean compress) throws IOException {
        File tmpMinifiedFile;
        OutputStreamWriter writer;
        Reader reader;
        block11: {
            reader = null;
            writer = null;
            tmpMinifiedFile = new File(minifiedFile.getParentFile(), minifiedFile.getName() + "." + System.nanoTime());
            try {
                reader = new InputStreamReader(resource.getInputStream(), ASSET_ENCODING);
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpMinifiedFile), ASSET_ENCODING);
                if (compress && type.equals("css") && !path.contains(".min")) {
                    String s = IOUtils.toString((Reader)reader);
                    IOUtils.closeQuietly((Reader)reader);
                    s = StaticAssetsFilter.urlRewriting(s, path);
                    reader = new StringReader(s);
                    CssCompressor compressor = new CssCompressor(reader);
                    compressor.compress((Writer)writer, -1);
                    break block11;
                }
                if (compress && type.equals("js") && !path.contains(".min")) {
                    try {
                        JavaScriptCompressor compressor = new JavaScriptCompressor(reader, (ErrorReporter)new JavaScriptErrorReporter());
                        compressor.compress((Writer)writer, -1, true, true, false, false);
                    }
                    catch (EvaluatorException e) {
                        logger.error("Error when minifying " + path, (Throwable)e);
                        IOUtils.closeQuietly((Reader)reader);
                        IOUtils.closeQuietly((Writer)writer);
                        reader = new InputStreamReader(resource.getInputStream(), ASSET_ENCODING);
                        writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpMinifiedFile), ASSET_ENCODING);
                        IOUtils.copy((Reader)reader, (Writer)writer);
                    }
                    break block11;
                }
                if (type.equals("css")) {
                    String s = IOUtils.toString((Reader)reader);
                    IOUtils.closeQuietly((Reader)reader);
                    reader = new StringReader(StaticAssetsFilter.urlRewriting(s, path));
                }
                BufferedWriter bw = new BufferedWriter(writer);
                BufferedReader br = new BufferedReader(reader);
                try {
                    String s;
                    while ((s = br.readLine()) != null) {
                        bw.write(s);
                        bw.write("\n");
                    }
                }
                finally {
                    IOUtils.closeQuietly((Writer)bw);
                    IOUtils.closeQuietly((Reader)br);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                StaticAssetsFilter.atomicMove(tmpMinifiedFile, minifiedFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
        StaticAssetsFilter.atomicMove(tmpMinifiedFile, minifiedFile);
    }

    private String getKey(String key) {
        if (Jahia.getContextPath().length() > 0 && key.startsWith(this.jahiaContext)) {
            key = key.substring(Jahia.getContextPath().length());
        }
        return key;
    }

    private static org.springframework.core.io.Resource getResource(String key) {
        org.springframework.core.io.Resource r = null;
        String filePath = StringUtils.substringAfter((String)key.substring(1), (String)"/");
        String moduleId = StringUtils.substringBefore((String)filePath, (String)"/");
        filePath = StringUtils.substringAfter((String)filePath, (String)"/");
        if (key.startsWith("/modules/")) {
            JahiaTemplatesPackage jahiaTemplatesPackage = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleId);
            if (jahiaTemplatesPackage != null) {
                r = jahiaTemplatesPackage.getResource(filePath);
            }
        } else if (key.startsWith("/files/")) {
            r = StaticAssetsFilter.getResourceFromFile(moduleId, "/" + filePath);
        } else if (key.contains(GENERATED_RESOURCES_URL_PATH)) {
            r = new FileSystemResource(StaticAssetsFilter.getFileSystemPath(StringUtils.substringAfterLast((String)key, (String)GENERATED_RESOURCES_URL_PATH)));
        }
        return r;
    }

    private static String getFileSystemPath(String minifiedAggregatedFileName) {
        return SettingsBean.getInstance().getJahiaGeneratedResourcesDiskPath() + File.separator + minifiedAggregatedFileName;
    }

    private static org.springframework.core.io.Resource getResourceFromFile(String workspace, String fFilePath) {
        try {
            final JCRNodeWrapper contentNode = JCRSessionFactory.getInstance().getCurrentUserSession(workspace).getNode(fFilePath);
            return new org.springframework.core.io.Resource(){

                public boolean exists() {
                    return true;
                }

                public boolean isReadable() {
                    return false;
                }

                public boolean isOpen() {
                    return false;
                }

                public URL getURL() throws IOException {
                    return null;
                }

                public URI getURI() throws IOException {
                    return null;
                }

                public File getFile() throws IOException {
                    return null;
                }

                public long contentLength() throws IOException {
                    return contentNode.getFileContent().getContentLength();
                }

                public long lastModified() throws IOException {
                    return contentNode.getLastModifiedAsDate().getTime();
                }

                public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
                    return null;
                }

                public String getFilename() {
                    return contentNode.getName();
                }

                public String getDescription() {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return contentNode.getFileContent().downloadFile();
                }
            };
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    private static String generateAggregateName(Collection<String> m) {
        StringBuilder sb = new StringBuilder(m.size() * 128);
        for (String s1 : m) {
            sb.append(s1);
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            byte[] digest = digester.digest(sb.toString().getBytes(ASSET_ENCODING));
            StringBuilder hexString = new StringBuilder(digest.length * 2);
            for (byte aDigest : digest) {
                hexString.append(Integer.toHexString(0xFF & aDigest));
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAjaxResolvedTemplate() throws IOException {
        if (this.ajaxResolvedTemplate == null) {
            this.ajaxResolvedTemplate = WebUtils.getResourceAsString(this.ajaxTemplate);
            if (this.ajaxResolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.ajaxTemplate);
            }
        }
        return this.ajaxResolvedTemplate;
    }

    protected String getResolvedTemplate() throws IOException {
        if (this.resolvedTemplate == null) {
            this.resolvedTemplate = WebUtils.getResourceAsString(this.template);
            if (this.resolvedTemplate == null) {
                logger.warn("Unable to lookup template at {}", (Object)this.template);
            }
        }
        return this.resolvedTemplate;
    }

    public void setAjaxTemplate(String ajaxTemplate) {
        this.ajaxTemplate = ajaxTemplate;
        if (ajaxTemplate != null) {
            this.ajaxTemplateExtension = StringUtils.substringAfterLast((String)ajaxTemplate, (String)".");
        }
    }

    public void setScriptEngineUtils(ScriptEngineUtils scriptEngineUtils) {
        this.scriptEngineUtils = scriptEngineUtils;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (template != null) {
            this.templateExtension = StringUtils.substringAfterLast((String)template, (String)".");
        }
    }

    @Deprecated
    public void setAggregateAndCompress(boolean aggregateAndCompress) {
        this.setAggregateAssets(aggregateAndCompress);
        this.setCompressDuringAggregation(aggregateAndCompress);
    }

    public void setExcludesFromAggregateAndCompress(List<String> skipAggregation) {
        this.excludesFromAggregateAndCompress = skipAggregation;
    }

    public Set<String> getIeHeaderRecognitions() {
        return this.ieHeaderRecognitions;
    }

    public void setIeHeaderRecognitions(Set<String> ieHeaderRecognitions) {
        this.ieHeaderRecognitions = ieHeaderRecognitions;
    }

    public Set<String> getAggregateSupportedMedias() {
        return this.aggregateSupportedMedias;
    }

    public void setAggregateSupportedMedias(String aggregateSupportedMedias) {
        if (StringUtils.isNotEmpty((String)aggregateSupportedMedias)) {
            this.aggregateSupportedMedias = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)aggregateSupportedMedias));
        }
    }

    public void setCkeditorJavaScript(String ckeditorJavaScript) {
        this.ckeditorJavaScript = ckeditorJavaScript;
    }

    public void setAddLastModifiedDate(boolean addLastModifiedDate) {
        this.addLastModifiedDate = addLastModifiedDate;
    }

    public void setForceLiveIEcompatiblity(boolean forceLiveIEcompatiblity) {
        this.forceLiveIEcompatiblity = forceLiveIEcompatiblity;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkAggregateAndCompressSupport();
        this.jahiaContext = Jahia.getContextPath() + "/";
        this.generatedResourcesFolder = new File(SettingsBean.getInstance().getJahiaGeneratedResourcesDiskPath());
        this.performPurgeIfNeeded();
    }

    private void checkAggregateAndCompressSupport() {
        if (!this.aggregateAssets) {
            this.compressDuringAggregation = false;
        }
        if (this.compressDuringAggregation && !StringUtils.startsWith((String)System.getProperty("java.version"), (String)"1.8")) {
            this.compressDuringAggregation = false;
            logger.info("Compression of static assets is not supported on JDK after 1.8 and will be disabled");
        }
        logger.info("Static assets: aggregation is {}, compression is {}", (Object)(this.aggregateAssets ? "ON" : "OFF"), (Object)(this.compressDuringAggregation ? "ON" : "OFF"));
    }

    private void performPurgeIfNeeded() {
        if (!this.generatedResourcesFolder.isDirectory()) {
            return;
        }
        File marker = new File(SettingsBean.getInstance().getJahiaVarDiskPath(), "[generated-resources].dodelete");
        if (marker.exists()) {
            logger.info("Cleaning existing generated resources folder {}", (Object)this.generatedResourcesFolder);
            try {
                FileUtils.cleanDirectory((File)this.generatedResourcesFolder);
                FileUtils.deleteQuietly((File)marker);
            }
            catch (IOException e) {
                logger.warn("Unable to purge content of the generated resources folder: " + this.generatedResourcesFolder, (Throwable)e);
            }
        }
    }

    public void onApplicationEvent(JahiaTemplateManagerService.TemplatePackageRedeployedEvent event) {
        this.ajaxResolvedTemplate = null;
        this.resolvedTemplate = null;
    }

    private static String urlRewriting(String s, String path) {
        if (s.indexOf("url(") != -1) {
            String url = StringUtils.substringBeforeLast((String)path, (String)"/") + "/";
            s = URL_PATTERN_1.matcher(s).replaceAll("url(");
            s = URL_PATTERN_2.matcher(s).replaceAll("url(\".." + url);
            s = URL_PATTERN_3.matcher(s).replaceAll("url('.." + url);
            s = URL_PATTERN_4.matcher(s).replaceAll("url(.." + url);
        }
        return s;
    }

    public void setAggregateAssets(boolean aggregateAssets) {
        this.aggregateAssets = aggregateAssets;
    }

    public void setCompressDuringAggregation(boolean compressAssets) {
        this.compressDuringAggregation = compressAssets;
    }

    static {
        RANK.put((Object)"inlinebefore", (Object)0);
        RANK.put((Object)"css", (Object)1);
        RANK.put((Object)"inlinecss", (Object)2);
        RANK.put((Object)"javascript", (Object)3);
        RANK.put((Object)"inlinejavascript", (Object)4);
        RANK.put((Object)"inline", (Object)5);
        RANK.put((Object)"html", (Object)6);
        RANK.put((Object)"unknown", (Object)7);
        RANK.setFast(true);
        URL_PATTERN_1 = Pattern.compile("url\\( ");
        URL_PATTERN_2 = Pattern.compile("url\\(\"(?!(/|http:|https:|data:))");
        URL_PATTERN_3 = Pattern.compile("url\\('(?!(/|http:|https:|data:))");
        URL_PATTERN_4 = Pattern.compile("url\\((?!(/|'|\"|http:|https:|data:))");
        OPTIONAL_ATTRIBUTES = new String[]{"title", "rel", "media", "condition", "async", "defer"};
        OPTIONS_SUPPORTED_BY_AGGREGATION = Arrays.asList("media", "async", "defer");
        logger = LoggerFactory.getLogger(StaticAssetsFilter.class);
        LOW_CASE_TRANSFORMER = new Transformer(){

            public Object transform(Object input) {
                return input != null ? input.toString().toLowerCase() : null;
            }
        };
        ASSET_COMPARATOR = ComparatorUtils.transformedComparator(null, (Transformer)new Transformer(){

            public Object transform(Object input) {
                Object rank = null;
                if (input != null) {
                    rank = (Integer)RANK.get((Object)input.toString());
                }
                return rank != null ? rank : RANK.get((Object)"unknown");
            }
        });
    }

    private class ResourcesToAggregate {
        LinkedHashMap<String, org.springframework.core.io.Resource> pathsToAggregate;
        String media;
        long maxLastModified;
        boolean async;
        boolean defer;

        public ResourcesToAggregate(LinkedHashMap<String, org.springframework.core.io.Resource> pathsToAggregate, String media, boolean async, boolean defer) {
            this.pathsToAggregate = pathsToAggregate;
            this.media = media;
            this.async = async;
            this.defer = defer;
            this.maxLastModified = 0L;
        }

        public LinkedHashMap<String, org.springframework.core.io.Resource> getPathsToAggregate() {
            return this.pathsToAggregate;
        }

        public String getMedia() {
            return this.media;
        }

        public long getMaxLastModified() {
            return this.maxLastModified;
        }

        public void setMaxLastModified(long maxLastModified) {
            this.maxLastModified = maxLastModified;
        }

        public boolean isAsync() {
            return this.async;
        }

        public boolean isDefer() {
            return this.defer;
        }
    }

    private static class JavaScriptErrorReporter
    implements ErrorReporter {
        private JavaScriptErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (!logger.isDebugEnabled()) {
                return;
            }
            if (line < 0) {
                logger.debug(message);
            } else {
                logger.debug(line + ":" + lineOffset + ":" + message);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.error(message);
            } else {
                logger.error(line + ":" + lineOffset + ":" + message);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }

    private static class AssetsScriptContext
    extends SimpleScriptContext {
        private Writer writer = null;

        private AssetsScriptContext() {
        }

        @Override
        public Writer getWriter() {
            if (this.writer == null) {
                this.writer = new StringWriter();
            }
            return this.writer;
        }
    }
}

