/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.filter.cache;

import java.util.HashSet;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.render.RenderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderServiceTemplateCacheEventListener
extends DefaultEventListener
implements ExternalEventListener {
    private static final int MODULES_LENGTH = "/modules/".length();
    private static final Logger logger = LoggerFactory.getLogger(RenderServiceTemplateCacheEventListener.class);
    private RenderService renderService;

    @Override
    public String getPath() {
        return "/modules";
    }

    @Override
    public String[] getNodeTypes() {
        return new String[]{"jnt:template"};
    }

    @Override
    public int getEventTypes() {
        return 63;
    }

    public void onEvent(EventIterator events) {
        HashSet<String> modulesToFlush = new HashSet<String>();
        while (events.hasNext()) {
            Event event = (Event)events.next();
            try {
                String path = event.getPath();
                if (this.renderService == null) {
                    this.renderService = (RenderService)SpringContextSingleton.getBean("RenderService");
                }
                if (this.renderService == null) continue;
                int index = path.indexOf("/", MODULES_LENGTH);
                if ((index = path.indexOf("/", index + 1)) <= -1) continue;
                modulesToFlush.add(path.substring(0, index));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        for (String module : modulesToFlush) {
            logger.debug("Flushing {} entries for {}", (Object)"RenderService.TemplatesCache", (Object)module);
            this.renderService.flushCache(module);
        }
    }

    public void setRenderService(RenderService renderService) {
        this.renderService = renderService;
    }
}

