/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.render.webflow;

import javax.servlet.ServletRequest;
import org.apache.commons.id.uuid.UUID;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionListenerAdapter;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;

public class WebflowTokenListener
extends FlowExecutionListenerAdapter {
    public static final String WEBFLOW_TOKEN = "webflowToken";
    public static final String CHECK_WEBFLOW_TOKEN = "checkWebflowToken";

    public void sessionStarting(RequestContext context, FlowSession session, MutableAttributeMap<?> input) {
        String token = UUID.randomUUID().toString();
        context.getFlowScope().put(WEBFLOW_TOKEN, (Object)token);
        this.storeToken(context, token);
        super.sessionStarting(context, session, input);
    }

    public void resuming(RequestContext context) {
        context.getFlowScope().put(CHECK_WEBFLOW_TOKEN, (Object)true);
        String token = (String)context.getFlowScope().get(WEBFLOW_TOKEN);
        this.storeToken(context, token);
        super.resuming(context);
    }

    private void storeToken(RequestContext context, String token) {
        ((ServletRequest)context.getExternalContext().getNativeRequest()).setAttribute(WEBFLOW_TOKEN, (Object)token);
    }

    public void eventSignaled(RequestContext context, Event event) {
        if (context.getFlowScope().get(CHECK_WEBFLOW_TOKEN) != null) {
            String token = (String)context.getFlowScope().get(WEBFLOW_TOKEN);
            String reqToken = context.getRequestParameters().get(WEBFLOW_TOKEN);
            if (token != null && !token.equals(reqToken)) {
                throw new IllegalStateException("Invalid token");
            }
        }
        super.eventSignaled(context, event);
    }
}

