/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.search;

import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.search.SearchCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchCriteriaFactory {
    private static final String ATTR_QUERY_PARAMS = SearchCriteria.class.getName();
    private static final ConvertUtilsBean CONVERTER_UTILS_BEAN = new ConvertUtilsBean();
    private static Converter ENUM_CONVERTER = new Converter(){

        public Object convert(Class type, Object value) {
            return Enum.valueOf(type, String.valueOf(value).toUpperCase());
        }
    };
    private static Logger logger = LoggerFactory.getLogger(SearchCriteriaFactory.class);
    private static final String PARAM_NAME_PREFIX = "src_";

    public static SearchCriteria getInstance(RenderContext ctx) {
        SearchCriteria searchParams = (SearchCriteria)ctx.getRequest().getAttribute(ATTR_QUERY_PARAMS);
        if (null == searchParams && SearchCriteriaFactory.isRequestDataPresent(ctx.getRequest())) {
            searchParams = new SearchCriteria();
            try {
                HashMap<String, String[]> properties = new HashMap<String, String[]>();
                Enumeration params = ctx.getRequest().getParameterNames();
                while (params.hasMoreElements()) {
                    String param = (String)params.nextElement();
                    if (!param.startsWith(PARAM_NAME_PREFIX)) continue;
                    String[] pValues = ctx.getRequest().getParameterValues(param);
                    properties.put(param.substring(PARAM_NAME_PREFIX.length()), (String[])(pValues != null && pValues.length == 1 ? pValues[0] : pValues));
                }
                new BeanUtilsBean(CONVERTER_UTILS_BEAN, new PropertyUtilsBean()).populate((Object)searchParams, properties);
            }
            catch (Exception e) {
                Throwable cause;
                Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
                if (cause instanceof InvocationTargetException && ((InvocationTargetException)cause).getTargetException() != null) {
                    cause = ((InvocationTargetException)cause).getTargetException();
                }
                if (logger.isDebugEnabled()) {
                    logger.warn("Error parsing search parameters", cause);
                }
                logger.warn("Error parsing search parameters: " + (cause.getCause() != null ? cause.getCause() : cause));
            }
            if (logger.isDebugEnabled()) {
                logger.debug(searchParams.toString());
            }
            SearchCriteriaFactory.initNodeProperties(searchParams, ctx.getMainResource().getLocale());
            ctx.getRequest().setAttribute(ATTR_QUERY_PARAMS, (Object)searchParams);
        }
        return searchParams;
    }

    private static SearchCriteria.NodePropertyDescriptor getPropertyDescriptor(ExtendedItemDefinition itemDef, ExtendedNodeType nodeType, Locale locale) throws RepositoryException {
        ExtendedPropertyDefinition propDefExt = (ExtendedPropertyDefinition)itemDef;
        PropertyDefinition propDef = JCRContentUtils.getPropertyDefinition(nodeType, propDefExt.getName());
        SearchCriteria.NodeProperty.Type type = SearchCriteria.NodeProperty.Type.TEXT;
        switch (propDef.getRequiredType()) {
            case 6: {
                type = SearchCriteria.NodeProperty.Type.BOOLEAN;
                break;
            }
            case 5: {
                type = SearchCriteria.NodeProperty.Type.DATE;
                break;
            }
            case 1: 
            case 10: {
                if (13 != propDefExt.getSelector()) break;
                type = SearchCriteria.NodeProperty.Type.CATEGORY;
            }
        }
        SearchCriteria.NodePropertyDescriptor descriptor = new SearchCriteria.NodePropertyDescriptor(itemDef.getName(), itemDef.getLabel(locale != null ? locale : Locale.ENGLISH, nodeType), type);
        descriptor.setMultiple(propDef.isMultiple());
        if (propDef.getValueConstraints().length > 0) {
            descriptor.setConstrained(true);
            descriptor.setAllowedValues(propDef.getValueConstraints());
        }
        descriptor.setSelectorOptions(propDefExt.getSelectorOptions());
        Value[] defaultValues = propDef.getDefaultValues();
        if (defaultValues != null && defaultValues.length > 0) {
            descriptor.setDefaultValue(defaultValues[0].getString());
        }
        return descriptor;
    }

    public static SearchCriteria.NodePropertyDescriptor getPropertyDescriptor(String nodeType, String propertyName, Locale locale) throws RepositoryException {
        PropertyDefinition propDef = JCRContentUtils.getPropertyDefinition(nodeType, propertyName);
        SearchCriteria.NodePropertyDescriptor descriptor = null;
        if (propDef != null) {
            descriptor = SearchCriteriaFactory.getPropertyDescriptor((ExtendedItemDefinition)propDef, NodeTypeRegistry.getInstance().getNodeType(nodeType), locale);
        }
        return descriptor;
    }

    private static void initNodeProperties(SearchCriteria searchParams, Locale locale) {
        LinkedList<SearchCriteria.NodeProperty> props = new LinkedList<SearchCriteria.NodeProperty>();
        for (Map.Entry<String, Map<String, SearchCriteria.NodeProperty>> docTypeEntry : searchParams.getProperties().entrySet()) {
            for (Map.Entry<String, SearchCriteria.NodeProperty> propEntry : docTypeEntry.getValue().entrySet()) {
                SearchCriteria.NodeProperty prop = propEntry.getValue();
                prop.setNodeType(docTypeEntry.getKey());
                prop.setName(propEntry.getKey());
                if (!prop.isAllEmpty()) {
                    try {
                        SearchCriteria.NodePropertyDescriptor descriptor = SearchCriteriaFactory.getPropertyDescriptor(prop.getNodeType(), prop.getName(), locale);
                        prop.setConstrained(descriptor.isConstrained());
                        prop.setMultiple(descriptor.isMultiple());
                        prop.setType(descriptor.getType());
                    }
                    catch (RepositoryException e) {
                        logger.error("Error retrieving property descriptor for node type '" + prop.getNodeType() + "' and property name '" + prop.getName() + "'", (Throwable)e);
                    }
                }
                props.add(prop);
            }
        }
    }

    private static boolean isRequestDataPresent(HttpServletRequest request) {
        boolean present = false;
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            if (!((String)params.nextElement()).startsWith(PARAM_NAME_PREFIX)) continue;
            present = true;
            break;
        }
        return present;
    }

    static {
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.DateValue.Type.class);
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.NodeProperty.Type.class);
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.Term.MatchType.class);
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.Ordering.Operand.class);
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.Ordering.CaseConversion.class);
        CONVERTER_UTILS_BEAN.register(ENUM_CONVERTER, SearchCriteria.Ordering.Order.class);
        ArrayConverter converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        converter.setAllowedChars(new char[]{'.', '-', '_', ':', ' '});
        CONVERTER_UTILS_BEAN.register((Converter)converter, String[].class);
    }
}

