/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.security.shiro;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.usermanager.JahiaUser;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaAccountRealm
extends AuthorizingRealm {
    public static final Logger logger = LoggerFactory.getLogger(JahiaAccountRealm.class);

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals.getPrimaryPrincipal() instanceof JahiaUser) {
            JahiaUser user = (JahiaUser)principals.getPrimaryPrincipal();
            try {
                return new SimpleAuthorizationInfo(JCRTemplate.getInstance().doExecute(user, null, null, session -> {
                    JCRNodeWrapper node = session.getNode("/");
                    if (user.isRoot()) {
                        return node.getAvailableRoles().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream()).map(JCRNodeWrapper::getName).collect(Collectors.toSet());
                    }
                    return this.getRoles(user, node);
                }));
            }
            catch (RepositoryException e) {
                logger.error("Cannot login", (Throwable)e);
            }
        }
        return new SimpleAuthorizationInfo(Collections.emptySet());
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        JahiaUser jahiaUser = (JahiaUser)principals.getPrimaryPrincipal();
        PermissionOnPath permissionOnPath = new PermissionOnPath(permission);
        try {
            return JCRTemplate.getInstance().doExecute(jahiaUser, null, null, session -> session.getNode(permissionOnPath.getNode()).hasPermission(permissionOnPath.getPermission()));
        }
        catch (RepositoryException e) {
            logger.error("Cannot check permission", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private Set<String> getRoles(JahiaUser userNode, JCRNodeWrapper node) {
        HashSet<String> roles = new HashSet<String>();
        Map<String, Map<String, String>> actualAclEntries = node.getActualAclEntries();
        for (Map.Entry<String, Map<String, String>> actualAclEntry : actualAclEntries.entrySet()) {
            String principal = actualAclEntry.getKey();
            String principalName = principal.substring(2);
            if ((principal.charAt(0) != 'u' || !principalName.equals(userNode.getName())) && (principal.charAt(0) != 'g' || !ServicesRegistry.getInstance().getJahiaGroupManagerService().lookupGroup(null, principalName).isMember(userNode.getLocalPath()))) continue;
            for (Map.Entry<String, String> aclEntry : actualAclEntry.getValue().entrySet()) {
                if (!"GRANT".equals(aclEntry.getValue())) continue;
                roles.add(aclEntry.getKey());
            }
        }
        return roles;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        return new SimpleAuthenticationInfo(token.getPrincipal(), token.getPrincipal(), this.getName());
    }

    private class PermissionOnPath {
        private String node;
        private String permission;

        public PermissionOnPath(String value) {
            String[] split = StringUtils.split((String)value, (char)':');
            if (split.length == 0) {
                this.node = "/";
                this.permission = split[0].replace('_', ':');
            } else {
                this.node = split[0];
                this.permission = split[1].replace('_', ':');
            }
        }

        public String getNode() {
            return this.node;
        }

        public String getPermission() {
            return this.permission;
        }
    }
}

