/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.services.content.DefaultEventListener;
import org.jahia.services.content.ExternalEventListener;
import org.jahia.services.templates.ModuleVersion;
import org.jahia.services.templates.TemplatePackageRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRModuleListener
extends DefaultEventListener
implements ExternalEventListener {
    private static Logger logger = LoggerFactory.getLogger(JCRModuleListener.class);
    private TemplatePackageRegistry packageRegistry;
    private Listener listener;

    public void setPackageRegistry(TemplatePackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public int getEventTypes() {
        return 1;
    }

    @Override
    public String getPath() {
        return "/modules";
    }

    @Override
    public String[] getNodeTypes() {
        return new String[]{"jnt:moduleVersion"};
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            try {
                Event e = events.nextEvent();
                String path = e.getPath();
                String[] splitpath = path.split("/");
                JahiaTemplatesPackage p = this.packageRegistry.lookupByIdAndVersion(splitpath[2], new ModuleVersion(splitpath[3]));
                if (this.listener == null || p == null) continue;
                this.listener.onModuleImported(p);
            }
            catch (Exception e1) {
                logger.error("Error handling event", (Throwable)e1);
            }
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void onModuleImported(JahiaTemplatesPackage var1);
    }
}

