/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.ProcessHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SourceControlManagement {
    private static final Logger logger = LoggerFactory.getLogger(SourceControlManagement.class);
    protected String executable;
    protected File rootFolder;
    private volatile Map<String, Status> statusMap;

    protected static List<String> readLines(String source) throws IOException {
        List list;
        StringReader input = null;
        try {
            input = new StringReader(source);
            list = IOUtils.readLines((Reader)input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
        return list;
    }

    protected SourceControlManagement(String executable) {
        this.executable = executable;
    }

    public final void add(File file) throws IOException {
        this.add((List<File>)ImmutableList.of((Object)file));
    }

    public abstract void add(List<File> var1) throws IOException;

    protected void checkExecutionResult(ExecutionResult result) throws IOException {
        if (result.exitValue != 0 || result.out.contains("conflicts")) {
            String message = result.err;
            if (StringUtils.isBlank((String)message)) {
                message = result.out;
            }
            message = message.replace("hint:", "");
            throw new IOException(message);
        }
    }

    public boolean checkCommit() throws IOException {
        Map<String, Status> newStatusMap = this.createStatusMap();
        if (newStatusMap.values().contains((Object)Status.UNMERGED)) {
            throw new IOException("Commit : remaining conflicts need to be resolved");
        }
        return newStatusMap.values().contains((Object)Status.MODIFIED) || newStatusMap.values().contains((Object)Status.ADDED) || newStatusMap.values().contains((Object)Status.DELETED) || newStatusMap.values().contains((Object)Status.RENAMED) || newStatusMap.values().contains((Object)Status.COPIED) || newStatusMap.values().contains((Object)Status.UNMERGED);
    }

    public abstract boolean commit(String var1) throws IOException;

    protected abstract Map<String, Status> createStatusMap() throws IOException;

    protected ExecutionResult executeCommand(String command, String[] arguments) throws IOException {
        int res;
        String argumentsString = StringUtils.trimToEmpty((String)StringUtils.join((Object[])arguments, (String)" "));
        String commandString = command + " " + argumentsString;
        logger.debug("Executing SCM command: '{}'...", (Object)commandString);
        StringBuilder resultOut = new StringBuilder();
        StringBuilder resultErr = new StringBuilder();
        try {
            res = ProcessHelper.execute(command, arguments, null, this.rootFolder, resultOut, resultErr, false);
        }
        catch (Exception e) {
            throw new IOException("Failed to execute command '" + commandString + "'", e);
        }
        ExecutionResult result = new ExecutionResult(res, resultOut.toString(), resultErr.toString());
        if (logger.isDebugEnabled()) {
            StringBuilder logMessage = new StringBuilder("\n");
            logMessage.append("Executed SCM command: '").append(commandString).append("'\n");
            if (this.rootFolder != null) {
                logMessage.append("In the directory: '").append(this.rootFolder).append("'\n");
            }
            logMessage.append("Exit code: ").append(result.exitValue).append("\n");
            if (StringUtils.isNotBlank((String)result.out)) {
                logMessage.append("Command output:\n").append(result.out.trim()).append("\n");
            }
            if (StringUtils.isNotBlank((String)result.err)) {
                logMessage.append("Command errors:\n").append(result.err.trim()).append("\n");
            }
            logger.debug(logMessage.toString());
        }
        return result;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public Status getStatus(String path) throws IOException {
        Map<String, Status> statuses = this.getStatusMap();
        Status s = statuses.get(path);
        if (s != null) {
            return s;
        }
        if (path.indexOf(47) != -1 && statuses.values().contains((Object)Status.UNTRACKED)) {
            StringBuilder subPath = new StringBuilder(32);
            for (String segment : StringUtils.split((String)path, (char)'/')) {
                if (subPath.length() > 0) {
                    if (statuses.get(subPath.toString()) == Status.UNTRACKED) {
                        return Status.UNTRACKED;
                    }
                    subPath.append('/');
                }
                subPath.append(segment);
            }
        }
        return Status.UNMODIFIED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, Status> getStatusMap() throws IOException {
        Map<String, Status> statusMapCopy = this.statusMap;
        if (statusMapCopy == null) {
            SourceControlManagement sourceControlManagement = this;
            synchronized (sourceControlManagement) {
                statusMapCopy = this.statusMap;
                if (statusMapCopy == null) {
                    this.statusMap = statusMapCopy = this.createStatusMap();
                }
            }
        }
        return statusMapCopy;
    }

    public abstract String getURI() throws IOException;

    protected abstract void getFromSCM(File var1, String var2, String var3) throws IOException;

    protected abstract void sendToSCM(File var1, String var2) throws IOException;

    protected abstract void initWithWorkingDirectory(File var1) throws IOException;

    public synchronized void invalidateStatusCache() {
        this.statusMap = null;
    }

    public abstract void markConflictAsResolved(File var1) throws IOException;

    public abstract void move(File var1, File var2) throws IOException;

    public abstract void remove(File var1) throws IOException;

    public abstract String update() throws IOException;

    public abstract Map<String, String> getTagInfos(String var1) throws IOException;

    public abstract Map<String, String> getBranchInfos(String var1) throws IOException;

    public static enum Status {
        ADDED,
        COPIED,
        DELETED,
        MODIFIED,
        RENAMED,
        UNMERGED,
        UNMODIFIED,
        UNTRACKED;

    }

    protected static class ExecutionResult {
        protected String err;
        protected int exitValue;
        protected String out;

        protected ExecutionResult(int exitValue, String out, String err) {
            this.exitValue = exitValue;
            this.out = out;
            this.err = err;
        }
    }
}

