/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.templates;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.templates.SourceControlException;
import org.jahia.services.templates.SourceControlManagement;

public class SvnSourceControlManagement
extends SourceControlManagement {
    public SvnSourceControlManagement(String executable) {
        super(executable);
    }

    @Override
    public void add(List<File> files) throws IOException {
        if (files.isEmpty()) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("add");
        args.add("--parents");
        for (File file : files) {
            if (file.getName().equals(".gitignore")) {
                ArrayList<String> ignoreCmd = new ArrayList<String>();
                ignoreCmd.add("propset");
                ignoreCmd.add("svn:ignore");
                ignoreCmd.add("-F");
                ignoreCmd.add(file.getAbsolutePath());
                ignoreCmd.add(".");
                this.executeCommand(this.executable, ignoreCmd.toArray(new String[ignoreCmd.size()]));
            }
            if (file.getPath().equals(rootPath)) {
                args.add(".");
                continue;
            }
            args.add(file.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    @Override
    public boolean commit(String message) throws IOException {
        boolean commitRequired = this.checkCommit();
        if (commitRequired) {
            this.checkExecutionResult(this.executeCommand(this.executable, new String[]{"commit", "-m", message}));
        }
        this.invalidateStatusCache();
        return commitRequired;
    }

    @Override
    protected Map<String, SourceControlManagement.Status> createStatusMap() throws IOException {
        HashMap<String, SourceControlManagement.Status> newMap = new HashMap<String, SourceControlManagement.Status>();
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"status"});
        for (String line : SvnSourceControlManagement.readLines(result.out)) {
            if (StringUtils.isBlank((String)line)) continue;
            String path = line.substring(8);
            char firstColumn = line.charAt(0);
            SourceControlManagement.Status status = null;
            if (firstColumn == 'C' || line.charAt(1) == 'C' || line.charAt(6) == 'C') {
                status = SourceControlManagement.Status.UNMERGED;
            } else if (firstColumn == 'A') {
                status = SourceControlManagement.Status.ADDED;
            } else if (firstColumn == 'D' || firstColumn == '!') {
                status = SourceControlManagement.Status.DELETED;
            } else if (firstColumn == 'M') {
                status = SourceControlManagement.Status.MODIFIED;
            } else if (firstColumn == '?') {
                status = SourceControlManagement.Status.UNTRACKED;
            }
            if (status == null) continue;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            path = FilenameUtils.separatorsToUnix((String)path);
            newMap.put(path, status);
            String[] pathSegments = StringUtils.split((String)path, (char)'/');
            StringBuilder subPath = new StringBuilder(64);
            for (String segment : pathSegments) {
                newMap.put(subPath.length() == 0 ? "/" : subPath.toString(), SourceControlManagement.Status.MODIFIED);
                subPath.append('/');
                subPath.append(segment);
            }
        }
        return newMap;
    }

    @Override
    public String getURI() throws IOException {
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"info", "--xml"});
        String url = StringUtils.substringBetween((String)result.out, (String)"<url>", (String)"</url>").trim();
        return "scm:svn:" + url;
    }

    @Override
    protected void getFromSCM(File workingDirectory, String uri, String branchOrTag) throws IOException {
        this.rootFolder = workingDirectory.getParentFile();
        SourceControlManagement.ExecutionResult r = this.executeCommand(this.executable, new String[]{"checkout ", uri, workingDirectory.getName()});
        if (r.exitValue > 0) {
            throw new SourceControlException(r.err);
        }
        this.rootFolder = workingDirectory;
    }

    @Override
    protected void sendToSCM(File workingDirectory, String uri) throws IOException {
        this.rootFolder = workingDirectory;
        SourceControlManagement.ExecutionResult r = this.executeCommand(this.executable, new String[]{"checkout ", uri, "."});
        File gitIgnore = new File(workingDirectory, ".gitignore");
        if (gitIgnore.exists()) {
            String ignorepath = gitIgnore.getAbsolutePath();
            this.executeCommand(this.executable, new String[]{"propset", "svn:ignore", "-F", ignorepath, "."});
            gitIgnore.delete();
        }
        this.executeCommand(this.executable, new String[]{"add", "src"});
        this.executeCommand(this.executable, new String[]{"add", "pom.xml"});
        this.executeCommand(this.executable, new String[]{"commit", "-m", "Initial commit"});
        if (r.exitValue > 0) {
            File svnDir = new File(workingDirectory.getPath() + "/.svn");
            if (svnDir.exists()) {
                FileUtils.deleteDirectory((File)svnDir);
            }
            throw new IOException(r.err);
        }
    }

    @Override
    protected void initWithWorkingDirectory(File workingDirectory) throws IOException {
        this.rootFolder = workingDirectory;
    }

    @Override
    public void markConflictAsResolved(File file) throws IOException {
        if (file == null) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("resolve");
        args.add("--accept=working");
        if (file.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(file.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    @Override
    public void move(File src, File dst) throws IOException {
        if (src == null || dst == null) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("move");
        if (src.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(src.getPath().substring(rootPath.length() + 1));
        }
        if (dst.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(dst.getPath().substring(rootPath.length() + 1));
        }
        this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        this.invalidateStatusCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(File file) throws IOException {
        if (file == null) {
            return;
        }
        String rootPath = this.rootFolder.getPath();
        ArrayList<String> args = new ArrayList<String>();
        args.add("remove");
        args.add("--force");
        if (file.getPath().equals(rootPath)) {
            args.add(".");
        } else {
            args.add(file.getPath().substring(rootPath.length() + 1));
        }
        try {
            this.executeCommand(this.executable, args.toArray(new String[args.size()]));
        }
        finally {
            this.invalidateStatusCache();
        }
    }

    @Override
    public String update() throws IOException {
        try {
            SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"update", "--non-interactive"});
            this.checkExecutionResult(result);
            String string = result.out;
            return string;
        }
        finally {
            this.invalidateStatusCache();
        }
    }

    @Override
    public Map<String, String> getTagInfos(String uri) throws IOException {
        String separator = "/trunk";
        Iterator<String> it = Arrays.asList("/branches", "/tags").iterator();
        while (!StringUtils.contains((String)uri, (String)separator) && it.hasNext()) {
            separator = it.next();
        }
        String base = StringUtils.substringBeforeLast((String)uri, (String)separator) + "/tags/";
        String path = StringUtils.substringAfterLast((String)uri, (String)(separator + "/"));
        if (!separator.equals("/trunk")) {
            path = StringUtils.substringAfter((String)path, (String)"/");
        }
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"list", base});
        List<String> lines = SvnSourceControlManagement.readLines(result.out);
        Collections.reverse(lines);
        for (String line : lines) {
            String tag = StringUtils.removeEnd((String)line, (String)"/");
            infos.put(tag, "scm:svn:" + base + tag + (path.length() > 0 ? "/" + path : ""));
        }
        return infos;
    }

    @Override
    public Map<String, String> getBranchInfos(String uri) throws IOException {
        String separator = "/trunk";
        Iterator<String> it = Arrays.asList("/branches", "/tags").iterator();
        while (!StringUtils.contains((String)uri, (String)separator) && it.hasNext()) {
            separator = it.next();
        }
        String base = StringUtils.substringBeforeLast((String)uri, (String)separator) + "/branches/";
        String path = StringUtils.substringAfterLast((String)uri, (String)(separator + "/"));
        if (!separator.equals("/trunk")) {
            path = StringUtils.substringAfter((String)path, (String)"/");
        }
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        SourceControlManagement.ExecutionResult result = this.executeCommand(this.executable, new String[]{"list", base});
        List<String> lines = SvnSourceControlManagement.readLines(result.out);
        Collections.reverse(lines);
        infos.put("trunk", uri);
        for (String line : lines) {
            String branch = StringUtils.removeEnd((String)line, (String)"/");
            infos.put(branch, "scm:svn:" + base + branch + (path.length() > 0 ? "/" + path : ""));
        }
        return infos;
    }
}

