/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.transform;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.local.office.LocalOfficeManager;
import org.jodconverter.local.office.OfficeConnectionProtocol;
import org.jodconverter.local.process.ProcessManager;
import org.jodconverter.local.process.ProcessQuery;
import org.jodconverter.local.process.WindowsProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class LocalOfficeManagerFactory
extends AbstractFactoryBean<OfficeManager> {
    private static final Logger logger = LoggerFactory.getLogger(LocalOfficeManagerFactory.class);
    private LocalOfficeManager.Builder cfg;
    private boolean killExistingOfficeProcessOnWindows = true;
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int[] portNumbers = new int[]{2002};

    public LocalOfficeManagerFactory() {
        this.cfg = LocalOfficeManager.builder();
    }

    protected OfficeManager createInstance() throws Exception {
        if (this.killExistingOfficeProcessOnWindows && SystemUtils.IS_OS_WINDOWS && this.connectionProtocol == OfficeConnectionProtocol.SOCKET && WindowsProcessManager.getDefault().isUsable()) {
            WindowsProcessManager mgr = new WindowsProcessManager();
            for (int port : this.portNumbers) {
                ProcessQuery q = new ProcessQuery("soffice.bin", "socket,host=127.0.0.1,port=" + port);
                long pid = mgr.findPid(q);
                if (pid <= 0L) continue;
                try {
                    mgr.kill(null, pid);
                }
                catch (Exception e) {
                    logger.error("Error killing existing office process with pid " + pid, (Throwable)e);
                }
            }
        }
        return this.cfg.build();
    }

    public Class<? extends OfficeManager> getObjectType() {
        return OfficeManager.class;
    }

    public void setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) throws NullPointerException {
        this.connectionProtocol = connectionProtocol;
    }

    public void setMaxTasksPerProcess(int maxTasksPerProcess) {
        this.cfg.maxTasksPerProcess(Integer.valueOf(maxTasksPerProcess));
    }

    public void setOfficeHome(File officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.officeHome(officeHome);
    }

    public void setOfficeHome(String officeHome) throws NullPointerException, IllegalArgumentException {
        this.cfg.officeHome(officeHome);
    }

    public void setPipeName(String pipeName) throws NullPointerException {
        this.cfg.pipeNames(new String[]{pipeName});
    }

    public void setPipeNames(String ... pipeNames) throws NullPointerException, IllegalArgumentException {
        this.cfg.pipeNames(pipeNames);
    }

    public void setPortNumber(int portNumber) {
        this.portNumbers = new int[]{portNumber};
        this.cfg.portNumbers(new int[]{portNumber});
    }

    public void setPortNumbers(int ... portNumbers) throws NullPointerException, IllegalArgumentException {
        this.portNumbers = portNumbers;
        this.cfg.portNumbers(portNumbers);
    }

    public void setProcessManager(ProcessManager processManager) throws NullPointerException {
        this.cfg.processManager(processManager);
    }

    public void setTaskExecutionTimeout(long taskExecutionTimeout) {
        this.cfg.taskExecutionTimeout(Long.valueOf(taskExecutionTimeout));
    }

    public void setTaskQueueTimeout(long taskQueueTimeout) {
        this.cfg.taskQueueTimeout(Long.valueOf(taskQueueTimeout));
    }

    public void setTemplateProfileDir(File templateProfileDir) throws IllegalArgumentException {
        this.cfg.templateProfileDir(templateProfileDir);
    }

    public void setKillExistingOfficeProcessOnWindows(boolean killExistingOfficeProcessOnWindows) {
        this.killExistingOfficeProcessOnWindows = killExistingOfficeProcessOnWindows;
    }
}

