/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.uicomponents.bean.editmode;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.uicomponents.bean.Visibility;
import org.jahia.services.uicomponents.bean.contentmanager.ManagerConfiguration;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.services.uicomponents.bean.editmode.Engine;
import org.jahia.services.uicomponents.bean.editmode.EngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EngineTab
implements Serializable,
Comparable<EngineTab>,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = -5995531303789738603L;
    private String id;
    private String title;
    private String titleKey;
    private Visibility visibility;
    private EditEngineTabItem tabItem;
    private int order;
    private String requiredPermission;
    private boolean showInEngine = true;
    private Object parent;
    private Object parentEditConfiguration;
    private Object parentManagerConfiguration;
    private int position = -1;
    private String positionAfter;
    private String positionBefore;
    private ApplicationContext applicationContext;

    public EngineTab() {
    }

    public EngineTab(String id) {
        this();
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean showInEngine() {
        return this.showInEngine;
    }

    public void setShowInEngine(boolean showInEngine) {
        this.showInEngine = showInEngine;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleKey() {
        return this.titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public EditEngineTabItem getTabItem() {
        return this.tabItem;
    }

    public void setTabItem(EditEngineTabItem item) {
        this.tabItem = item;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setParentEditConfiguration(EditConfiguration config) {
        this.parentEditConfiguration = config;
    }

    public void setParentManagerConfiguration(ManagerConfiguration config) {
        this.parentManagerConfiguration = config;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(String requiredPermission) {
        this.requiredPermission = requiredPermission;
    }

    @Override
    public int compareTo(EngineTab o) {
        return this.getOrder() - o.getOrder();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                this.addTab(this.getEngineTabs(o));
            }
        } else if (this.parent != null) {
            this.addTab(this.getEngineTabs(this.parent));
        }
        if (this.parentManagerConfiguration != null) {
            this.addTab(this.getEngineTabs(this.parentManagerConfiguration));
        }
        if (this.parentEditConfiguration != null) {
            this.addTab(this.getEngineTabs(this.parentEditConfiguration));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        if (!JahiaContextLoaderListener.isRunning()) {
            return;
        }
        if (this.parent instanceof List) {
            for (Object o : (List)this.parent) {
                EngineTab.removeTab(this.getEngineTabs(o), this.getId());
            }
        } else {
            EngineTab.removeTab(this.getEngineTabs(this.parent), this.getId());
        }
        EngineTab.removeTab(this.getEngineTabs(this.parent), this.getId());
        EngineTab.removeTab(this.getEngineTabs(this.parentEditConfiguration), this.getId());
        EngineTab.removeTab(this.getEngineTabs(this.parentManagerConfiguration), this.getId());
    }

    private void addTab(List<List<EngineTab>> tabs) {
        if (!tabs.isEmpty()) {
            EngineTab.removeTab(tabs, this.getId());
            for (List<EngineTab> t : tabs) {
                int index = -1;
                if (this.position >= 0) {
                    index = this.position;
                } else if (this.positionBefore != null) {
                    index = t.indexOf(new EngineTab(this.positionBefore));
                } else if (this.positionAfter != null) {
                    index = t.indexOf(new EngineTab(this.positionAfter));
                    if (index != -1) {
                        ++index;
                    }
                    if (index >= tabs.size()) {
                        index = -1;
                    }
                }
                if (index != -1) {
                    t.add(index, this);
                    continue;
                }
                t.add(this);
            }
        } else if (this.parent != null) {
            throw new IllegalArgumentException("Unknown parent type '" + this.parent.getClass().getName() + "'. Can accept EditConfiguration, ManagerConfiguration, Engine or a String value with a beanId of the those beans");
        }
    }

    protected static void removeTab(List<List<EngineTab>> tabs, String tabId) {
        if (!tabs.isEmpty() && tabId != null && !tabId.isEmpty()) {
            for (List<EngineTab> t : tabs) {
                Iterator<EngineTab> iterator = t.iterator();
                while (iterator.hasNext()) {
                    EngineTab tab = iterator.next();
                    if (!tabId.equals(tab.getId())) continue;
                    iterator.remove();
                }
            }
        }
    }

    private List<List<EngineTab>> getEngineTabs(Object parent) {
        ArrayList<List<EngineTab>> results = new ArrayList<List<EngineTab>>();
        if (parent == null) {
            return results;
        }
        if (parent instanceof String) {
            parent = SpringContextSingleton.getBean((String)parent);
        }
        List<EngineTab> tabs = null;
        if (parent instanceof EditConfiguration) {
            tabs = ((EditConfiguration)parent).getDefaultEditConfiguration().getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((EditConfiguration)parent).getDefaultEditConfiguration().setEngineTabs(tabs);
            }
            for (Map.Entry<String, EditConfiguration> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, EditConfiguration.class).entrySet()) {
                if (!entry.getKey().startsWith(((EditConfiguration)parent).getName() + "-")) continue;
                results.addAll(this.getEngineTabs(entry.getValue()));
            }
        } else if (parent instanceof ManagerConfiguration) {
            tabs = ((ManagerConfiguration)parent).getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((ManagerConfiguration)parent).setEngineTabs(tabs);
            }
            for (Map.Entry<String, ManagerConfiguration> entry : SpringContextSingleton.getBeansOfType(this.applicationContext, ManagerConfiguration.class).entrySet()) {
                if (!entry.getKey().startsWith(((ManagerConfiguration)parent).getName() + "-")) continue;
                results.addAll(this.getEngineTabs(entry.getValue()));
            }
        } else if (parent instanceof EngineConfiguration) {
            tabs = ((EngineConfiguration)parent).getEngineTabs();
            if (tabs == null) {
                tabs = new LinkedList<EngineTab>();
                ((EngineConfiguration)parent).setEngineTabs(tabs);
            }
        } else if (parent instanceof Engine && (tabs = ((Engine)parent).getTabs()) == null) {
            tabs = new LinkedList<EngineTab>();
            ((Engine)parent).setTabs(tabs);
        }
        if (!results.contains(tabs)) {
            results.add(tabs);
        }
        return results;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setPositionAfter(String positionAfter) {
        this.positionAfter = positionAfter;
    }

    public void setPositionBefore(String positionBefore) {
        this.positionBefore = positionBefore;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            EngineTab other = (EngineTab)obj;
            return this.getId() != null ? other.getId() != null && this.getId().equals(other.getId()) : other.getId() == null;
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

