/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.wip;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRNodeWrapperImpl;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.wip.WIPInfo;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.security.AccessManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WIPService {
    private static final transient Logger logger = LoggerFactory.getLogger(WIPService.class);
    private JCRPublicationService publicationService;

    public void setPublicationService(JCRPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    public WIPInfo getWipInfo(JCRNodeWrapper node) throws RepositoryException {
        String status = "DISABLED";
        if (node.hasProperty("j:workInProgressStatus")) {
            status = node.getProperty("j:workInProgressStatus").getString();
        }
        HashSet<String> languages = new HashSet<String>();
        if (node.hasProperty("j:workInProgressLanguages")) {
            for (JCRValueWrapper langValue : node.getProperty("j:workInProgressLanguages").getValues()) {
                languages.add(langValue.getString());
            }
        }
        return new WIPInfo(status, languages);
    }

    public WIPInfo getDefaultWipInfo() {
        boolean isWipEnabled = Boolean.parseBoolean(SettingsBean.getInstance().getString("wip.checkbox.checked", "false"));
        return new WIPInfo(isWipEnabled ? "ALL_CONTENT" : "DISABLED", Collections.emptySet());
    }

    public void createWipPropertiesOnNewNode(JCRNodeWrapper node, WIPInfo wipInfo) throws RepositoryException {
        node.setProperty("j:workInProgressStatus", wipInfo.getStatus());
        Set<String> languages = wipInfo.getLanguages();
        node.setProperty("j:workInProgressLanguages", languages.toArray(new String[0]));
    }

    public void saveWipPropertiesIfNeeded(JCRNodeWrapper node, WIPInfo wipInfo) throws RepositoryException {
        if (!node.isNodeType("jmix:lastPublished") || wipInfo.getStatus() == null) {
            return;
        }
        String newWipStatus = null;
        Set<String> newWipLanguages = null;
        JCRSessionWrapper session = node.getSession();
        if (wipInfo.getStatus() != null && !wipInfo.getStatus().isEmpty() && ("ALL_CONTENT".equals(newWipStatus = wipInfo.getStatus()) || "DISABLED".equals(newWipStatus)) && !node.hasPermission(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", session.getWorkspace().getName()))) {
            return;
        }
        if (wipInfo.getLanguages() != null) {
            Sets.SetView modifiedLanguages;
            newWipLanguages = wipInfo.getLanguages();
            Set existingWipLanguages = Collections.emptySet();
            if (node.hasProperty("j:workInProgressLanguages")) {
                existingWipLanguages = new HashSet();
                for (JCRValueWrapper lang : node.getProperty("j:workInProgressLanguages").getValues()) {
                    existingWipLanguages.add(lang.getString());
                }
            }
            if (!(modifiedLanguages = Sets.symmetricDifference(newWipLanguages, existingWipLanguages)).isEmpty() && !node.hasPermission(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", session.getWorkspace().getName()))) {
                for (String modifiedLang : modifiedLanguages) {
                    if (node.hasPermission(AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}modifyProperties", session.getWorkspace().getName()) + "_" + modifiedLang)) continue;
                    throw new AccessDeniedException("Unable to update Work In Progress information on node " + node.getPath() + " for user " + session.getUser().getName() + " in locale " + modifiedLang);
                }
            }
        }
        this.updateWipStatus(node, newWipStatus, newWipLanguages);
    }

    private void updateWipStatus(JCRNodeWrapper node, String wipStatusToSet, Set<String> wipLangugagesToSet) throws RepositoryException {
        if (wipStatusToSet == null) {
            return;
        }
        JCRSessionWrapper session = node.getSession();
        boolean autoPublishNode = JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(session.getUser(), session.getWorkspace().getName(), session.getLocale(), systemSession -> {
            Node targetNode = systemSession.getProviderSession(node.getProvider()).getNodeByIdentifier(node.getIdentifier());
            boolean debugEnabled = logger.isDebugEnabled();
            boolean checkForAutoPublish = false;
            if (wipStatusToSet.equals("DISABLED") || wipStatusToSet.equals("LANGUAGES") && (wipLangugagesToSet == null || wipLangugagesToSet.isEmpty())) {
                targetNode.setProperty("j:workInProgressLanguages", (Value[])null);
                targetNode.setProperty("j:workInProgressStatus", (Value)null);
                if (debugEnabled) {
                    logger.debug("Removing WIP status property on node {}", (Object)targetNode.getPath());
                }
                checkForAutoPublish = true;
            } else {
                targetNode.setProperty("j:workInProgressStatus", wipStatusToSet);
                switch (wipStatusToSet) {
                    case "LANGUAGES": {
                        targetNode.setProperty("j:workInProgressLanguages", JCRContentUtils.createValues(wipLangugagesToSet, systemSession.getValueFactory()));
                        if (debugEnabled) {
                            logger.debug("Setting WIP languages on node {} to {}", (Object)targetNode.getPath(), (Object)wipLangugagesToSet);
                        }
                        checkForAutoPublish = true;
                        break;
                    }
                    case "ALL_CONTENT": {
                        targetNode.setProperty("j:workInProgressLanguages", (Value[])null);
                        if (!debugEnabled) break;
                        logger.debug("Setting WIP on node {}", (Object)targetNode.getPath());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown work in progress status: " + wipStatusToSet);
                    }
                }
            }
            targetNode.getSession().save();
            return checkForAutoPublish;
        });
        if (node instanceof JCRNodeWrapperImpl) {
            ((JCRNodeWrapperImpl)node).flushLocalCaches();
        }
        if (autoPublishNode) {
            this.checkForAutoPublication(node);
        }
    }

    private synchronized void checkForAutoPublication(JCRNodeWrapper node) throws RepositoryException {
        if (node.isNodeType("jmix:autoPublish")) {
            ArrayList<String> uuids = new ArrayList<String>();
            uuids.add(node.getIdentifier());
            NodeIterator translationNodes = node.getI18Ns();
            while (translationNodes.hasNext()) {
                uuids.add(translationNodes.nextNode().getIdentifier());
            }
            this.publicationService.publish(uuids, "default", "live", false, null);
        }
    }
}

