/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.settings;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.LoggerProvider;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.core.stats.StatManager;
import org.jahia.bin.Jahia;
import org.jahia.bin.errors.ErrorFileDumper;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.configuration.deployers.ServerDeploymentFactory;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.params.valves.CookieAuthConfig;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.settings.ClusterSettingsInitializer;
import org.jahia.settings.StartupOptions;
import org.jahia.settings.readonlymode.ReadOnlyModeCapable;
import org.jahia.settings.readonlymode.ReadOnlyModeController;
import org.jahia.tools.patches.Patcher;
import org.jahia.utils.DatabaseUtils;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.PathResolver;
import org.jahia.utils.properties.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.context.ServletContextAware;

public class SettingsBean
implements ServletContextAware,
InitializingBean,
ApplicationContextAware,
ReadOnlyModeCapable,
org.jahia.api.settings.SettingsBean {
    public static final String JAHIA_PROPERTIES_FILE_PATH = "/WEB-INF/etc/config/jahia.properties";
    @Deprecated
    public static final String JAHIA_BACKUP_RESTORE_SYSTEM_PROP = "jahia.backup-restore";
    private static final Logger logger = LoggerFactory.getLogger(SettingsBean.class);
    private static SettingsBean instance = null;
    private static volatile File errorDir;
    private static volatile File threadDir;
    private static volatile File heapDir;
    private final FastHashMap settings = new FastHashMap();
    private PathResolver pathResolver = null;
    private String licenseFilename;
    private String propertiesFileName;
    private int buildNumber;
    private Properties properties;
    private String classDiskPath;
    private long jahiaFileUploadMaxSize;
    private boolean useRelativeSiteURLs;
    private String defaultLanguageCode;
    private long jahiaJCRUserCountLimit = -1L;
    private int mail_maxRegroupingOfPreviousException = 500;
    private String characterEncoding;
    private String tmpContentDiskPath;
    private boolean isProcessingServer;
    private int siteURLPortOverride = -1;
    private boolean isSiteErrorEnabled;
    private String operatingMode = "development";
    private boolean productionMode = false;
    private boolean distantPublicationServerMode = true;
    private boolean considerPreferredLanguageAfterLogin;
    private boolean considerDefaultJVMLocale;
    private boolean permanentMoveForVanityURL = true;
    private boolean dumpErrorsToFiles = true;
    private int fileDumpMaxRegroupingOfPreviousException = 500;
    private boolean useJstackForThreadDumps;
    private boolean urlRewriteRemoveCmsPrefix;
    private boolean urlRewriteSeoRulesEnabled;
    private boolean urlRewriteUseAbsoluteUrls;
    private ServerDeploymentInterface serverDeployer = null;
    private boolean maintenanceMode;
    private int sessionExpiryTime;
    private ServletContext servletContext;
    private Resource licenseFile;
    private ApplicationContext applicationContext;
    private List<String> licenseFileLocations;
    private boolean disableJsessionIdParameter = true;
    private String jsessionIdParameterName = "jsessionid";
    private String guestUserResourceModuleName;
    private String guestUserResourceKey;
    private String guestGroupResourceModuleName;
    private String guestGroupResourceKey;
    private boolean fileServletStatisticsEnabled;
    private Locale defaultLocale;
    private int importMaxBatch;
    private int maxNameSize;
    private boolean expandImportedFilesOnDisk;
    private String expandImportedFilesOnDiskPath;
    private int accessManagerPathPermissionCacheMaxSize = 100;
    private int queryApproxCountLimit;
    private boolean readOnlyMode;
    private DataSource dataSource;
    private ClusterSettingsInitializer clusterSettingsInitializer;
    private String internetExplorerCompatibility;
    private boolean clusterActivated;
    private boolean isMavenExecutableSet;
    private String[] authorizedRedirectHosts;
    private boolean useWebsockets = false;
    private String atmosphereAsyncSupport;
    private boolean areaAutoActivated;
    private int jahiaSiteImportScannerInterval;
    private int moduleSpringBeansWaitingTimeout;
    private String server;
    private String serverVersion;
    private String serverHome;
    private String jahiaEtcDiskPath;
    private String jahiaVarDiskPath;
    private String jahiaWebAppsDeployerBaseURL;
    private String jahiaImportsDiskPath;
    private String jahiaModulesDiskPath;
    private String modulesSourcesDiskPath;
    private String jahiaDatabaseScriptsPath;
    private String jahiaGeneratedResourcesDiskPath;
    private int moduleStartLevel;
    private StartupOptions startupOptions;
    private Map<String, Set<String>> startupOptionsMapping;
    private long studioMaxDisplayableFileSize;
    private CookieAuthConfig cookieAuthConfig;
    private String atmosphereHeartbeatFrequency;

    public SettingsBean(PathResolver pathResolver, String propertiesFilename, String licenseFilename, int buildNumber) {
        this.pathResolver = pathResolver;
        this.propertiesFileName = propertiesFilename;
        this.buildNumber = buildNumber;
        this.licenseFilename = licenseFilename;
        instance = this;
    }

    public SettingsBean(PathResolver pathResolver, Properties props, List<String> licenseFileLocations) {
        this.pathResolver = pathResolver;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)props);
        this.licenseFileLocations = licenseFileLocations;
        instance = this;
    }

    public static SettingsBean getInstance() {
        return instance;
    }

    private static String ensureEndSlash(String path, boolean needsEndSlash) {
        char lastChar = path.charAt(path.length() - 1);
        if (lastChar == '/' || lastChar == '\\') {
            if (!needsEndSlash) {
                path = path.length() > 1 ? path.substring(0, path.length() - 1) : "";
            }
        } else if (needsEndSlash) {
            path = path + File.separatorChar;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getErrorDir() {
        if (errorDir != null) return errorDir;
        Class<SettingsBean> clazz = SettingsBean.class;
        synchronized (SettingsBean.class) {
            if (errorDir != null) return errorDir;
            errorDir = SettingsBean.getDirectory(new String[]{"jahia.error.dir", "jahia.log.dir", "java.io.tmpdir"}, "jahia-errors");
            // ** MonitorExit[var0] (shouldn't be in output)
            return errorDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getThreadDir() {
        if (threadDir != null) return threadDir;
        Class<SettingsBean> clazz = SettingsBean.class;
        synchronized (SettingsBean.class) {
            if (threadDir != null) return threadDir;
            threadDir = SettingsBean.getDirectory(new String[]{"jahia.thread.dir", "jahia.log.dir", "java.io.tmpdir"}, "jahia-threads");
            // ** MonitorExit[var0] (shouldn't be in output)
            return threadDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getHeapDir() {
        if (heapDir != null) return heapDir;
        Class<SettingsBean> clazz = SettingsBean.class;
        synchronized (SettingsBean.class) {
            if (heapDir != null) return heapDir;
            heapDir = SettingsBean.getDirectory(new String[]{"jahia.heap.dir", "jahia.log.dir", "java.io.tmpdir"}, "jahia-heaps");
            // ** MonitorExit[var0] (shouldn't be in output)
            return heapDir;
        }
    }

    private static File getDirectory(String[] parentDirectorySystemProperties, String childDirectoryName) {
        for (String parentDirectorySystemProperty : parentDirectorySystemProperties) {
            String parentDirectoryName = System.getProperty(parentDirectorySystemProperty);
            if (!StringUtils.isNotEmpty((String)parentDirectoryName)) continue;
            return new File(parentDirectoryName, childDirectoryName);
        }
        return new File(childDirectoryName);
    }

    private String interpolate(String source) {
        return source != null && source.length() > 0 && source.contains("${") ? SystemPropertyUtils.resolvePlaceholders((String)source, (boolean)true) : source;
    }

    @Override
    public String getJahiaDatabaseScriptsPath() {
        return this.jahiaDatabaseScriptsPath;
    }

    @Override
    public long getJahiaJCRUserCountLimit() {
        return this.jahiaJCRUserCountLimit;
    }

    public String getAtmosphereHeartbeatFrequency() {
        return this.atmosphereHeartbeatFrequency;
    }

    public void setJahiaJCRUserCountLimit(long jahiaJCRUserCountLimit) {
        this.jahiaJCRUserCountLimit = jahiaJCRUserCountLimit;
    }

    @Override
    public void load() {
        if (this.properties == null && this.propertiesFileName != null) {
            this.properties = new PropertiesManager(this.propertiesFileName).getPropertiesObject();
        }
        try {
            String zipEntryCharsets;
            this.detectServer();
            this.maintenanceMode = this.getBoolean("maintenanceMode", false);
            this.sessionExpiryTime = this.getInt("sessionExpiryTime", 60);
            this.initPaths();
            this.jahiaFileUploadMaxSize = this.getLong("jahiaFileUploadMaxSize", 0x6400000L);
            this.studioMaxDisplayableFileSize = this.getLong("studioMaxDisplayableFileSize", 0x100000L);
            this.characterEncoding = this.getString("characterEncoding", "UTF-8");
            if (System.getProperty("jahia.zipEntry.alternativeEncoding") == null && StringUtils.isNotEmpty((String)(zipEntryCharsets = this.getString("jahia.zipEntry.alternativeEncoding", null)))) {
                System.setProperty("jahia.zipEntry.alternativeEncoding", zipEntryCharsets);
            }
            this.useRelativeSiteURLs = this.getBoolean("useRelativeSiteURLs", false);
            this.jahiaJCRUserCountLimit = this.getLong("jahiaJCRUserCountLimit", -1L);
            this.jahiaWebAppsDeployerBaseURL = this.getString("jahiaWebAppsDeployerBaseURL", "http://127.0.0.1:8080/manager");
            this.defaultLanguageCode = this.getString("org.jahia.multilang.default_language_code", "en");
            this.defaultLocale = LanguageCodeConverters.languageCodeToLocale(this.defaultLanguageCode);
            this.considerDefaultJVMLocale = this.getBoolean("considerDefaultJVMLocale", false);
            this.considerPreferredLanguageAfterLogin = this.getBoolean("considerPreferredLanguageAfterLogin", false);
            this.mail_maxRegroupingOfPreviousException = this.getInt("mail_maxRegroupingOfPreviousException", 500);
            this.isProcessingServer = this.getBoolean("processingServer", true);
            this.siteURLPortOverride = this.getInt("siteURLPortOverride", 0);
            this.isSiteErrorEnabled = this.getBoolean("site.error.enabled", false);
            this.operatingMode = this.getString("operatingMode", "development");
            this.productionMode = !"development".equalsIgnoreCase(this.operatingMode);
            this.distantPublicationServerMode = "distantPublicationServer".equalsIgnoreCase(this.operatingMode);
            this.permanentMoveForVanityURL = this.getBoolean("permanentMoveForVanityURL", true);
            this.dumpErrorsToFiles = this.getBoolean("dumpErrorsToFiles", true);
            ErrorFileDumper.setFileDumpActivated(this.dumpErrorsToFiles);
            this.fileDumpMaxRegroupingOfPreviousException = this.getInt("fileDumpMaxRegroupingOfPreviousException", 500);
            this.useJstackForThreadDumps = this.getBoolean("useJstackForThreadDumps", false);
            this.urlRewriteSeoRulesEnabled = this.getBoolean("urlRewriteSeoRulesEnabled", false);
            this.urlRewriteRemoveCmsPrefix = this.getBoolean("urlRewriteRemoveCmsPrefix", false);
            this.urlRewriteUseAbsoluteUrls = this.getBoolean("urlRewriteUseAbsoluteUrls", true);
            this.disableJsessionIdParameter = this.getBoolean("disableJsessionIdParameter", true);
            this.jsessionIdParameterName = this.getString("jsessionIdParameterName", "jsessionid");
            this.guestUserResourceModuleName = this.getString("guestUserResourceModuleName");
            this.guestUserResourceKey = this.getString("guestUserResourceKey");
            this.guestGroupResourceModuleName = this.getString("guestGroupResourceModuleName");
            this.guestGroupResourceKey = this.getString("guestGroupResourceKey");
            this.fileServletStatisticsEnabled = this.getBoolean("jahia.fileServlet.statisticsEnabled", false);
            this.importMaxBatch = this.getInt("importMaxBatch", 500);
            this.maxNameSize = this.getInt("jahia.jcr.maxNameSize", 32);
            this.expandImportedFilesOnDisk = this.getBoolean("expandImportedFilesOnDisk", false);
            this.expandImportedFilesOnDiskPath = this.getString("expandImportedFilesOnDiskPath", "/tmp");
            this.accessManagerPathPermissionCacheMaxSize = this.getInt("accessManagerPathPermissionCacheMaxSize", 100);
            this.queryApproxCountLimit = this.getInt("queryApproxCountLimit", 100);
            this.readOnlyMode = this.getBoolean("readOnlyMode", false);
            this.internetExplorerCompatibility = this.getString("internetExplorerCompatibility", "IE=10");
            this.atmosphereAsyncSupport = this.getString("atmosphere.asyncSupport", null);
            this.useWebsockets = this.getBoolean("atmosphere.useWebsockets", false);
            this.areaAutoActivated = this.getBoolean("area.auto.activated", true);
            this.moduleSpringBeansWaitingTimeout = this.getInt("jahia.moduleSpringBeansWaitingTimeout", 300);
            this.moduleStartLevel = this.getInt("jahia.moduleStartLevel", 90);
            this.jahiaSiteImportScannerInterval = this.getInt("jahia.site.import.scanner.interval", 1000);
            this.atmosphereHeartbeatFrequency = this.getString("jahia.atmosphere.heartbeat", "60");
            String authorizedRedirectHostsStr = this.getString("authorizedRedirectHosts", null);
            this.authorizedRedirectHosts = StringUtils.isBlank((String)authorizedRedirectHostsStr) ? new String[]{} : authorizedRedirectHostsStr.trim().split("\\s*,\\s*");
            this.settings.put((Object)"userManagementUserNamePattern", (Object)this.getString("userManagementUserNamePattern", "[\\w\\{\\}\\-]+"));
            this.settings.put((Object)"userManagementGroupNamePattern", (Object)this.getString("userManagementGroupNamePattern", "[\\w\\{\\}\\-]+"));
            this.settings.put((Object)"default_templates_set", (Object)this.getString("default_templates_set"));
            this.settings.put((Object)"legacy.import.externalLink.internationalized", (Object)this.getBoolean("legacy.import.externalLink.internationalized", false));
            this.settings.put((Object)"legacy.import.externalLink.nodeType", (Object)this.getString("legacy.import.externalLink.nodeType", "jnt:externalLink"));
            this.settings.put((Object)"legacy.import.externalLink.urlPropertyName", (Object)this.getString("legacy.import.externalLink.urlPropertyName", "j:url"));
            this.settings.setFast(true);
            this.clusterActivated = this.getBoolean("cluster.activated", false);
            JahiaContextLoaderListener.setSystemProperty("cluster.activated", Boolean.toString(this.clusterActivated));
            if (System.getProperty("cluster.node.serverId") == null) {
                JahiaContextLoaderListener.setSystemProperty("cluster.node.serverId", this.getString("cluster.node.serverId", "jahiaServer1"));
            }
            DatabaseUtils.setDatasource(this.dataSource);
            this.initJcrSystemProperties();
            this.initStartupOptions();
            if (this.clusterActivated) {
                this.clusterSettingsInitializer.initClusterSettings(this);
            }
            this.checkIndexConsistencyIfNeeded();
            this.reindexIfNeeded();
            this.readTldConfigJarsToSkip();
            this.initJerichoLogging();
            this.initDatabaseIfNeeded();
            if (this.isProcessingServer()) {
                Patcher.getInstance().executeScripts("contextInitializing");
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.error("Properties file is not valid...!", (Throwable)e);
        }
    }

    private void initDatabaseIfNeeded() throws JahiaRuntimeException {
        if (DatabaseUtils.isDatabaseStructureInitialized()) {
            logger.info("Database structure is initialized");
        } else if (this.isProcessingServer() && this.getBoolean("db.init.auto", false)) {
            logger.info("Database structure is not initialized. Initalizing...");
            try {
                DatabaseUtils.initializeDatabaseStructure(this.getJahiaVarDiskPath(), this.applicationContext);
            }
            catch (Exception e) {
                logger.error("Error initializing database structure", (Throwable)e);
                throw new JahiaRuntimeException("Error initializing database structure", e);
            }
            logger.info("Finished initializing database structure");
        } else {
            logger.error("Database structure is not initialized. Leaving...");
            throw new JahiaRuntimeException("Database structure is not initialized");
        }
    }

    private void initStartupOptions() {
        this.startupOptions = new StartupOptions(this, this.startupOptionsMapping);
    }

    @Override
    public int getModuleStartLevel() {
        return this.moduleStartLevel;
    }

    private void initJerichoLogging() {
        if (!this.getBoolean("jahia.jericho.logging.enabled", false)) {
            Config.LoggerProvider = LoggerProvider.DISABLED;
        }
    }

    private void initJcrSystemProperties() {
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.consistencyCheck", String.valueOf(this.getBoolean("jahia.jackrabbit.consistencyCheck", false)));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.consistencyFix", String.valueOf(this.getBoolean("jahia.jackrabbit.consistencyFix", false)));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.onWorkspaceInconsistency", this.getString("jahia.jackrabbit.onWorkspaceInconsistency", "log"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.enableConsistencyCheck", this.getString("jahia.jackrabbit.searchIndex.enableConsistencyCheck", "false"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.forceConsistencyCheck", this.getString("jahia.jackrabbit.searchIndex.forceConsistencyCheck", "false"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.autoRepair", this.getString("jahia.jackrabbit.searchIndex.autoRepair", "false"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.skipVersionIndex", this.getString("jahia.jackrabbit.searchIndex.skipVersionIndex", "true"));
        JahiaContextLoaderListener.setSystemProperty("useNativeSort", this.getString("jahia.jackrabbit.useNativeSort", "true"));
        JahiaContextLoaderListener.setSystemProperty(StatManager.QUERY_STATS_ENABLED_PROPERTY, this.getString("jahia.jackrabbit.queryStatsEnabled", "true"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.indexLockTypesProperty", this.getString("jahia.jackrabbit.searchIndex.indexLockTypesProperty", "true"));
        JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.ismLocking", this.getString("jahia.jackrabbit.ismLocking", "org.apache.jackrabbit.core.state.DefaultISMLocking"));
        try {
            File repoHome = this.getRepositoryHome();
            if (System.getProperty("jahia.jackrabbit.datastore.path") == null) {
                String path = this.getString("jackrabbit.datastore.path", this.getString("jahia.jackrabbit.datastore.path", null));
                if (path != null) {
                    if (path.contains("${jahia.jackrabbit.home}")) {
                        path = StringUtils.replace((String)path, (String)"${jahia.jackrabbit.home}", (String)repoHome.getAbsolutePath());
                    }
                    path = new File(this.interpolate(path)).getCanonicalPath();
                } else {
                    path = new File(repoHome, "datastore").getAbsolutePath();
                }
                JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.datastore.path", path);
            }
            if (System.getProperty("jahia.jackrabbit.searchIndex.workspace.config") == null) {
                JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.workspace.config", this.getClass().getResource("/jahia/indexing_configuration.xml") != null ? "/jahia/indexing_configuration.xml" : new File(repoHome, "indexing_configuration.xml").getAbsolutePath());
            }
            if (System.getProperty("jahia.jackrabbit.searchIndex.versioning.config") == null) {
                JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.versioning.config", this.getClass().getResource("/jahia/indexing_configuration_version.xml") != null ? "/jahia/indexing_configuration_version.xml" : new File(repoHome, "indexing_configuration_version.xml").getAbsolutePath());
            }
            if (System.getProperty("org.apache.jackrabbit.server.remoting.davex.batchread-config") == null && this.getClass().getResource("/jahia/batchread.properties") != null) {
                JahiaContextLoaderListener.setSystemProperty("org.apache.jackrabbit.server.remoting.davex.batchread-config", "/jahia/batchread.properties");
            }
            this.setJackrabbitBundleCacheSize("jahia.jackrabbit.bundleCacheSize.workspace", null);
            this.setJackrabbitBundleCacheSize("jahia.jackrabbit.bundleCacheSize.workspace.default", this.properties.getProperty("jahia.jackrabbit.bundleCacheSize.workspace"));
            this.setJackrabbitBundleCacheSize("jahia.jackrabbit.bundleCacheSize.workspace.live", this.properties.getProperty("jahia.jackrabbit.bundleCacheSize.workspace"));
            this.setJackrabbitBundleCacheSize("jahia.jackrabbit.bundleCacheSize.versioning", null);
        }
        catch (IOException e) {
            logger.error("Unable to determine JCR repository home", (Throwable)e);
        }
    }

    private void setJackrabbitBundleCacheSize(String key, String defaultValue) {
        if (System.getProperty(key) == null && this.properties.getProperty(key, defaultValue) != null) {
            JahiaContextLoaderListener.setSystemProperty(key, this.properties.getProperty(key, defaultValue));
        }
    }

    public void initPaths() {
        this.classDiskPath = this.pathResolver.resolvePath("/WEB-INF/classes/");
        String jahiaDataDir = System.getProperty("jahia.data.dir");
        this.jahiaVarDiskPath = jahiaDataDir != null && jahiaDataDir.length() > 0 ? SettingsBean.ensureEndSlash(this.interpolate(jahiaDataDir), true) : SettingsBean.ensureEndSlash(SettingsBean.convertContexted(this.getString("jahiaVarDiskPath"), this.pathResolver), false);
        try {
            this.jahiaVarDiskPath = new File(this.jahiaVarDiskPath).getCanonicalPath();
        }
        catch (IOException e) {
            this.jahiaVarDiskPath = new File(this.jahiaVarDiskPath).getAbsolutePath();
        }
        JahiaContextLoaderListener.setSystemProperty("jahia.data.dir", this.jahiaVarDiskPath);
        this.jahiaEtcDiskPath = new File(SettingsBean.convertContexted(this.getString("jahiaEtcDiskPath", "$context/WEB-INF/etc/"), this.pathResolver)).getAbsolutePath();
        this.tmpContentDiskPath = new File(SettingsBean.convertContexted(this.getString("tmpContentDiskPath"), this.pathResolver)).getAbsolutePath();
        try {
            File tmpContentDisk = new File(this.tmpContentDiskPath);
            if (!tmpContentDisk.exists()) {
                tmpContentDisk.mkdirs();
            }
        }
        catch (Exception e) {
            logger.error("Provided folder for tmpContentDiskPath is not valid. Cause: " + e.getMessage(), (Throwable)e);
        }
        this.jahiaImportsDiskPath = new File(SettingsBean.convertContexted(this.getString("jahiaImportsDiskPath"), this.pathResolver)).getAbsolutePath();
        this.jahiaModulesDiskPath = new File(SettingsBean.convertContexted(this.getString("jahiaModulesDiskPath"), this.pathResolver)).getAbsolutePath();
        this.jahiaDatabaseScriptsPath = this.jahiaVarDiskPath + File.separator + "db";
        this.modulesSourcesDiskPath = new File(SettingsBean.convertContexted(this.getString("modulesSourcesDiskPath"), this.pathResolver)).getAbsolutePath();
        this.jahiaGeneratedResourcesDiskPath = new File(SettingsBean.convertContexted(this.getString("jahiaGeneratedResourcesDiskPath"), this.pathResolver)).getAbsolutePath();
    }

    private void detectServer() {
        this.server = this.getString("server", "");
        this.serverVersion = this.getString("serverVersion", null);
        this.serverHome = this.getString("serverHome", "");
        if (this.server.length() == 0 && this.servletContext != null) {
            logger.info("Auto-detecting server type...");
            if (!this.servletContext.getServerInfo().toLowerCase().contains("tomcat")) {
                logger.warn("Unable to auto-detect server type, based on the server info '{}'. Assuming Apache Tomcat.", (Object)this.servletContext.getServerInfo());
            }
            this.server = "tomcat";
            logger.info("...detected server type is '{}'", (Object)this.server);
        }
        if (this.serverHome.length() == 0) {
            logger.info("Auto-detecting server home...");
            if ("tomcat".equals(this.server)) {
                String home = System.getProperty("catalina.home");
                if (StringUtils.isNotEmpty((String)home)) {
                    this.serverHome = home;
                } else {
                    File tomcat;
                    File war = new File(JahiaContextLoaderListener.getWebAppRoot());
                    File webapps = war.getParentFile();
                    if (webapps != null && webapps.getName().equals("webapps") && (tomcat = webapps.getParentFile()) != null && new File(tomcat, "lib/catalina.jar").isFile()) {
                        this.serverHome = tomcat.getAbsolutePath();
                    }
                }
            }
            if (StringUtils.isEmpty((String)this.serverHome)) {
                this.serverHome = JahiaContextLoaderListener.getWebAppRoot();
            }
            logger.info("...detected server home is '{}'", (Object)this.serverHome);
        }
        if (!StringUtils.isEmpty((String)this.server) && !StringUtils.isEmpty((String)this.serverHome)) {
            this.serverDeployer = ServerDeploymentFactory.getImplementation((String)this.server, (String)this.serverVersion, (File)new File(this.serverHome).getAbsoluteFile(), null, null);
        }
    }

    @Override
    public boolean isClusterActivated() {
        return this.clusterActivated;
    }

    private void readTldConfigJarsToSkip() {
        File[] secondary;
        File cfgDir = new File(this.jahiaEtcDiskPath, "config");
        if (!cfgDir.isDirectory()) {
            return;
        }
        LinkedHashSet<File> cfgs = new LinkedHashSet<File>();
        File main = new File(cfgDir, "jar-scanner.conf");
        if (main.isFile()) {
            cfgs.add(main);
        }
        if ((secondary = cfgDir.listFiles((FileFilter)new WildcardFileFilter("jar-scanner.*.conf"))) != null && secondary.length > 0) {
            cfgs.addAll(Arrays.asList(secondary));
        }
        TreeSet jarsToSkip = new TreeSet();
        try {
            for (File cfg : cfgs) {
                jarsToSkip.addAll(FileUtils.readLines((File)cfg));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        jarsToSkip.remove("");
        if (!jarsToSkip.isEmpty()) {
            JahiaContextLoaderListener.setSystemProperty("org.jahia.TldConfig.jarsToSkip", StringUtils.join(jarsToSkip, (char)','));
            logger.info("Set system property (org.jahia.TldConfig.jarsToSkip) for JARs to be skipped during TLD search, including {} JARs", (Object)jarsToSkip.size());
            if (logger.isDebugEnabled()) {
                logger.debug("org.jahia.TldConfig.jarsToSkip: {}", (Object)System.getProperty("org.jahia.TldConfig.jarsToSkip"));
            }
        }
    }

    @Override
    public File getRepositoryHome() throws IOException {
        Resource r;
        File repoHome;
        String path = this.getString("jahia.jackrabbit.home", null);
        if (path == null) {
            path = this.interpolate("${jahia.data.dir}/repository");
        }
        if (!(repoHome = new File(path)).isAbsolute() && (r = this.applicationContext.getResource(path)) != null && r.exists()) {
            repoHome = r.getFile();
        }
        return repoHome.exists() ? repoHome.getAbsoluteFile() : null;
    }

    public Resource getRepositoryHomeResource() throws IOException {
        return new FileSystemResource(this.getRepositoryHome());
    }

    private void checkIndexConsistencyIfNeeded() {
        if (this.isStartupOptionSet("index-check")) {
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.enableConsistencyCheck", "true");
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.forceConsistencyCheck", "true");
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.autoRepair", "false");
        }
        if (this.isStartupOptionSet("index-fix")) {
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.enableConsistencyCheck", "true");
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.forceConsistencyCheck", "true");
            JahiaContextLoaderListener.setSystemProperty("jahia.jackrabbit.searchIndex.autoRepair", "true");
        }
    }

    private void reindexIfNeeded() {
        File repoHome = null;
        try {
            repoHome = this.getRepositoryHome();
            if (repoHome != null && (this.getBoolean("jahia.jackrabbit.reindexOnStartup", false) || this.isStartupOptionSet("reindex"))) {
                JCRContentUtils.deleteJackrabbitIndexes(repoHome);
            }
        }
        catch (IOException e) {
            logger.error("Unable to delete JCR repository index folders in home " + repoHome, (Throwable)e);
        }
    }

    @Override
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public boolean getBoolean(String propertyName, boolean defaultValue) {
        boolean result = defaultValue;
        String curProperty = this.getPropertyValue(propertyName);
        if (curProperty != null && !"".equals(curProperty = curProperty.trim())) {
            result = Boolean.valueOf(curProperty);
        }
        return result;
    }

    @Override
    public String getString(String propertyName) throws NoSuchElementException {
        String curProperty = this.getPropertyValue(propertyName);
        if (curProperty != null) {
            String result = curProperty.trim();
            return result;
        }
        throw new NoSuchElementException("No String found for property : " + propertyName);
    }

    @Override
    public String getString(String propertyName, String defaultValue) {
        String result = defaultValue;
        String curProperty = this.getPropertyValue(propertyName);
        if (curProperty != null) {
            result = curProperty.trim();
        }
        return result;
    }

    @Override
    public int getInt(String propertyName, int defaultValue) {
        int result = defaultValue;
        String curProperty = this.getPropertyValue(propertyName);
        if (curProperty != null) {
            curProperty = curProperty.trim();
            result = Integer.parseInt(curProperty);
        }
        return result;
    }

    @Override
    public long getLong(String propertyName, long defaultValue) {
        long result = defaultValue;
        String curProperty = this.getPropertyValue(propertyName);
        if (curProperty != null) {
            curProperty = curProperty.trim();
            result = Long.parseLong(curProperty);
        }
        return result;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        String result = this.properties.getProperty(propertyName);
        if (result != null && result.length() > 0 && result.contains("${")) {
            result = SystemPropertyUtils.resolvePlaceholders((String)result, (boolean)true);
        }
        return result;
    }

    @Override
    public String lookupString(String key) {
        Object param = this.settings.get((Object)key);
        if (param instanceof String) {
            return (String)param;
        }
        return null;
    }

    @Override
    public boolean lookupBoolean(String key) {
        Object param = this.settings.get((Object)key);
        if (param instanceof Boolean) {
            return (Boolean)param;
        }
        return false;
    }

    @Override
    public long lookupLong(String key) {
        Object param = this.settings.get((Object)key);
        if (param instanceof Long) {
            return (Long)param;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int lookupInt(String key) {
        Object param = this.settings.get((Object)key);
        if (param instanceof Integer) {
            return (Integer)param;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public Properties getPropertiesFile() {
        return this.properties;
    }

    @Override
    public String getLicenseFileName() {
        return this.licenseFilename;
    }

    @Override
    public boolean isUseRelativeSiteURLs() {
        return this.useRelativeSiteURLs;
    }

    public void setUseRelativeSiteURLs(boolean val) {
        this.useRelativeSiteURLs = val;
    }

    @Override
    public String getJahiaWebAppsDeployerBaseURL() {
        return this.jahiaWebAppsDeployerBaseURL;
    }

    @Override
    public String getDefaultLanguageCode() {
        return this.defaultLanguageCode;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServerHome() {
        return this.serverHome;
    }

    @Override
    public String getJahiaEtcDiskPath() {
        return this.jahiaEtcDiskPath;
    }

    @Override
    public String getJahiaVarDiskPath() {
        return this.jahiaVarDiskPath;
    }

    @Override
    public String getJahiaModulesDiskPath() {
        return this.jahiaModulesDiskPath;
    }

    @Override
    public String getJahiaGeneratedResourcesDiskPath() {
        return this.jahiaGeneratedResourcesDiskPath;
    }

    @Override
    public String getClassDiskPath() {
        return this.classDiskPath;
    }

    @Override
    public long getJahiaFileUploadMaxSize() {
        return this.jahiaFileUploadMaxSize;
    }

    @Override
    @Deprecated
    public String getJahiaHomeDiskPath() {
        return this.servletContext.getRealPath("./");
    }

    @Override
    public String getJahiaImportsDiskPath() {
        return this.jahiaImportsDiskPath;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    @Override
    public String getTmpContentDiskPath() {
        return this.tmpContentDiskPath;
    }

    @Override
    public String getModulesSourcesDiskPath() {
        return this.modulesSourcesDiskPath;
    }

    @Override
    public boolean isProcessingServer() {
        return this.isProcessingServer;
    }

    @Override
    public int getSiteURLPortOverride() {
        return this.siteURLPortOverride;
    }

    @Override
    public void setSiteURLPortOverride(int siteURLPortOverride) {
        this.siteURLPortOverride = siteURLPortOverride;
    }

    public int getMail_maxRegroupingOfPreviousException() {
        return this.mail_maxRegroupingOfPreviousException;
    }

    public void setMail_maxRegroupingOfPreviousException(int mail_maxRegroupingOfPreviousException) {
        this.mail_maxRegroupingOfPreviousException = mail_maxRegroupingOfPreviousException;
    }

    @Override
    public boolean isDevelopmentMode() {
        return !this.productionMode;
    }

    @Override
    public boolean getSiteErrorEnabled() {
        return this.isSiteErrorEnabled;
    }

    @Override
    public boolean isConsiderDefaultJVMLocale() {
        return this.considerDefaultJVMLocale;
    }

    public void setConsiderDefaultJVMLocale(boolean considerDefaultJVMLocale) {
        this.considerDefaultJVMLocale = considerDefaultJVMLocale;
    }

    @Override
    public boolean isConsiderPreferredLanguageAfterLogin() {
        return this.considerPreferredLanguageAfterLogin;
    }

    public void setConsiderPreferredLanguageAfterLogin(boolean considerPreferredLanguageAfterLogin) {
        this.considerPreferredLanguageAfterLogin = considerPreferredLanguageAfterLogin;
    }

    @Override
    public boolean isPermanentMoveForVanityURL() {
        return this.permanentMoveForVanityURL;
    }

    @Override
    public boolean isDumpErrorsToFiles() {
        return this.dumpErrorsToFiles;
    }

    public void setDumpErrorsToFiles(boolean dumpErrorsToFiles) {
        this.dumpErrorsToFiles = dumpErrorsToFiles;
    }

    @Override
    public int getFileDumpMaxRegroupingOfPreviousException() {
        return this.fileDumpMaxRegroupingOfPreviousException;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public ServerDeploymentInterface getServerDeployer() {
        return this.serverDeployer;
    }

    @Override
    public boolean isMaintenanceMode() {
        return this.maintenanceMode;
    }

    @Override
    public int getSessionExpiryTime() {
        return this.sessionExpiryTime;
    }

    public void setSessionExpiryTime(int sessionExpiryTime) {
        this.sessionExpiryTime = sessionExpiryTime;
    }

    @Override
    public boolean isDisableJsessionIdParameter() {
        return this.disableJsessionIdParameter;
    }

    public void setDisableJsessionIdParameter(boolean disableJsessionIdParameter) {
        this.disableJsessionIdParameter = disableJsessionIdParameter;
    }

    @Override
    public String getJsessionIdParameterName() {
        return this.jsessionIdParameterName;
    }

    public void setJsessionIdParameterName(String jsessionIdParameterName) {
        this.jsessionIdParameterName = jsessionIdParameterName;
    }

    @Override
    public String getGuestUserResourceKey() {
        return this.guestUserResourceKey;
    }

    @Override
    public String getGuestUserResourceModuleName() {
        return this.guestUserResourceModuleName;
    }

    @Override
    public String getGuestGroupResourceModuleName() {
        return this.guestGroupResourceModuleName;
    }

    public void setGuestGroupResourceModuleName(String guestGroupResourceModuleName) {
        this.guestGroupResourceModuleName = guestGroupResourceModuleName;
    }

    @Override
    public String getGuestGroupResourceKey() {
        return this.guestGroupResourceKey;
    }

    public void setGuestGroupResourceKey(String guestGroupResourceKey) {
        this.guestGroupResourceKey = guestGroupResourceKey;
    }

    public static String convertContexted(String convert, PathResolver pathResolver) {
        if (convert.startsWith("$context/")) {
            convert = pathResolver.resolvePath(convert.substring(8, convert.length()));
        }
        return convert;
    }

    public static String convertWebContexted(String convert) {
        return convert.startsWith("$webContext/") ? Jahia.getContextPath() + convert.substring("$webContext".length(), convert.length()) : convert;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public String getTemplatesContext() {
        return "/modules/";
    }

    public Resource getLicenseFile() {
        return this.licenseFile;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.setBuildNumber(Jahia.getBuildNumber());
        Jahia.setMaintenance(this.isMaintenanceMode());
        if (this.licenseFileLocations != null) {
            for (String location : this.licenseFileLocations) {
                String path = location.trim();
                if ("file:/".equals(path)) continue;
                try {
                    for (Resource resource : this.applicationContext.getResources(path)) {
                        if (!resource.exists()) continue;
                        this.licenseFile = resource;
                        break;
                    }
                    if (this.licenseFile == null) continue;
                    break;
                }
                catch (IOException iOException) {
                }
            }
        }
    }

    @Override
    public void switchReadOnlyMode(boolean enable) {
        this.setReadOnlyMode(enable);
    }

    @Override
    public int getReadOnlyModePriority() {
        return 1000;
    }

    @Override
    public String getOperatingMode() {
        return this.operatingMode;
    }

    @Override
    public boolean isProductionMode() {
        return this.productionMode;
    }

    @Override
    public boolean isDistantPublicationServerMode() {
        return this.distantPublicationServerMode;
    }

    @Override
    public boolean isUseJstackForThreadDumps() {
        return this.useJstackForThreadDumps;
    }

    @Override
    public boolean isUrlRewriteSeoRulesEnabled() {
        return this.urlRewriteSeoRulesEnabled;
    }

    @Override
    public boolean isFileServletStatisticsEnabled() {
        return this.fileServletStatisticsEnabled;
    }

    @Override
    public boolean isUrlRewriteUseAbsoluteUrls() {
        return this.urlRewriteUseAbsoluteUrls;
    }

    @Override
    public boolean isUrlRewriteRemoveCmsPrefix() {
        return this.urlRewriteRemoveCmsPrefix;
    }

    @Override
    public int getImportMaxBatch() {
        return this.importMaxBatch;
    }

    @Override
    public int getMaxNameSize() {
        return this.maxNameSize;
    }

    @Override
    public boolean isExpandImportedFilesOnDisk() {
        return this.expandImportedFilesOnDisk;
    }

    @Override
    public String getExpandImportedFilesOnDiskPath() {
        return this.expandImportedFilesOnDiskPath;
    }

    @Override
    public int getAccessManagerPathPermissionCacheMaxSize() {
        return this.accessManagerPathPermissionCacheMaxSize;
    }

    @Override
    public int getQueryApproxCountLimit() {
        return this.queryApproxCountLimit;
    }

    @Override
    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    @Override
    public boolean isFullReadOnlyMode() {
        return ReadOnlyModeController.getInstance().getReadOnlyStatus() != ReadOnlyModeController.ReadOnlyModeStatus.OFF;
    }

    public void setReadOnlyMode(boolean readOnlyMode) {
        this.readOnlyMode = readOnlyMode;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setClusterSettingsInitializer(ClusterSettingsInitializer clusterSettingsInitializer) {
        this.clusterSettingsInitializer = clusterSettingsInitializer;
    }

    @Override
    public String getInternetExplorerCompatibility() {
        return this.internetExplorerCompatibility;
    }

    @Override
    public boolean isMavenExecutableSet() {
        return this.isMavenExecutableSet;
    }

    public void setMavenExecutableSet(boolean isMavenExecutableSet) {
        this.isMavenExecutableSet = isMavenExecutableSet;
    }

    @Override
    public String[] getAuthorizedRedirectHosts() {
        return this.authorizedRedirectHosts;
    }

    @Override
    public boolean isUseWebsockets() {
        return this.useWebsockets;
    }

    public void setUseWebsockets(boolean useWebsockets) {
        this.useWebsockets = useWebsockets;
    }

    @Override
    public String getAtmosphereAsyncSupport() {
        return this.atmosphereAsyncSupport;
    }

    public void setAtmosphereAsyncSupport(String atmosphereAsyncSupport) {
        this.atmosphereAsyncSupport = atmosphereAsyncSupport;
    }

    @Override
    public boolean isAreaAutoActivated() {
        return this.areaAutoActivated;
    }

    @Override
    public int getModuleSpringBeansWaitingTimeout() {
        return this.moduleSpringBeansWaitingTimeout;
    }

    public void setModuleSpringBeansWaitingTimeout(int moduleSpringBeansWaitingTimeout) {
        this.moduleSpringBeansWaitingTimeout = moduleSpringBeansWaitingTimeout;
    }

    public void setLicenseFile(Resource licenseFile) {
        this.licenseFile = licenseFile;
    }

    @Override
    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    @Override
    public boolean isStartupOptionSet(String option) {
        return this.startupOptions.isSet(option);
    }

    public void setStartupOptionsMapping(Map<String, Set<String>> startupOptionsMapping) {
        this.startupOptionsMapping = startupOptionsMapping;
    }

    @Override
    public int getJahiaSiteImportScannerInterval() {
        return this.jahiaSiteImportScannerInterval;
    }

    @Override
    public long getStudioMaxDisplayableFileSize() {
        return this.studioMaxDisplayableFileSize;
    }

    @Override
    public CookieAuthConfig getCookieAuthConfig() {
        return this.cookieAuthConfig;
    }

    public void setCookieAuthConfig(CookieAuthConfig cookieAuthConfig) {
        this.cookieAuthConfig = cookieAuthConfig;
    }
}

