/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUpload {
    public static final String FILEUPLOAD_ATTRIBUTE = "fileUpload";
    private static final Logger logger = LoggerFactory.getLogger(FileUpload.class);
    private static final String UTF_8 = "UTF-8";
    private Map<String, List<String>> params;
    private Map<String, String> paramsContentType;
    private Map<String, DiskFileItem> files;
    private Map<String, DiskFileItem> filesByFieldName;
    private HttpServletRequest req;
    private String savePath = "";
    private String encoding;

    public FileUpload(HttpServletRequest req, String savePath, int fileMaxSize) throws IOException {
        this.req = req;
        this.savePath = savePath;
        this.encoding = UTF_8;
        this.init();
    }

    public FileUpload(HttpServletRequest req, String savePath, int fileMaxSize, String charset) throws IOException {
        this.req = req;
        this.savePath = savePath;
        this.encoding = charset == null ? UTF_8 : charset;
        this.init();
    }

    protected void init() throws IOException {
        this.params = new HashMap<String, List<String>>();
        this.paramsContentType = new HashMap<String, String>();
        this.files = new HashMap<String, DiskFileItem>();
        this.filesByFieldName = new HashMap<String, DiskFileItem>();
        this.parseQueryString();
        if (this.checkSavePath(this.savePath)) {
            try {
                ServletFileUpload upload = new ServletFileUpload();
                FileItemIterator iter = upload.getItemIterator(this.req);
                DiskFileItemFactory factory = null;
                while (iter.hasNext()) {
                    factory = this.prepareUploadFileItem(iter.next(), factory);
                }
            }
            catch (FileUploadException ioe) {
                throw new IOException(ioe.getMessage(), ioe);
            }
        } else {
            logger.error("FileUpload::init storage path does not exists or can write");
            throw new IOException("FileUpload::init storage path does not exists or cannot write");
        }
    }

    private DiskFileItemFactory prepareUploadFileItem(FileItemStream item, DiskFileItemFactory factory) throws FileUploadException, IOException {
        block20: {
            try (InputStream stream = item.openStream();){
                if (item.isFormField()) {
                    List<Object> v;
                    String name = item.getFieldName();
                    if (this.params.containsKey(name)) {
                        v = this.params.get(name);
                    } else {
                        v = new ArrayList();
                        this.params.put(name, v);
                    }
                    v.add(Streams.asString((InputStream)stream, (String)this.encoding));
                    this.paramsContentType.put(name, item.getContentType());
                    break block20;
                }
                if (factory == null) {
                    factory = new DiskFileItemFactory();
                    factory.setSizeThreshold(1);
                    factory.setRepository(new File(this.savePath));
                }
                DiskFileItem fileItem = (DiskFileItem)factory.createItem(item.getFieldName(), item.getContentType(), item.isFormField(), item.getName());
                try {
                    Streams.copy((InputStream)stream, (OutputStream)fileItem.getOutputStream(), (boolean)true);
                }
                catch (FileUploadBase.FileUploadIOException e) {
                    throw (FileUploadException)e.getCause();
                }
                catch (IOException e) {
                    throw new FileUploadBase.IOFileUploadException("Processing of multipart/form-data request failed. " + e.getMessage(), e);
                }
                FileItemHeaders fih = item.getHeaders();
                fileItem.setHeaders(fih);
                if (fileItem.getSize() > 0L) {
                    this.files.put(fileItem.getStoreLocation().getName(), fileItem);
                    this.filesByFieldName.put(fileItem.getFieldName(), fileItem);
                }
            }
        }
        return factory;
    }

    public Set<String> getParameterNames() {
        return this.params.keySet();
    }

    public Map<String, List<String>> getParameterMap() {
        return this.params;
    }

    public void setParameterMap(Map<String, List<String>> params) {
        this.params = params;
    }

    public String[] getParameterValues(String paramName) {
        List<String> list = this.params.get(paramName);
        if (list == null) {
            return null;
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    public String getParameterContentType(String paramName) {
        return this.paramsContentType.get(paramName);
    }

    public Set<String> getFileNames() {
        return this.files.keySet();
    }

    public File getFile(String n) {
        return this.files.get(n).getStoreLocation();
    }

    public Map<String, DiskFileItem> getFileItems() {
        return this.filesByFieldName;
    }

    public String getFileSystemName(String n) {
        return this.files.get(n).getName();
    }

    public String getFormFieldName(String n) {
        return this.files.get(n).getFieldName();
    }

    public String getFileContentType(String n) {
        return this.files.get(n).getContentType();
    }

    public void markFilesAsConsumed() {
        this.files = null;
        this.filesByFieldName = null;
    }

    protected boolean checkSavePath(String path) {
        if (path != null && path.length() > 0) {
            File tmpFile;
            if (logger.isDebugEnabled()) {
                logger.debug("path is {}", (Object)path);
            }
            if ((tmpFile = new File(path)).isDirectory() && tmpFile.canWrite()) {
                this.savePath = path;
                return true;
            }
            return false;
        }
        return false;
    }

    public void disposeItems() {
        if (this.getFileItems() == null) {
            return;
        }
        for (DiskFileItem item : this.getFileItems().values()) {
            if (item == null) continue;
            try {
                item.delete();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("Unable to delete the uploaded file item " + item.getName(), (Throwable)e);
                    continue;
                }
                logger.warn("Unable to delete the uploaded file item {}", (Object)item.getName());
            }
        }
    }

    protected void parseQueryString() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.req.getQueryString());
        }
        if (this.req.getQueryString() == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.req.getQueryString(), "&");
        while (tokenizer.hasMoreTokens()) {
            List<Object> v;
            String param = tokenizer.nextToken();
            int pos = param.indexOf(61);
            if (pos <= 0) continue;
            String name = param.substring(0, pos);
            String value = param.substring(pos + 1, param.length());
            if (this.params.containsKey(name)) {
                v = this.params.get(name);
            } else {
                v = new ArrayList();
                this.params.put(name, v);
            }
            v.add(value);
        }
    }
}

