/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.IOException;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.provisioning.ProvisioningManager;
import org.jahia.tools.patches.PatchExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvisioningPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ProvisioningPatcher.class);

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return lifecyclePhase.equals("") && name.endsWith(".yaml");
    }

    @Override
    public String executeScript(String name, String scriptContent) {
        ProvisioningManager provisioningManager = BundleUtils.getOsgiService(ProvisioningManager.class, null);
        try {
            provisioningManager.executeScript(scriptContent, "yaml");
            return ".installed";
        }
        catch (IOException e) {
            logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
            return ".failed";
        }
    }
}

