/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.tools.patches;

import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import org.jahia.tools.patches.PatchExecutor;
import org.jahia.utils.DatabaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlPatcher
implements PatchExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SqlPatcher.class);

    @Override
    public boolean canExecute(String name, String lifecyclePhase) {
        return name.endsWith(".sql") && lifecyclePhase.equals("contextInitializing");
    }

    @Override
    public String executeScript(String name, String scriptContent) {
        if (name.contains("/" + (Object)((Object)DatabaseUtils.getDatabaseType()) + "/")) {
            try {
                DatabaseUtils.executeScript(new StringReader(scriptContent));
                return ".installed";
            }
            catch (IOException | SQLException e) {
                logger.error("Execution of script failed with error: {}", (Object)e.getMessage(), (Object)e);
                return ".failed";
            }
        }
        return ".skipped";
    }
}

