/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.jahia.utils.Log4jEventCollector;

public class Log4jEventCollectorWrapper
implements AutoCloseable {
    private Log4jEventCollector target;

    public Log4jEventCollectorWrapper(int level) {
        this(level, level);
    }

    public Log4jEventCollectorWrapper(int minLevel, int maxLevel) {
        this.target = new Log4jEventCollector(minLevel, maxLevel);
        Logger.getRootLogger().addAppender((Appender)this.target);
    }

    @Override
    public void close() {
        Logger.getRootLogger().removeAppender((Appender)this.target);
        this.target.close();
    }

    public List<LoggingEventWrapper> getCollectedEvents() {
        return Log4jEventCollectorWrapper.convert(this.target.getCollectedEvents());
    }

    private static List<LoggingEventWrapper> convert(List<LoggingEvent> events) {
        ArrayList<LoggingEventWrapper> result = new ArrayList<LoggingEventWrapper>(events.size());
        for (LoggingEvent event : events) {
            result.add(new LoggingEventWrapper(event));
        }
        return result;
    }

    public static class LoggingEventWrapper {
        private LoggingEvent target;

        public LoggingEventWrapper(LoggingEvent target) {
            this.target = target;
        }

        public int getLevel() {
            return this.target.getLevel().toInt();
        }

        public long getTimestamp() {
            return this.target.getTimeStamp();
        }

        public String getMessage() {
            return this.target.getRenderedMessage();
        }

        public String[] getThrowableInfo() {
            return this.target.getThrowableStrRep();
        }
    }
}

