/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.spring.http.converter.json;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jahia.exceptions.JahiaRuntimeException;
import org.osgi.framework.BundleReference;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class JahiaMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private static final Map<String, Class<?>[]> PARAMETER_TYPES = new HashMap<String, Class<?>[]>(5);
    private Object delegate;
    private Function<String, Method> methodProvider = new Function<String, Method>(){

        @Override
        public Method apply(String name) {
            try {
                Method targetMethod = JahiaMappingJackson2HttpMessageConverter.this.delegate.getClass().getDeclaredMethod(name, (Class[])PARAMETER_TYPES.get(name));
                if (!targetMethod.isAccessible()) {
                    targetMethod.setAccessible(true);
                }
                return targetMethod;
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new JahiaRuntimeException(e);
            }
        }
    };
    private Map<String, Method> methods = new ConcurrentHashMap<String, Method>();

    private Object call(Method method, Object ... args) {
        try {
            return method.invoke(this.delegate, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        if (this.shouldDelegate(type)) {
            return (Boolean)this.call(this.getMethod("canRead"), type, contextClass, mediaType);
        }
        return super.canRead(type, contextClass, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (this.shouldDelegate(clazz)) {
            return (Boolean)this.call(this.getMethod("canWrite"), clazz, mediaType);
        }
        return super.canWrite(clazz, mediaType);
    }

    private Method getMethod(String methodName) {
        return this.methods.computeIfAbsent(methodName, this.methodProvider);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (this.shouldDelegate(type)) {
            return this.call(this.getMethod("read"), type, contextClass, inputMessage);
        }
        return super.read(type, contextClass, inputMessage);
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (this.shouldDelegate(clazz)) {
            return this.call(this.getMethod("readInternal"), clazz, inputMessage);
        }
        return super.readInternal(clazz, inputMessage);
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
        this.methods.clear();
    }

    protected boolean shouldDelegate(Object obj) {
        if (this.delegate != null && obj != null) {
            ClassLoader classLoader = obj instanceof Class ? ((Class)obj).getClassLoader() : obj.getClass().getClassLoader();
            return classLoader instanceof BundleReference;
        }
        return false;
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (this.shouldDelegate(object)) {
            this.call(this.getMethod("writeInternal"), object, outputMessage);
        } else {
            super.writeInternal(object, outputMessage);
        }
    }

    static {
        PARAMETER_TYPES.put("canRead", new Class[]{Type.class, Class.class, MediaType.class});
        PARAMETER_TYPES.put("canWrite", new Class[]{Class.class, MediaType.class});
        PARAMETER_TYPES.put("read", new Class[]{Type.class, Class.class, HttpInputMessage.class});
        PARAMETER_TYPES.put("readInternal", new Class[]{Class.class, HttpInputMessage.class});
        PARAMETER_TYPES.put("writeInternal", new Class[]{Object.class, HttpOutputMessage.class});
    }
}

