/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.xml;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaTransformerFactory {
    private static final Logger logger = LoggerFactory.getLogger(JahiaTransformerFactory.class);

    private JahiaTransformerFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static TransformerFactory newInstance() {
        return JahiaTransformerFactory.setDefaultAttributes(TransformerFactory.newInstance());
    }

    public static TransformerFactory newInstance(Class<? extends TransformerFactory> transformerFactoryClass) {
        try {
            return JahiaTransformerFactory.setDefaultAttributes(transformerFactoryClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TransformerFactoryConfigurationError(e, "Could not instantiate TransformerFactory [" + transformerFactoryClass + "]");
        }
    }

    private static TransformerFactory setDefaultAttributes(TransformerFactory factory) {
        JahiaTransformerFactory.setOptionalAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        JahiaTransformerFactory.setOptionalAttribute(factory, "http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        JahiaTransformerFactory.setOptionalFeature(factory, "http://saxon.sf.net/feature/allow-external-functions", false);
        return factory;
    }

    private static void setOptionalAttribute(TransformerFactory factory, String name, Object value) {
        block2: {
            try {
                factory.setAttribute(name, value);
            }
            catch (IllegalArgumentException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("{} property not supported by {}", (Object)name, (Object)factory.getClass().getCanonicalName());
            }
        }
    }

    private static void setOptionalFeature(TransformerFactory factory, String name, boolean value) {
        block2: {
            try {
                factory.setFeature(name, value);
            }
            catch (IllegalArgumentException | TransformerConfigurationException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("{} feature not supported by {}", (Object)name, (Object)factory.getClass().getCanonicalName());
            }
        }
    }
}

