/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.decorator.JCRFileContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipEntryCharsetDetector {
    private static volatile List<Charset> charsetTryChain;
    public static final String ZIP_ENTRY_ALTERNATIVE_ENCODING = "jahia.zipEntry.alternativeEncoding";
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canRead(File file, Charset charset) throws IOException {
        boolean canRead = true;
        ZipFile zip = null;
        try {
            zip = charset != null ? new ZipFile(file, charset) : new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            try {
                while (entries.hasMoreElements()) {
                    entries.nextElement();
                }
            }
            catch (IllegalArgumentException e) {
                canRead = false;
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canRead(InputStream is, Charset charset) throws IOException {
        boolean canRead = true;
        ZipInputStream zis = null;
        try {
            zis = charset != null ? new ZipInputStream(is, charset) : new ZipInputStream(is);
            try {
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    entry = zis.getNextEntry();
                }
            }
            catch (IllegalArgumentException e) {
                canRead = false;
            }
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return canRead;
    }

    public static Charset detect(File zipFile) {
        try {
            for (Charset c : ZipEntryCharsetDetector.getCharsetTryChain()) {
                if (!ZipEntryCharsetDetector.canRead(zipFile, c)) continue;
                return c;
            }
        }
        catch (IOException e) {
            logger.warn("Error checking charset for the file " + zipFile, (Throwable)e);
        }
        logger.warn("Unable to find a charset to read the entries of a provided ZIP file: {}", (Object)zipFile);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(InputStream resettableInputStream) {
        try {
            for (Charset c : ZipEntryCharsetDetector.getCharsetTryChain()) {
                try {
                    if (!ZipEntryCharsetDetector.canRead(resettableInputStream, c)) continue;
                    Charset charset = c;
                    return charset;
                }
                finally {
                    resettableInputStream.reset();
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error checking charset for the input stream", (Throwable)e);
        }
        logger.warn("Unable to find a charset to read the entries of a provided ZIP file stream");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(JCRFileContent zipFileNode) {
        try {
            Iterator<Charset> iterator = ZipEntryCharsetDetector.getCharsetTryChain().iterator();
            while (iterator.hasNext()) {
                Charset c = iterator.next();
                InputStream is = null;
                try {
                    is = zipFileNode.downloadFile();
                    if (!ZipEntryCharsetDetector.canRead(is, c)) continue;
                    Charset charset = c;
                    return charset;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            return null;
        }
        catch (IOException e) {
            logger.warn("Error checking charset for the file node", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(URL resourceUrl) {
        try {
            for (Charset c : ZipEntryCharsetDetector.getCharsetTryChain()) {
                InputStream is = null;
                try {
                    is = resourceUrl.openStream();
                    if (!ZipEntryCharsetDetector.canRead(is, c)) continue;
                    Charset charset = c;
                    return charset;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error checking charset for the input stream", (Throwable)e);
        }
        logger.warn("Unable to find a charset to read the entries of a provided ZIP resource {}", (Object)resourceUrl);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Charset> getCharsetTryChain() {
        if (charsetTryChain != null) return charsetTryChain;
        Class<ZipEntryCharsetDetector> clazz = ZipEntryCharsetDetector.class;
        synchronized (ZipEntryCharsetDetector.class) {
            if (charsetTryChain != null) return charsetTryChain;
            String encoding = System.getProperty(ZIP_ENTRY_ALTERNATIVE_ENCODING, "Cp437");
            LinkedList<Charset> charsets = new LinkedList<Charset>();
            for (String c : StringUtils.split((String)encoding, (String)" ,")) {
                try {
                    charsets.add(Charset.forName(c));
                }
                catch (UnsupportedCharsetException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (!charsets.contains(StandardCharsets.UTF_8)) {
                charsets.add(0, StandardCharsets.UTF_8);
            }
            charsetTryChain = charsets;
            // ** MonitorExit[var0] (shouldn't be in output)
            return charsetTryChain;
        }
    }

    static {
        logger = LoggerFactory.getLogger(ZipEntryCharsetDetector.class);
    }
}

