/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileService {
    private String sep = System.getProperty("file.separator");

    public String getFileName(List<String> availableFileNames) {
        String fileName = null;
        if (ContentGeneratorService.currentFileIndex == availableFileNames.size()) {
            ContentGeneratorService.currentFileIndex = 0;
        }
        fileName = availableFileNames.get(ContentGeneratorService.currentFileIndex);
        ++ContentGeneratorService.currentFileIndex;
        return fileName;
    }

    public List<String> getFileNamesAvailable(File filesDirectory) {
        ArrayList<String> fileNames = new ArrayList<String>();
        System.out.println(filesDirectory.getAbsolutePath());
        Object[] files = filesDirectory.listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            if (!((File)files[i]).isFile()) continue;
            fileNames.add(((File)files[i]).getName());
        }
        return fileNames;
    }

    public List<File> getFilesAvailable(File filesDirectory) {
        List<String> filenames = this.getFileNamesAvailable(filesDirectory);
        ArrayList<File> fileList = new ArrayList<File>();
        for (String fileName : filenames) {
            File f = new File(filesDirectory, fileName);
            fileList.add(f);
        }
        return fileList;
    }

    public List<File> copyFilesForAttachment(List<File> filesToCopy, File destDir) throws IOException {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (File oldFile : filesToCopy) {
            String fileName = oldFile.getName();
            FileUtils.copyFileToDirectory((File)oldFile, (File)destDir);
            File newFile = new File(destDir, oldFile.getName());
            newFiles.add(newFile);
        }
        return newFiles;
    }

    public void createAndPopulateFilesXmlFile(File tempXmlFile, List<File> fileNames) throws IOException {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        int year = gc.get(1);
        int month = gc.get(2);
        int day = gc.get(5);
        int hour = gc.get(10);
        int minute = gc.get(12);
        int second = gc.get(13);
        String now = "2011-06-09T12:18:35.562-04:00";
        FileUtils.writeStringToFile((File)tempXmlFile, (String)this.sep);
        StringBuffer filesXml = new StringBuffer();
        filesXml.append("\t<files jcr:primaryType=\"jnt:folder\">");
        filesXml.append("    <contributed jcr:mixinTypes=\"jmix:accessControlled\" jcr:primaryType=\"jnt:folder\">\n");
        filesXml.append("     <j:acl jcr:primaryType=\"jnt:acl\">\n");
        filesXml.append("        <GRANT_g_site-privileged j:aceType=\"GRANT\" j:principal=\"g:privileged\" j:protected=\"false\" j:roles=\"contributor\" jcr:primaryType=\"jnt:ace\" />\n");
        filesXml.append("     </j:acl>\n");
        for (File file : fileNames) {
            String fileName = file.getName();
            filesXml.append("          <" + fileName + " jcr:primaryType=\"jnt:file\" jcr:title=\"" + fileName + "\">\n");
            filesXml.append("             <jcr:content jcr:mimeType=\"application/txt\" jcr:primaryType=\"jnt:resource\" />\n");
            filesXml.append("          </" + fileName + ">\n");
        }
        filesXml.append("    </contributed>\n");
        filesXml.append("</files>\n");
        FileUtils.writeStringToFile((File)tempXmlFile, (String)filesXml.toString());
    }

    private String getFileNameWithoutExtension(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }
}

