/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBO {
    private String uniqueName;
    private Map<String, ArticleBO> articles;
    private Integer level;
    private List<PageBO> subPages;
    private PageBO parentPage;
    private Boolean hasVanity;
    private String siteKey;
    private String fileName;
    private Integer numberBigText;
    private Map<String, List<String>> acls;
    private Integer idCategory;
    private Integer idTag;
    private Boolean visibilityEnabled;
    private String visibilityStartDate;
    private String visibilityEndDate;

    public void setIdCategory(Integer idCategory) {
        this.idCategory = idCategory;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<PageBO> getSubPages() {
        return this.subPages;
    }

    public void setSubPages(List<PageBO> subPages) {
        this.subPages = subPages;
    }

    public PageBO getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageBO parentPage) {
        this.parentPage = parentPage;
    }

    public Map<String, ArticleBO> getArticles() {
        return this.articles;
    }

    public void setArticles(Map<String, ArticleBO> articles) {
        this.articles = articles;
    }

    public Boolean getHasVanity() {
        return this.hasVanity;
    }

    public void setHasVanity(Boolean hasVanity) {
        this.hasVanity = hasVanity;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getNumberBigText() {
        return this.numberBigText;
    }

    public void setNumberBigText(Integer numberBigText) {
        this.numberBigText = numberBigText;
    }

    public Map<String, List<String>> getAcls() {
        return this.acls;
    }

    public void setAcls(Map<String, List<String>> acls) {
        this.acls = acls;
    }

    public Integer getIdTag() {
        return this.idTag;
    }

    public void setIdTag(Integer idTag) {
        this.idTag = idTag;
    }

    public void setVisibilityEnabled(Boolean visibilityEnabled) {
        this.visibilityEnabled = visibilityEnabled;
    }

    public void setVisibilityStartDate(String visibilityStartDate) {
        this.visibilityStartDate = visibilityStartDate;
    }

    public void setVisibilityEndDate(String visibilityEndDate) {
        this.visibilityEndDate = visibilityEndDate;
    }

    public PageBO(String pUniqueName, Map<String, ArticleBO> articles, int pLevel, List<PageBO> pSubPages, Boolean pHasVanity, String pSiteKey, String pFileName, Integer pNumberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate) {
        this.articles = articles;
        this.level = pLevel;
        this.subPages = pSubPages;
        this.uniqueName = pUniqueName;
        this.hasVanity = pHasVanity;
        this.siteKey = pSiteKey;
        this.fileName = pFileName;
        this.numberBigText = pNumberBigText;
        this.acls = acls;
        this.idCategory = idCategory;
        this.idTag = idTag;
        this.visibilityEnabled = visibilityEnabled;
        this.visibilityStartDate = visibilityStartDate;
        this.visibilityEndDate = visibilityEndDate;
    }

    public String getHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t<!-- generated page (level " + this.getLevel() + ") -->\n");
        sb.append("\t<" + this.getUniqueName() + " xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" xmlns:nt=\"http://www.jcp.org/jcr/nt/1.0\" xmlns:jnt=\"http://www.jahia.org/jahia/nt/1.0\" xmlns:test=\"http://www.apache.org/jackrabbit/test\" xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" xmlns:jmix=\"http://www.jahia.org/jahia/mix/1.0\" xmlns:j=\"http://www.jahia.org/jahia/1.0\" xmlns:mix=\"http://www.jcp.org/jcr/mix/1.0\" xmlns:rep=\"internal\" changefreq=\"monthly\" j:templateNode=\"/sites/" + this.getSiteKey() + "/templates/base/events\" jcr:mixinTypes=\"");
        if (this.getHasVanity().booleanValue()) {
            sb.append("jmix:vanityUrlMapped ");
        }
        if (this.idCategory != null) {
            sb.append(" jmix:categorized ");
        }
        sb.append(" jmix:sitemap\" jcr:primaryType=\"jnt:page\" priority=\"0.5\"");
        if (this.idCategory != null) {
            sb.append(" j:defaultCategory=\"/sites/systemsite/categories/category" + this.idCategory + "\" ");
        }
        if (this.idTag != null) {
            sb.append(" j:tags=\"/sites/" + this.siteKey + "/tags/tag" + this.idTag + "\"");
        }
        sb.append(">\n");
        for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
            sb.append("\t\t<j:translation_" + entry.getKey() + " jcr:language=\"" + entry.getKey() + "\" jcr:mixinTypes=\"mix:title\" jcr:primaryType=\"jnt:translation\" jcr:title=\"" + this.formatForXml(entry.getValue().getTitle()) + "\" />\n");
        }
        if (!this.acls.isEmpty()) {
            sb.append("\t\t<j:acl j:inherit=\"true\" jcr:primaryType=\"jnt:acl\">\n");
            for (Map.Entry<String, Object> entry : this.acls.entrySet()) {
                String roles = "";
                for (String s : (List)entry.getValue()) {
                    roles = roles + s + " ";
                }
                sb.append("\t\t    <GRANT_" + entry.getKey().replace(":", "_") + " j:aceType=\"GRANT\" j:principal=\"" + entry.getKey() + "\" j:protected=\"false\" j:roles=\"" + roles.trim() + "\" jcr:primaryType=\"jnt:ace\"/>\n");
            }
            sb.append("     </j:acl>\n");
        }
        sb.append("\t\t<listA jcr:primaryType=\"jnt:contentList\">\n");
        for (int i = 1; i <= this.numberBigText; ++i) {
            sb.append("\t\t\t<bigText_" + i + " jcr:mixinTypes=\"jmix:renderable\" jcr:primaryType=\"jnt:bigText\">\n");
            for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                sb.append("\t\t\t\t<j:translation_" + entry.getKey() + " jcr:language=\"" + entry.getKey() + "\" jcr:primaryType=\"jnt:translation\" text=\"" + this.formatForXml(entry.getValue().getContent()) + " \" />");
            }
            sb.append("\t\t\t</bigText_" + i + ">\n");
        }
        if (this.getFileName() != null) {
            sb.append(" \t\t<random-file jcr:primaryType=\"jnt:fileReference\"> \t\t\t<j:translation_en  jcr:language=\"en\" jcr:primaryType=\"jnt:translation\" jcr:title=\"My file\" />\t\t\t</random-file>");
            sb.append(" \t\t<publication jcr:primaryType=\"jnt:publication\">\t\t\t\t<j:translation_en author=\"Jahia Content Generator\" body=\"&lt;p&gt;  Random publication&lt;/p&gt; \" date=\"01/01/1970\" file=\"/sites/" + this.getSiteKey() + "/files/contributed/" + this.getFileName() + "\" jcr:language=\"en\" jcr:primaryType=\"jnt:translation\" jcr:title=\"Random publication\" source=\"Jahia\" />" + "\t\t\t</publication>");
        }
        sb.append("\t\t</listA>\n");
        if (this.getHasVanity().booleanValue()) {
            sb.append(" \t<vanityUrlMapping jcr:primaryType=\"jnt:vanityUrls\">\t\t\t<_x0025_2F" + this.getUniqueName() + " j:active=\"true\" j:default=\"true\" j:url=\"/" + this.getUniqueName() + "\" jcr:language=\"en\" jcr:primaryType=\"jnt:vanityUrl\" />" + "\t\t</vanityUrlMapping>");
        }
        if (this.visibilityEnabled.booleanValue()) {
            sb.append("<j:conditionalVisibility j:forceMatchAllConditions=\"true\" jcr:primaryType=\"jnt:conditionalVisibility\">");
            sb.append("\t<jnt:startEndDateCondition0 end=\"" + this.visibilityEndDate + "\" jcr:primaryType=\"jnt:startEndDateCondition\" start=\"" + this.visibilityStartDate + "\" />");
            sb.append("</j:conditionalVisibility>");
        }
        return sb.toString();
    }

    public String getFooter() {
        return new String("\t\t</" + this.getUniqueName() + ">\n");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHeader());
        if (null != this.subPages) {
            for (PageBO subPage : this.subPages) {
                sb.append(subPage.toString());
            }
        }
        sb.append(this.getFooter());
        return sb.toString();
    }

    public String formatForXml(String s) {
        String formattedString = StringUtils.replace((String)s, (String)"&", (String)"&amp;");
        formattedString = StringUtils.replace((String)formattedString, (String)"\"", (String)" &quot;");
        formattedString = StringUtils.replace((String)formattedString, (String)"<", (String)"&lt;");
        formattedString = StringUtils.replace((String)formattedString, (String)">", (String)"&gt;");
        formattedString = StringUtils.replace((String)formattedString, (String)"'", (String)"&#39;");
        return formattedString;
    }
}

