/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.utils.maven.plugin.contentgenerator.DatabaseService;
import org.jahia.utils.maven.plugin.contentgenerator.TagService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.FileAndFolderService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.NoteService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.PollService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.TaskService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.DocspaceBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FolderBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.NoteBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.PollBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.TaskBO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocspaceService {
    private static DocspaceService instance;
    private Log logger = new SystemStreamLog();

    private DocspaceService() {
    }

    public static DocspaceService getInstance() {
        if (instance == null) {
            instance = new DocspaceService();
        }
        return instance;
    }

    public List<DocspaceBO> generateDocspaces(ExportBO wiseExport) {
        Integer numberOfArticles = null;
        numberOfArticles = wiseExport.getNbNotes().compareTo(wiseExport.getNbPolls()) > 0 ? wiseExport.getNbNotes() : wiseExport.getNbPolls();
        ArrayList<ArticleBO> articles = new ArrayList();
        if (numberOfArticles.compareTo(0) > 0) {
            articles = DatabaseService.getInstance().selectArticles(wiseExport, numberOfArticles);
        }
        TagService tagService = new TagService();
        wiseExport.setTags(tagService.createTagsBO(wiseExport.getNumberOfTags()));
        PollService pollService = PollService.getInstance();
        List<PollBO> polls = pollService.generatePolls(wiseExport.getNbPolls(), articles);
        NoteService noteService = NoteService.getInstance();
        List<NoteBO> notes = noteService.generateNotes(wiseExport.getNbNotes(), wiseExport.getNumberOfUsers(), articles);
        TaskService taskService = TaskService.getInstance();
        List<TaskBO> tasks = taskService.generateTasks(wiseExport.getNbTasks(), wiseExport.getNumberOfUsers());
        FileAndFolderService fileAndFolderService = FileAndFolderService.getInstance();
        ArrayList<DocspaceBO> docspaces = new ArrayList<DocspaceBO>();
        for (int i = 1; i <= wiseExport.getNbDocspaces(); ++i) {
            String docspaceName = "Docspace" + i;
            this.logger.info((CharSequence)("Generating docspace " + i + "/" + wiseExport.getNbDocspaces()));
            fileAndFolderService.generateFolders(docspaceName, wiseExport);
            docspaces.add(new DocspaceBO(docspaceName, polls, notes, tasks, this.getFoldersBO(), wiseExport.getNumberOfUsers(), wiseExport.getNumberOfOwners(), wiseExport.getNumberOfCollaborators(), wiseExport.getNumberOfEditors()));
        }
        return docspaces;
    }

    public List<FolderBO> getFoldersBO() {
        ArrayList<FolderBO> folders = new ArrayList<FolderBO>();
        FolderBO folderBO = null;
        String sep = System.getProperty("file.separator");
        File tmpDir = new File(ExportBO.tmp + sep + "top_folders");
        for (File f : tmpDir.listFiles()) {
            try {
                FileInputStream fichier = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(fichier);
                folderBO = (FolderBO)ois.readObject();
                folders.add(folderBO);
                ois.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(folders);
        return folders;
    }
}

