/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.resources;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.Native2Ascii;

public class Native2AsciiMojo
extends AbstractMojo {
    protected File src;
    protected File dest;
    protected String ext;
    protected String encoding;
    protected String includes;
    protected String excludes;
    protected boolean addToProjectResources;
    protected MavenProject project;
    protected String defaultPropertiesFileLocale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean inplace;
        if (this.src == null || !this.src.exists()) {
            this.getLog().info((CharSequence)("Folder " + this.src + " does not exist. Skipping native2ascii task."));
            return;
        }
        boolean bl = inplace = this.src != null && this.dest != null && this.src.equals(this.dest);
        if (inplace) {
            this.dest = new File(FileUtils.getTempDirectory(), "native2ascii-" + System.currentTimeMillis());
            this.dest.mkdir();
            try {
                FileUtils.deleteDirectory((File)this.dest);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        new File(this.project.getBuild().getDirectory() + "/native2ascii").mkdirs();
        Project antProject = new Project();
        antProject.setName("native2ascii");
        Native2Ascii antTask = new Native2Ascii();
        antTask.setProject(antProject);
        antTask.setSrc(this.src);
        antTask.setDest(this.dest);
        antTask.setEncoding(this.encoding);
        antTask.setExt(this.ext);
        antTask.setExcludes(this.excludes);
        antTask.setIncludes(this.includes);
        antTask.execute();
        if (inplace) {
            try {
                FileUtils.copyDirectory((File)this.dest, (File)this.src);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
            finally {
                this.dest = this.src;
            }
        }
        if (this.defaultPropertiesFileLocale != null) {
            this.createFilesForDefaultLocale();
        }
        if (this.addToProjectResources) {
            Resource resource = new Resource();
            resource.setDirectory(this.dest.getPath());
            this.project.addResource(resource);
        }
    }

    private void createFilesForDefaultLocale() {
        LinkedList propertyFiles = new LinkedList(FileUtils.listFiles((File)this.dest, (String[])new String[]{"properties"}, (boolean)false));
        if (propertyFiles.isEmpty()) {
            return;
        }
        Collections.sort(propertyFiles);
        String suffix = "_" + this.defaultPropertiesFileLocale + ".properties";
        for (File file : propertyFiles) {
            File defFile;
            if (!file.getName().endsWith(suffix) || (defFile = new File(this.dest, StringUtils.substringBefore((String)file.getName(), (String)suffix) + ".properties")).exists()) continue;
            this.getLog().info((CharSequence)("Copying file " + file + " to " + defFile));
            try {
                FileUtils.copyFile((File)file, (File)defFile);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }
}

