/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.jarscan;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class JarsToSkipListMojo
extends AbstractMojo {
    protected File dest;
    protected MavenProject project;
    protected File src;
    protected String defaultJarsToSkip;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasTLDFiles(File file) throws IOException {
        String name = file.getName();
        if (!file.isFile() || !name.endsWith(".jar")) {
            return false;
        }
        boolean tldPresent = false;
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().getName();
                if (entry == null || !entry.startsWith("META-INF/") || !entry.endsWith(".tld")) continue;
                tldPresent = true;
                break;
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {}
            }
        }
        return tldPresent;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.src == null || !this.src.exists()) {
            this.getLog().info((CharSequence)("Folder " + this.src + " does not exist. Skipping task."));
            return;
        }
        long start = System.currentTimeMillis();
        TreeSet<String> toSkip = new TreeSet<String>();
        if (StringUtils.isNotEmpty((String)this.defaultJarsToSkip)) {
            List skipByDefault = Arrays.asList((Object[])StringUtils.split((String)this.defaultJarsToSkip, (String)", "));
            toSkip.addAll(skipByDefault);
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getType().equals("jar") || !"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
            File file = artifact.getFile();
            try {
                boolean hasTLDFiles = JarsToSkipListMojo.hasTLDFiles(file);
                if (this.getLog().isDebugEnabled()) {
                    if (hasTLDFiles) {
                        this.getLog().debug((CharSequence)("Scanned dependency " + file + ". TLD files found."));
                    } else {
                        this.getLog().debug((CharSequence)("Scanned dependency " + file + ". No  TLD files found. Will be added to the skip list."));
                    }
                }
                if (hasTLDFiles) continue;
                toSkip.add(file.getName());
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
        try {
            FileUtils.writeLines((File)this.dest, toSkip, (String)"\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write results to the destination file " + this.dest, (Exception)e);
        }
        this.getLog().info((CharSequence)("Took " + (System.currentTimeMillis() - start) + " ms for scanning TLDs in JARs. Found " + toSkip.size() + " JARs without TLDs. The list is written into " + this.dest));
    }
}

