/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jahia.utils.osgi.BundleUtils;

public class OsgiInspectorMojo
extends AbstractMojo {
    protected List<String> jarBundles = new ArrayList<String>();
    protected MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.jarBundles == null || this.jarBundles.size() == 0) {
            this.jarBundles = new ArrayList<String>();
            String extension = this.project.getPackaging();
            if ("bundle".equals(extension)) {
                extension = "jar";
            }
            this.jarBundles.add(this.project.getBuild().getDirectory() + "/" + this.project.getBuild().getFinalName() + "." + extension);
        }
        for (String jarBundle : this.jarBundles) {
            JarInputStream jarInputStream = null;
            File jarFile = new File(jarBundle);
            if (!jarFile.exists()) {
                this.getLog().error((CharSequence)(jarFile + " does not exist, skipping !"));
                continue;
            }
            try {
                jarInputStream = new JarInputStream(new FileInputStream(jarBundle));
                StringWriter stringWriter = new StringWriter();
                PrintWriter stringPrintWriter = new PrintWriter(stringWriter);
                BundleUtils.dumpManifestHeaders((JarInputStream)jarInputStream, (PrintWriter)stringPrintWriter);
                this.getLog().info((CharSequence)(jarBundle + " header dump:\n" + stringWriter.getBuffer().toString()));
                IOUtils.closeQuietly((InputStream)jarInputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(jarInputStream);
            }
        }
    }
}

