package org.jahia.utils.maven.plugin.osgi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on jahia-maven-plugin.<br/> Call <pre>  mvn jahia:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Tue Jan 19 10:06:00 CET 2021
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.9)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.jahia.server:jahia-maven-plugin:5.10", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Jahia Installer Plugin", 0 );
        append( sb, "Jahia Maven plugin", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 27 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "build-framework-package-list".equals( goal ) )
        {
            append( sb, "jahia:build-framework-package-list", 0 );
            append( sb, "This maven goal will build the list of system packages that is exposed by the OSGi framework by default. In order to this it can use as input: - An existing property file that already includes a package list in OSGi format. - A previously generated MANIFEST.MF by the Maven Bundle Plugin - The contents of WEB-INF/classes - The contents of WEB-INF/lib - Dependencies of the project marked with \'provided\' scope.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactExcludes", 2 );
                append( sb, "Because of bug http://jira.codehaus.org/browse/MNG-5440 we cannot use a default-value otherwise the values from the POM will not be used, so we use a constant (below) and initialization code to set it if the project has not set it.", 3 );
                append( sb, "", 0 );

                append( sb, "exportEachPackageOnce (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "extraPackageExcludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "inputManifestFile (Default: ${project.build.directory}/classes/META-INF/MANIFEST.MF)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jarDirectories (Default: ${project.build.directory}/${project.build.finalName}/WEB-INF/lib)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "manualPackageList", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputPackagesWithNoVersions (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "packageExcludes", 2 );
                append( sb, "Because of bug http://jira.codehaus.org/browse/MNG-5440 we cannot use a default-value otherwise the values from the POM will not be used, so we use a constant (below) and initialization code to set it if the project has not set it.", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesInputFile (Default: ${project.basedir}/src/main/webapp/WEB-INF/etc/config/felix-framework.properties)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesOutputFile (Default: ${project.build.directory}/generated-resources/felix-framework.properties)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertyFileBootDelegationPropertyName (Default: org.osgi.framework.bootdelegation)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertyFilePropertyName (Default: org.osgi.framework.system.packages.extra)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertyFileSystemPackagesPropertyName (Default: org.osgi.framework.system.packages)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "scanDependencies (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "check-dependencies".equals( goal ) )
        {
            append( sb, "jahia:check-dependencies", 0 );
            append( sb, "A goal that checks the dependencies of a generated OSGi bundle JAR against the project dependencies, and reports any missing packages that weren\'t found in any dependency export.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactExcludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "buildDirectory", 2 );
                append( sb, "The directory for the generated JAR.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Classifier type of the bundle to be installed. For example, \'jdk14\'. Defaults to none which means this is the project\'s main bundle.", 3 );
                append( sb, "", 0 );

                append( sb, "contentDefinitionCapabilitiesActivated (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "dependencyParsingCacheDirectory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${user.home}/.m2/dependency-cache", 3 );
                append( sb, "", 0 );

                append( sb, "excludedJarEntries", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "excludeFromDirectoryScan", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "existingImports", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.modules.importPackage}", 3 );
                append( sb, "", 0 );

                append( sb, "failBuildOnMissingPackageExports (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "failBuildOnSplitPackages (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaDependsCapabilitiesActivated (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaDependsCapabilitiesPrefix (Default: ,)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The directory for the generated bundles.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "projectBuildDirectory", 2 );
                append( sb, "The directory for the generated JAR.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "projectOutputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesInputFile", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesOutputFile", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "scanDirectories", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "searchInDependencies (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "systemExtraCapabilitiesPropertyName (Default: org.osgi.framework.system.capabilities.extra)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "configure".equals( goal ) )
        {
            append( sb, "jahia:configure", 0 );
            append( sb, "Configure the deployed Jahia instance Basically set everything that can be found in the jahia.properties and jahia.advance.properties files.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "baseDir (Default: ${basedir})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "cluster_activated (Default: false)", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "Expression: ${jahia.configure.cluster_activated}", 3 );
                append( sb, "", 0 );

                append( sb, "cluster_node_serverId", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "Expression: ${jahia.configure.cluster_node_serverId}", 3 );
                append( sb, "", 0 );

                append( sb, "clusterHazelcastBindPort", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "Expression: ${jahia.configure.clusterHazelcastBindPort}", 3 );
                append( sb, "", 0 );

                append( sb, "clusterTCPBindAddress", 2 );
                append( sb, "The TCP bind address to start server socket on", 3 );
                append( sb, "Expression: ${jahia.configure.clusterTCPBindAddress}", 3 );
                append( sb, "", 0 );

                append( sb, "clusterTCPBindPort", 2 );
                append( sb, "The TCP port to bind to", 3 );
                append( sb, "Expression: ${jahia.configure.clusterTCPBindPort}", 3 );
                append( sb, "", 0 );

                append( sb, "databasePassword", 2 );
                append( sb, "List of nodes in the cluster.", 3 );
                append( sb, "Expression: ${jahia.configure.databasePassword}", 3 );
                append( sb, "", 0 );

                append( sb, "databaseType (Default: derby_embedded)", 2 );
                append( sb, "Database type used", 3 );
                append( sb, "Expression: ${jahia.configure.databaseType}", 3 );
                append( sb, "", 0 );

                append( sb, "databaseUrl (Default: jdbc:derby:directory:jahia)", 2 );
                append( sb, "URL to connect to the database", 3 );
                append( sb, "Expression: ${jahia.configure.databaseUrl}", 3 );
                append( sb, "", 0 );

                append( sb, "databaseUsername", 2 );
                append( sb, "List of nodes in the cluster.", 3 );
                append( sb, "Expression: ${jahia.configure.databaseUsername}", 3 );
                append( sb, "", 0 );

                append( sb, "externalizedConfigActivated (Default: true)", 2 );
                append( sb, "Activates configuration externalization. Make sure to specify a value for the externalizedConfigTargetPath that will indicate where the configuration JAR should be generated.", 3 );
                append( sb, "Expression: ${jahia.configure.externalizedActivated}", 3 );
                append( sb, "", 0 );

                append( sb, "externalizedConfigClassifier", 2 );
                append( sb, "Allows to specify a classifier on the configuration, usually used to identify cluster node configurations, such as jahiaNode1, jahiaNode2, etc...", 3 );
                append( sb, "Expression: ${jahia.configure.externalizedClassifier}", 3 );
                append( sb, "", 0 );

                append( sb, "externalizedConfigExploded (Default: true)", 2 );
                append( sb, "If active, the externalized configuration is deployed exploded.", 3 );
                append( sb, "Expression: ${jahia.configure.externalizedExploded}", 3 );
                append( sb, "", 0 );

                append( sb, "externalizedConfigFinalName (Default: jahia-config)", 2 );
                append( sb, "The name of the JAR file (without the extension)", 3 );
                append( sb, "Expression: ${jahia.configure.externalizedFinalName}", 3 );
                append( sb, "", 0 );

                append( sb, "externalizedConfigTargetPath", 2 );
                append( sb, "The location at which the externalized configuration JAR will be generated.", 3 );
                append( sb, "Expression: ${jahia.configure.externalizedTargetPath}", 3 );
                append( sb, "", 0 );

                append( sb, "fileDataStorePath", 2 );
                append( sb, "A filesystem path to the folder, where Jackrabbit FileDataStore puts the binary content.", 3 );
                append( sb, "Expression: ${jahia.configure.fileDataStorePath}", 3 );
                append( sb, "", 0 );

                append( sb, "groupLdapProviderProperties", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.groupLdapProviderProperties}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaAdvancedProperties", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaAdvancedProperties}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaImportsDiskPath (Default: ${jahia.data.dir}/imports/)", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaModulesDiskPath (Default: ${jahia.data.dir}/modules/)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaProperties", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaProperties}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootEmail", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootEmail}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootFirstname", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootFirstname}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootLastname", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootLastname}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootPassword (Default: root1234)", 2 );
                append( sb, "properties jahiaRootPassword", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootPassword}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootPreferredLang (Default: en)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootPreferredLang}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRootUsername (Default: root)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.jahiaRootUsername}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaToolManagerPassword (Default: password)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.toolManagerPassword}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaToolManagerUsername (Default: jahia)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.toolManagerUsername}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaVarDiskPath", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.deploy.dataDir}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaWebAppsDeployerBaseURL (Default: http://127.0.0.1:8080/manager/html/)", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "", 0 );

                append( sb, "jeeApplicationLocation", 2 );
                append( sb, "The location of a JEE application to be configured for deployment in EAR format. If this is null or empty this means we are not using EAR deployment for Jahia but WAR deployment.", 3 );
                append( sb, "Expression: ${jahia.configure.jeeApplicationLocation}", 3 );
                append( sb, "", 0 );

                append( sb, "jeeApplicationModuleList", 2 );
                append( sb, "", 3 );
                append( sb, "Expression: ${jahia.configure.jeeApplicationModuleList}", 3 );
                append( sb, "", 0 );

                append( sb, "ldapActivated (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.ldapActivated}", 3 );
                append( sb, "", 0 );

                append( sb, "licenseFile", 2 );
                append( sb, "Path to an existing license file to be used by Jahia instead of a default trial one.", 3 );
                append( sb, "Expression: ${jahia.configure.licenseFile}", 3 );
                append( sb, "", 0 );

                append( sb, "mailAdministrator", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.mailAdministrator}", 3 );
                append( sb, "", 0 );

                append( sb, "mailFrom", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.mailFrom}", 3 );
                append( sb, "", 0 );

                append( sb, "mailParanoia (Default: Disabled)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.mailParanoia}", 3 );
                append( sb, "", 0 );

                append( sb, "mailServer", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.mailServer}", 3 );
                append( sb, "", 0 );

                append( sb, "operatingMode (Default: development)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.operatingMode}", 3 );
                append( sb, "", 0 );

                append( sb, "output (Default: ${project.build.directory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "overwritedb (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.overwritedb}", 3 );
                append( sb, "", 0 );

                append( sb, "processingServer (Default: true)", 2 );
                append( sb, "properties file path", 3 );
                append( sb, "Expression: ${jahia.configure.processingServer}", 3 );
                append( sb, "", 0 );

                append( sb, "siteImportLocation", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "storeFilesInDB (Default: false)", 2 );
                append( sb, "properties storeFilesInDB", 3 );
                append( sb, "Expression: ${jahia.configure.storeFilesInDB}", 3 );
                append( sb, "", 0 );

                append( sb, "targetConfigurationDirectory", 2 );
                append( sb, "The directory that will be used to store the configured Jahia in if the target server directory has to be overridden.", 3 );
                append( sb, "Expression: ${jahia.deploy.targetConfigurationDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerDirectory", 2 );
                append( sb, "The main directory for the target server install in which we will deploy the app-specific configuration.", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerType (Default: tomcat)", 2 );
                append( sb, "Server type", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerType}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerVersion", 2 );
                append( sb, "Server version", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "userLdapProviderProperties", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.configure.userLdapProviderProperties}", 3 );
                append( sb, "", 0 );

                append( sb, "webAppDirName (Default: ROOT)", 2 );
                append( sb, "The Web application directory name (under /webapps) where the Jahia will be deployed.", 3 );
                append( sb, "Expression: ${jahia.deploy.war.dirName}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "convert-to-osgi".equals( goal ) )
        {
            append( sb, "jahia:convert-to-osgi", 0 );
            append( sb, "Jahia utility goal to help with the migration of Jahia modules to OSGi packaging.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "baseDir (Default: ${basedir})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaVarDiskPath", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.deploy.dataDir}", 3 );
                append( sb, "", 0 );

                append( sb, "output (Default: ${project.build.directory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "performMigration", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.osgi.conversion.performMigration}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerDirectory", 2 );
                append( sb, "The main directory for the target server install in which we will deploy the app-specific configuration.", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerType (Default: tomcat)", 2 );
                append( sb, "Server type", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerType}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerVersion", 2 );
                append( sb, "Server version", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "webAppDirName (Default: ROOT)", 2 );
                append( sb, "The Web application directory name (under /webapps) where the Jahia will be deployed.", 3 );
                append( sb, "Expression: ${jahia.deploy.war.dirName}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copy-jahiawar".equals( goal ) )
        {
            append( sb, "jahia:copy-jahiawar", 0 );
            append( sb, "Copy Jahia war", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "output (Default: ${project.build.directory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copy-templates".equals( goal ) )
        {
            append( sb, "jahia:copy-templates", 0 );
            append( sb, "Mojo for copying Jahia modules and pre-packaged sites into Jahia WAR file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "baseDir (Default: ${basedir})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "deployModules (Default: true)", 2 );
                append( sb, "Modules deployment If false, all modules within the package \'org.jahia.modules\' will be ignored Modules within the package \'org.jahia.prepackagedsites\' are copied to the prepackagedsites\' folder of Jahia", 3 );
                append( sb, "", 0 );

                append( sb, "deployTests (Default: false)", 2 );
                append( sb, "Tests modules deployment If false, all modules within the package \'org.jahia.test\' will be ignored", 3 );
                append( sb, "", 0 );

                append( sb, "deployToServer (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaVarDiskPath", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.deploy.dataDir}", 3 );
                append( sb, "", 0 );

                append( sb, "output (Default: ${project.build.directory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerDirectory", 2 );
                append( sb, "The main directory for the target server install in which we will deploy the app-specific configuration.", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerType (Default: tomcat)", 2 );
                append( sb, "Server type", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerType}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerVersion", 2 );
                append( sb, "Server version", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "webAppDirName (Default: ROOT)", 2 );
                append( sb, "The Web application directory name (under /webapps) where the Jahia will be deployed.", 3 );
                append( sb, "Expression: ${jahia.deploy.war.dirName}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "cs-deploy".equals( goal ) )
        {
            append( sb, "jahia:cs-deploy", 0 );
            append( sb, "Context server deployment mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "targetServerDirectory", 2 );
                append( sb, "The root directory for context server.", 3 );
                append( sb, "Expression: ${contextserver.targetServerDirectory}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "dependencies".equals( goal ) )
        {
            append( sb, "jahia:dependencies", 0 );
            append( sb, "A maven goal to scan the project for package dependencies, useful for building OSGi Import-Package Manifest header. This goal is currently capable of scanning: - TLD files in dependencies and the project - JSP for page import and Taglib references (tag files are not supported yet) - Drools rule definition imports - JBPM Workflow definition files - Spring context files - JCR CND content definition files for node type definition and references - Groovy files", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactExcludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "contentDefinitionCapabilitiesActivated (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "dependencyParsingCacheDirectory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${user.home}/.m2/dependency-cache", 3 );
                append( sb, "", 0 );

                append( sb, "excludedJarEntries", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "excludeFromDirectoryScan", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "existingImports", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.modules.importPackage}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaDependsCapabilitiesActivated (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaDependsCapabilitiesPrefix (Default: ,)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "projectBuildDirectory", 2 );
                append( sb, "The directory for the generated JAR.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.directory}", 3 );
                append( sb, "", 0 );

                append( sb, "projectOutputDirectory (Default: ${project.build.outputDirectory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesInputFile", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesOutputFile", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "scanDirectories", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "systemExtraCapabilitiesPropertyName (Default: org.osgi.framework.system.capabilities.extra)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "deploy".equals( goal ) )
        {
            append( sb, "jahia:deploy", 0 );
            append( sb, "Jahia server deployment mojo.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "address (Default: socket:hostname=localhost,port=8000)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.debug.address}", 3 );
                append( sb, "", 0 );

                append( sb, "baseDir (Default: ${basedir})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "deployTests (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.deploy.deployTests}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaVarDiskPath", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.deploy.dataDir}", 3 );
                append( sb, "", 0 );

                append( sb, "output (Default: ${project.build.directory})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerDirectory", 2 );
                append( sb, "The main directory for the target server install in which we will deploy the app-specific configuration.", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerType (Default: tomcat)", 2 );
                append( sb, "Server type", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerType}", 3 );
                append( sb, "", 0 );

                append( sb, "targetServerVersion", 2 );
                append( sb, "Server version", 3 );
                append( sb, "Expression: ${jahia.deploy.targetServerVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "webAppDirName (Default: ROOT)", 2 );
                append( sb, "The Web application directory name (under /webapps) where the Jahia will be deployed.", 3 );
                append( sb, "Expression: ${jahia.deploy.war.dirName}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "find-package-uses".equals( goal ) )
        {
            append( sb, "jahia:find-package-uses", 0 );
            append( sb, "A little utility goal to locate a package usage inside the project\'s dependencies, using BND to make sure we scan the same way.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputDirectory", 2 );
                append( sb, "The directory for the generated bundles.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project.build.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "packageNames (Default: ${packageNames})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "searchInDependencies (Default: true)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "find-packages".equals( goal ) )
        {
            append( sb, "jahia:find-packages", 0 );
            append( sb, "A little utility goal to locate a package inside the project\'s dependencies, including optional or provided ones.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "packageNames (Default: ${packageNames})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-files".equals( goal ) )
        {
            append( sb, "jahia:generate-files", 0 );
            append( sb, "Generates files that can be used as attachments", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "mysql_db", 2 );
                append( sb, "MySQL database name", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_db}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_host (Default: localhost)", 2 );
                append( sb, "MySQL server hosting the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.host}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_login", 2 );
                append( sb, "MySQL user to connect to the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.login}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_password", 2 );
                append( sb, "MySQL password for the user", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.password}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_port", 2 );
                append( sb, "Port on which to connect to the MySQL database", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.port}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_table (Default: articles)", 2 );
                append( sb, "MySQL table", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_table}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfFilesToGenerate", 2 );
                append( sb, "Number of files to generate (text files filled with a random Wikipedia article) Required for goal \'generate-files\'", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfFilesToGenerate}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: output)", 2 );
                append( sb, "Local directory where generated files will be written", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileName (Default: jahia-cg-output.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.outputFileName}", 3 );
                append( sb, "", 0 );

                append( sb, "poolDirectory (Default: files_pool)", 2 );
                append( sb, "Local directory that contains files to be included in Jahia pages or Wise instances", 3 );
                append( sb, "Expression: ${jahia.cg.poolDirectory}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-site".equals( goal ) )
        {
            append( sb, "jahia:generate-site", 0 );
            append( sb, "Generate a Jahia site (ZIP file) ready to be imported", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addFiles (Default: none)", 2 );
                append( sb, "Choose if you want to add file containers to your pages Possible values: all, random, none.", 3 );
                append( sb, "Expression: ${jahia.cg.addFiles}", 3 );
                append( sb, "", 0 );

                append( sb, "buildNumber (Default: 53717)", 2 );
                append( sb, "Jahia/Dx target build number of the export (used in export.properties)", 3 );
                append( sb, "Expression: ${jahia.cg.buildNumber}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisNbAvailableFiles", 2 );
                append( sb, "Number of files available on the server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.nb.available.files}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisPassword", 2 );
                append( sb, "Connection password to the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.password}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisRepositoryId", 2 );
                append( sb, "CMIS Repository ID on the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.repository.id}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisRepositoryType", 2 );
                append( sb, "CMIS Repository ID on the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.type}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisSiteName", 2 );
                append( sb, "Site name on the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.siteName}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisUrl", 2 );
                append( sb, "Connection URL to the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.url}", 3 );
                append( sb, "", 0 );

                append( sb, "cmisUser", 2 );
                append( sb, "Connection user to the CMIS server", 3 );
                append( sb, "Expression: ${jahia.cg.cmis.user}", 3 );
                append( sb, "", 0 );

                append( sb, "disableExternalFileReference (Default: false)", 2 );
                append( sb, "Disable reference to internal files on pages", 3 );
                append( sb, "Expression: ${jahia.cg.disable.external.filereference}", 3 );
                append( sb, "", 0 );

                append( sb, "disableInternalFileReference (Default: false)", 2 );
                append( sb, "Disable reference to internal files on pages", 3 );
                append( sb, "Expression: ${jahia.cg.disable.internal.filereference}", 3 );
                append( sb, "", 0 );

                append( sb, "groupAclRatio (Default: 0)", 2 );
                append( sb, "For each created page a random float will be compared to this value and if inferior an ACL node with a random group will be added.", 3 );
                append( sb, "Expression: ${jahia.cg.groupsAclRatio}", 3 );
                append( sb, "", 0 );

                append( sb, "jahiaRelease (Default: 7.1)", 2 );
                append( sb, "Jahia/Dx target version of the export (used in export.properties)", 3 );
                append( sb, "Expression: ${jahia.cg.jahiaRelease}", 3 );
                append( sb, "", 0 );

                append( sb, "maxPersonalizationVariants (Default: 3)", 2 );
                append( sb, "Maximum number of personalization variants, in case we personalize a piece of content.", 3 );
                append( sb, "Expression: ${jahia.cg.maxPersonalizationVariants}", 3 );
                append( sb, "", 0 );

                append( sb, "minPersonalizationVariants (Default: 2)", 2 );
                append( sb, "Minimum number of personalization variants, in case we personalize a piece of content.", 3 );
                append( sb, "Expression: ${jahia.cg.minPersonalizationVariants}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_db", 2 );
                append( sb, "MySQL database name", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_db}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_host (Default: localhost)", 2 );
                append( sb, "MySQL server hosting the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.host}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_login", 2 );
                append( sb, "MySQL user to connect to the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.login}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_password", 2 );
                append( sb, "MySQL password for the user", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.password}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_port", 2 );
                append( sb, "Port on which to connect to the MySQL database", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.port}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_table (Default: articles)", 2 );
                append( sb, "MySQL table", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_table}", 3 );
                append( sb, "", 0 );

                append( sb, "nbPagesOnTopLevel (Default: 1)", 2 );
                append( sb, "Number of pages on the top level (root pages)", 3 );
                append( sb, "Expression: ${jahia.cg.nbPagesOnTopLevel}", 3 );
                append( sb, "", 0 );

                append( sb, "nbPagesPerLevel (Default: 3)", 2 );
                append( sb, "Number of sub-pages per page", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.nbPagesPerLevel}", 3 );
                append( sb, "", 0 );

                append( sb, "nbSubLevels (Default: 2)", 2 );
                append( sb, "Pages depth", 3 );
                append( sb, "Expression: ${jahia.cg.nbSubLevels}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfBigTextPerPage (Default: 1)", 2 );
                append( sb, "Number of big text container per page", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfBigTextPerPage}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfCategories (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfCategories}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfCategoryLevels (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfCategoryLevels}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfGroups (Default: 5)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfGroups}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfSites (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfSites}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfTags (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfTags}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfUsers (Default: 25)", 2 );
                append( sb, "Number of users to generate", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfUsers}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfUsersPerGroup (Default: 5)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfUsersPerGroup}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: output)", 2 );
                append( sb, "Local directory where generated files will be written", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileName (Default: jahia-cg-output.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.outputFileName}", 3 );
                append( sb, "", 0 );

                append( sb, "pagesHaveVanity (Default: true)", 2 );
                append( sb, "Choose if you want to add a vanity URL to your page (example: \'page123\')", 3 );
                append( sb, "Expression: ${jahia.cg.pagesHaveVanity}", 3 );
                append( sb, "", 0 );

                append( sb, "pcPersonalizedPages (Default: 0)", 2 );
                append( sb, "How many pages should contain a single piece of personalized content, per cent.", 3 );
                append( sb, "Expression: ${jahia.cg.pcPersonalizedPages}", 3 );
                append( sb, "", 0 );

                append( sb, "percentagePagesWithTplList (Default: 0)", 2 );
                append( sb, "Percentage of pages using the Jahia QA page template \'qa-list\' (tpl-web-blue, branch qa)", 3 );
                append( sb, "Expression: ${jahia.cg.percentagePagesWithTplList}", 3 );
                append( sb, "", 0 );

                append( sb, "percentagePagesWithTplQuery (Default: 0)", 2 );
                append( sb, "Percentage of pages using the Jahia QA page template \'qa-query\' (tpl-web-blue, branch qa)", 3 );
                append( sb, "Expression: ${jahia.cg.percentagePagesWithTplQuery}", 3 );
                append( sb, "", 0 );

                append( sb, "poolDirectory (Default: files_pool)", 2 );
                append( sb, "Local directory that contains files to be included in Jahia pages or Wise instances", 3 );
                append( sb, "Expression: ${jahia.cg.poolDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "siteKey (Default: testSite)", 2 );
                append( sb, "Site key of your site. A trailing number will be added if you generate more than one site.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.siteKey}", 3 );
                append( sb, "", 0 );

                append( sb, "siteLanguages (Default: en,fr)", 2 );
                append( sb, "Site language(s), a comma-separated list", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.siteLanguages}", 3 );
                append( sb, "", 0 );

                append( sb, "siteType (Default: Regular)", 2 );
                append( sb, "Site type (Regular or Headless)", 3 );
                append( sb, "Expression: ${jahia.cg.siteType}", 3 );
                append( sb, "", 0 );

                append( sb, "usersAclRatio (Default: 0)", 2 );
                append( sb, "For each created page a random float will be compared to this value and if inferior an ACL node with a random user will be added.", 3 );
                append( sb, "Expression: ${jahia.cg.usersAclRatio}", 3 );
                append( sb, "", 0 );

                append( sb, "visibilityEnabled (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.visibilityEnabled}", 3 );
                append( sb, "", 0 );

                append( sb, "visibilityEndDate", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.visibilityEndDate}", 3 );
                append( sb, "", 0 );

                append( sb, "visibilityStartDate", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.visibilityStartDate}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "generate-wise".equals( goal ) )
        {
            append( sb, "jahia:generate-wise", 0 );
            append( sb, "Generates a Wise instance ready to be imported into a Wise installation Also generates a map containing all the included files", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "endCreationDateRange (Default: 2012-10-01)", 2 );
                append( sb, "End date for the range used to create a random creation date assigned to files in the JCR. It actually doesn\'t work as during the import the date is replaced with the current date.", 3 );
                append( sb, "Expression: ${jahia.cg.endCreationDateRange}", 3 );
                append( sb, "", 0 );

                append( sb, "foldersDepth (Default: 2)", 2 );
                append( sb, "Folder depth", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.wise.foldersDepth}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_db", 2 );
                append( sb, "MySQL database name", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_db}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_host (Default: localhost)", 2 );
                append( sb, "MySQL server hosting the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.host}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_login", 2 );
                append( sb, "MySQL user to connect to the Wikipedia articles database", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.login}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_password", 2 );
                append( sb, "MySQL password for the user", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.password}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_port", 2 );
                append( sb, "Port on which to connect to the MySQL database", 3 );
                append( sb, "Expression: ${jahia.cg.mysql.port}", 3 );
                append( sb, "", 0 );

                append( sb, "mysql_table (Default: articles)", 2 );
                append( sb, "MySQL table", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.mysql_table}", 3 );
                append( sb, "", 0 );

                append( sb, "nbCollectionsPerUser (Default: 3)", 2 );
                append( sb, "Number of collections per user", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbCollectionsPerUser}", 3 );
                append( sb, "", 0 );

                append( sb, "nbDocspaces (Default: 1)", 2 );
                append( sb, "Number of docspace to create N.B: it currently works only for one", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbDocspaces}", 3 );
                append( sb, "", 0 );

                append( sb, "nbFilesPerCollection (Default: 3)", 2 );
                append( sb, "Number of files per collection", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbFilesPerCollection}", 3 );
                append( sb, "", 0 );

                append( sb, "nbFilesPerFolder (Default: 3)", 2 );
                append( sb, "Number of files per folder Files are randomly picked from the files pool You need to have enough files in the fool as they can\'t be used twice", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbFilesPerFolder}", 3 );
                append( sb, "", 0 );

                append( sb, "nbFoldersPerLevel (Default: 3)", 2 );
                append( sb, "Number subfolder per folder", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbFoldersPerLevel}", 3 );
                append( sb, "", 0 );

                append( sb, "nbNotes (Default: 10)", 2 );
                append( sb, "Number of notes to generate. Each note contains a random Wikipedia article", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbNotes}", 3 );
                append( sb, "", 0 );

                append( sb, "nbPolls (Default: 10)", 2 );
                append( sb, "Number of Polls", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbPolls}", 3 );
                append( sb, "", 0 );

                append( sb, "nbTasks (Default: 10)", 2 );
                append( sb, "Number of tasks to generate. Each task has a random user as creator and assignee", 3 );
                append( sb, "Expression: ${jahia.cg.wise.nbTasks}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfCategories (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfCategories}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfCategoryLevels (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfCategoryLevels}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfCollaborators (Default: 15)", 2 );
                append( sb, "Number of users with the role \'docspace-collaborator\'. They come after the editors.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfCollaborators}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfEditors (Default: 10)", 2 );
                append( sb, "Number of users with the role \'docspace-editor\'. They come after the owners.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfEditors}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfOwners (Default: 5)", 2 );
                append( sb, "Number of users with the role \'docspace-owner\'. They come first (user 0 to userN)", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfOwners}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfTags (Default: 1)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfTags}", 3 );
                append( sb, "", 0 );

                append( sb, "numberOfUsers (Default: 25)", 2 );
                append( sb, "Number of users to generate", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.numberOfUsers}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: output)", 2 );
                append( sb, "Local directory where generated files will be written", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileName (Default: jahia-cg-output.xml)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${jahia.cg.outputFileName}", 3 );
                append( sb, "", 0 );

                append( sb, "poolDirectory (Default: files_pool)", 2 );
                append( sb, "Local directory that contains files to be included in Jahia pages or Wise instances", 3 );
                append( sb, "Expression: ${jahia.cg.poolDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "siteKey (Default: testSite)", 2 );
                append( sb, "Site key of your site. A trailing number will be added if you generate more than one site.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${jahia.cg.siteKey}", 3 );
                append( sb, "", 0 );

                append( sb, "startCreationDateRange (Default: 2010-01-01)", 2 );
                append( sb, "Start date for the range used to create a random creation date assigned to files in the JCR. It actually doesn\'t work as during the import the date is replaced with the current date.", 3 );
                append( sb, "Expression: ${jahia.cg.startCreationDateRange}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "gitbuildnumber".equals( goal ) )
        {
            append( sb, "jahia:gitbuildnumber", 0 );
            append( sb, "Creates a build number from number of git revisions", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "allBranches (Default: false)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${maven.buildNumber.allBranches}", 3 );
                append( sb, "", 0 );

                append( sb, "baseBuildNumber (Default: 0)", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${maven.buildNumber.baseBuildNumber}", 3 );
                append( sb, "", 0 );

                append( sb, "baseGitRevision", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${maven.buildNumber.baseGitRevision}", 3 );
                append( sb, "", 0 );

                append( sb, "buildNumberPropertyName (Default: buildNumber)", 2 );
                append( sb, "You can rename the buildNumber property name to another property name if desired.", 3 );
                append( sb, "Expression: ${maven.buildNumber.buildNumberPropertyName}", 3 );
                append( sb, "", 0 );

                append( sb, "getRevisionOnlyOnce (Default: false)", 2 );
                append( sb, "If set to true, will get the scm revision once for all modules of a multi-module project instead of fetching once for each module.", 3 );
                append( sb, "Expression: ${maven.buildNumber.getRevisionOnlyOnce}", 3 );
                append( sb, "", 0 );

                append( sb, "scmDirectory (Default: ${basedir})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Expression: ${maven.buildNumber.scmDirectory}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "gwt-dictionary".equals( goal ) )
        {
            append( sb, "jahia:gwt-dictionary", 0 );
            append( sb, "Converts resource bundles into a JavaScript dictionary for use in GWT UI.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/${project.build.finalName}/gwt/resources/i18n)", 2 );
                append( sb, "The directory to output files into", 3 );
                append( sb, "", 0 );

                append( sb, "dictionaryName (Default: jahia_gwt_messages)", 2 );
                append( sb, "The name of the GWT dictionary to use in generated JavaScript output files", 3 );
                append( sb, "", 0 );

                append( sb, "languages (Default: de,en,es,fr,it,pt)", 2 );
                append( sb, "Comma- or space-separated list of language codes for resource bundle to process", 3 );
                append( sb, "", 0 );

                append( sb, "prettyPrint (Default: false)", 2 );
                append( sb, "Should the output files be pretty-printed (line-breaks, whitespace etc.)", 3 );
                append( sb, "", 0 );

                append( sb, "resourceBundle (Default: JahiaInternalResources)", 2 );
                append( sb, "The name of the resource bundle to be converted", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources)", 2 );
                append( sb, "The directory to find files in (default is basedir)", 3 );
                append( sb, "", 0 );

                append( sb, "targetFileName (Default: messages)", 2 );
                append( sb, "Output file names (without extension)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "jahia:help", 0 );
            append( sb, "Display help information on jahia-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0jahia:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "jahia-version".equals( goal ) )
        {
            append( sb, "jahia:jahia-version", 0 );
            append( sb, "Used to add Jahia version in module context", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "javascript-dictionary".equals( goal ) )
        {
            append( sb, "jahia:javascript-dictionary", 0 );
            append( sb, "Converts resource bundles into a JavaScript dictionary for use in UI.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addToProjectResources (Default: true)", 2 );
                append( sb, "Do we need to add the processed files into project\'s resources.", 3 );
                append( sb, "", 0 );

                append( sb, "dictionaryName (Default: i18n)", 2 );
                append( sb, "The name of the dictionary variable to use in generated JavaScript output files", 3 );
                append( sb, "", 0 );

                append( sb, "languages (Default: de,en,fr)", 2 );
                append( sb, "Comma- or space-separated list of language codes for resource bundle to process", 3 );
                append( sb, "", 0 );

                append( sb, "prettyPrint (Default: false)", 2 );
                append( sb, "Should the output files be pretty-printed (line-breaks, whitespace etc.)", 3 );
                append( sb, "", 0 );

                append( sb, "quoteKeys (Default: true)", 2 );
                append( sb, "Do we need to quote the keys.", 3 );
                append( sb, "", 0 );

                append( sb, "resourceBundle", 2 );
                append( sb, "The name of the resource bundle to be converted", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources/resources)", 2 );
                append( sb, "The directory to find files in (default is basedir)", 3 );
                append( sb, "", 0 );

                append( sb, "targetDirName (Default: javascript/i18n)", 2 );
                append( sb, "The sub-directory under destination directory to output files into", 3 );
                append( sb, "", 0 );

                append( sb, "targetFileName", 2 );
                append( sb, "Output file names (without extension)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list-jars-with-no-tlds".equals( goal ) )
        {
            append( sb, "jahia:list-jars-with-no-tlds", 0 );
            append( sb, "Creates a list of JARs that do not contain any TLD files and can be skipped by the JAR scanner (Jasper compiler in the Pax Web JSP project).", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "append (Default: false)", 2 );
                append( sb, "Should we merge entries with the entries in the existing dest file?.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultJarsToSkip (Default: jboss-modules.jar,ehcache-sizeof-agent*.jar,ccpp-1.0.jar,derby-*.jar,derbyclient-*.jar,mariadb-java-client-*.jar,mysql-connector-java-*.jar,ojdbc6-*.jar,ojdbc7-*.jar,ojdbc8-*.jar,orai18n-*.jar,pluto-container-api-2.0.2.jar,pluto-container-driver-api-2.0.2.jar,pluto-taglib-2.0.2.jar,portals-bridges-common-1.0.4.jar,portlet-api_2.0_spec-1.0.jar,postgresql-*.jar,sqljdbc4-*.jar,sqljdbc41-*.jar,mssql-jdbc-*.jar)", 2 );
                append( sb, "The list of JARs which are skipped by default.", 3 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/generated-resources/jar-scanner.conf)", 2 );
                append( sb, "The file to output the list of JARs into.", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${project.build.directory}/jahia)", 2 );
                append( sb, "The Jahia Web application directory to scan for JAR files in.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "native2ascii".equals( goal ) )
        {
            append( sb, "jahia:native2ascii", 0 );
            append( sb, "Converter for resource bundles.\nInspired by native2ascii-maven-plugin.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addToProjectResources (Default: true)", 2 );
                append( sb, "Do we need to add the processed files into project\'s resources.", 3 );
                append( sb, "", 0 );

                append( sb, "defaultPropertiesFileLocale", 2 );
                append( sb, "In case the default locale is provided, create properties file for the default locale if it does not exist.", 3 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/native2ascii)", 2 );
                append( sb, "The directory to output file to", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ISO-8859-1)", 2 );
                append( sb, "The native encoding the files are in (default is ISO-8859-1)", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be excluded. No files (except default excludes) are excluded when omitted.", 3 );
                append( sb, "", 0 );

                append( sb, "ext", 2 );
                append( sb, "File extension to use in renaming output files", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be included. All files are included when omitted", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources)", 2 );
                append( sb, "The directory to find files in (default is basedir)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "osgi-inspect".equals( goal ) )
        {
            append( sb, "jahia:osgi-inspect", 0 );
            append( sb, "A new goal to provide tools to inspect OSGi bundles, either generated by the project or specified as a parameter.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "jarBundles (Default: ${jarBundles})", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "package-imports".equals( goal ) )
        {
            append( sb, "jahia:package-imports", 0 );
            append( sb, "Used to automatically package module\'s import resources (as a ZIP file) into the target module bundle file.\n", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addToProjectResources (Default: true)", 2 );
                append( sb, "Do we need to add the generated import.zip file into project\'s resources.", 3 );
                append( sb, "", 0 );

                append( sb, "archiveName (Default: import.zip)", 2 );
                append( sb, "The resulting archive name", 3 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/packaged-imports/META-INF)", 2 );
                append( sb, "The directory to output file to", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be excluded. No files (except default excludes) are excluded when omitted.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be included. All files are included when omitted", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/import)", 2 );
                append( sb, "The directory to find files in (default is basedir)", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Should we execute the archiver in a verbose mode?", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "properties2json".equals( goal ) )
        {
            append( sb, "jahia:properties2json", 0 );
            append( sb, "Converter for resource bundles into JSON format for usage in React/Angular.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "addToProjectResources (Default: true)", 2 );
                append( sb, "Do we need to add the processed files into project\'s resources.", 3 );
                append( sb, "", 0 );

                append( sb, "dest (Default: ${project.build.directory}/properties2json)", 2 );
                append( sb, "The directory to output file to", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be excluded. No files (except default excludes) are excluded when omitted.", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "comma- or space-separated list of patterns of files that must be included. All files are included when omitted", 3 );
                append( sb, "Expression: javascript/locales/*.properties", 3 );
                append( sb, "", 0 );

                append( sb, "prettyPrinting (Default: false)", 2 );
                append( sb, "Should result JSON be prettified?", 3 );
                append( sb, "", 0 );

                append( sb, "src (Default: ${basedir}/src/main/resources)", 2 );
                append( sb, "The directory to find files in", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "taglibrarydoc".equals( goal ) )
        {
            append( sb, "jahia:taglibrarydoc", 0 );
            append( sb, "Generates the tag library documentation.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "description", 2 );
                append( sb, "The description of the report to be displayed in the Maven Generated Reports page.", 3 );
                append( sb, "Expression: ${taglibrarydoc.description}", 3 );
                append( sb, "", 0 );

                append( sb, "destDir (Default: tlddocs)", 2 );
                append( sb, "The name of the destination directory.", 3 );
                append( sb, "Expression: ${taglibrarydoc.destDir}", 3 );
                append( sb, "", 0 );

                append( sb, "docTitle (Default: ${project.name} v${project.version} Tag Reference)", 2 );
                append( sb, "The document title for the generated report.", 3 );
                append( sb, "Expression: ${taglibrarydoc.docTitle}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Which resource should we exclude?", 3 );
                append( sb, "Expression: ${taglibrarydoc.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: *.tld)", 2 );
                append( sb, "Which resource should we include? By default we only include TLD files without scanning subdirectories.", 3 );
                append( sb, "Expression: ${taglibrarydoc.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "name", 2 );
                append( sb, "The name of the report to be displayed in the Maven Generated Reports page.", 3 );
                append( sb, "Expression: ${taglibrarydoc.name}", 3 );
                append( sb, "", 0 );

                append( sb, "outputZipFile (Default: ${project.artifactId}-${project.version}-tlddoc.zip)", 2 );
                append( sb, "The name of the destination directory.", 3 );
                append( sb, "Expression: ${taglibrarydoc.outputZipFile}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: false)", 2 );
                append( sb, "Should we be quiet?", 3 );
                append( sb, "Expression: ${taglibrarydoc.quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "srcDir (Default: ${basedir}/src/main/resources/META-INF)", 2 );
                append( sb, "Source directory to lookup files.", 3 );
                append( sb, "Expression: ${taglibrarydoc.srcDir}", 3 );
                append( sb, "", 0 );

                append( sb, "windowTitle (Default: ${project.name} v${project.version} Tag Reference)", 2 );
                append( sb, "The window title for the generated report.", 3 );
                append( sb, "Expression: ${taglibrarydoc.windowTitle}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test".equals( goal ) )
        {
            append( sb, "jahia:test", 0 );
            append( sb, "Execute a test servlet deployed in Jahia Available tests are in a mod-test.xml file", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "skipCoreTests", 2 );
                append( sb, "Test to execute", 3 );
                append( sb, "Expression: ${skipCoreTests}", 3 );
                append( sb, "", 0 );

                append( sb, "startupTimeout (Default: 60)", 2 );
                append( sb, "Startup timeout (seconds)", 3 );
                append( sb, "", 0 );

                append( sb, "startupWait (Default: true)", 2 );
                append( sb, "Startup waiting time (seconds)", 3 );
                append( sb, "", 0 );

                append( sb, "test", 2 );
                append( sb, "Test to execute", 3 );
                append( sb, "Expression: ${test}", 3 );
                append( sb, "", 0 );

                append( sb, "testOutputDirectory", 2 );
                append( sb, "Output directory for TestNG results", 3 );
                append( sb, "Expression: ${testOutputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "testURL (Default: http://localhost:8080/cms)", 2 );
                append( sb, "Test URL", 3 );
                append( sb, "Expression: ${jahia.test.url}", 3 );
                append( sb, "", 0 );

                append( sb, "xmlTest", 2 );
                append( sb, "Server type", 3 );
                append( sb, "Expression: ${xmlTest}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "update-properties-file".equals( goal ) )
        {
            append( sb, "jahia:update-properties-file", 0 );
            append( sb, "Mojo that adds the value for a property in the properties file.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "append", 2 );
                append( sb, "Should the value be rather appended (in case of true) to the existing one or overwrite it completely (in case of false).", 3 );
                append( sb, "", 0 );

                append( sb, "dest", 2 );
                append( sb, "The target file to write properties file into. If not specified the source file will be modified \'in-place\'.", 3 );
                append( sb, "", 0 );

                append( sb, "formatMultiValues", 2 );
                append( sb, "If set to true the multivalue entries will be formatted into multiline.", 3 );
                append( sb, "", 0 );

                append( sb, "key", 2 );
                append( sb, "The key for the entry in the properties file.", 3 );
                append( sb, "", 0 );

                append( sb, "prettyPrint", 2 );
                append( sb, "If set to true the multiline value formatting will use pretty print (space indentation).", 3 );
                append( sb, "", 0 );

                append( sb, "src", 2 );
                append( sb, "The properties file as a source of modifications.", 3 );
                append( sb, "", 0 );

                append( sb, "substitute", 2 );
                append( sb, "Should we perform value interpolation in the properties?", 3 );
                append( sb, "", 0 );

                append( sb, "value", 2 );
                append( sb, "The value to be added into property file. In case the value is not provided the entry with the specified key will be removed from the properties file.", 3 );
                append( sb, "", 0 );

                append( sb, "valueSeparator", 2 );
                append( sb, "Value separator.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
