/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.jahia.configuration.logging.AbstractLogger;
import org.jahia.configuration.modules.ModuleDeployer;
import org.jahia.utils.maven.plugin.AbstractManagementMojo;
import org.jahia.utils.maven.plugin.MojoLogger;

public class CopyTemplatesMojo
extends AbstractManagementMojo {
    protected boolean deployTests;
    protected boolean deployModules;
    protected boolean deployToServer;

    /*
     * Unable to fully structure code
     */
    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        dependencyFiles = this.project.getDependencyArtifacts();
        dependenciesToRemove = new HashSet<Artifact>();
        if (this.deployToServer) {
            try {
                target = new File(this.getDataDir(), "modules");
                if (target.exists()) ** GOTO lbl16
                target.mkdirs();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot deploy module", e);
            }
        } else {
            target = new File(this.output, "digital-factory-data/modules");
            if (!target.exists()) {
                target.mkdirs();
            }
        }
lbl16:
        // 5 sources

        deployer = new ModuleDeployer(target, (AbstractLogger)new MojoLogger(this.getLog()));
        for (Artifact dependencyFile : dependencyFiles) {
            file = dependencyFile.getFile();
            groupId = dependencyFile.getGroupId();
            if (this.deployModules && (groupId.equals("org.jahia.modules") || groupId.equals("org.jahia.templates") || groupId.endsWith(".jahia.modules")) || this.deployTests && groupId.equals("org.jahia.test")) {
                try {
                    deployer.deployModule(file);
                    dependenciesToRemove.add(dependencyFile);
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error when copying file " + file), (Throwable)e);
                }
                continue;
            }
            if (groupId.equals("org.jahia.prepackagedsites")) {
                try {
                    deployDir = this.deployToServer != false ? this.getDataDir() : new File(this.output, "digital-factory-data");
                    FileUtils.copyFile((File)file, (File)new File(deployDir, "prepackagedSites/" + dependencyFile.getArtifactId() + ".zip"));
                    this.getLog().info((CharSequence)("Copy prepackaged site " + file.getName()));
                    dependenciesToRemove.add(dependencyFile);
                    continue;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Error when copying file " + file), (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Cannot deploy prepackaged site", e);
                }
            }
            if (!groupId.equals("org.jahia.packages") || !dependencyFile.getType().equals("jar") && !dependencyFile.getType().equals("bundle")) continue;
            try {
                this.getLog().info((CharSequence)("Deploying package " + file.getName()));
                dependenciesToRemove.add(dependencyFile);
                this.deployPackageFile(file, deployer);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Cannot deploy package " + dependencyFile), (Throwable)e);
                throw new MojoExecutionException("Cannot deploy package " + dependencyFile, e);
            }
        }
        dependencyList = new ArrayList<E>(dependencyFiles);
        for (Artifact dependencyFile : dependenciesToRemove) {
            dependencyList.remove(dependencyFile);
        }
        this.project.setDependencyArtifacts(new LinkedHashSet<E>(dependencyList));
    }

    private void deployPackageFile(File file, ModuleDeployer deployer) throws ArchiverException, IOException {
        ZipUnArchiver unzip = new ZipUnArchiver(file);
        unzip.enableLogging((Logger)new ConsoleLogger(this.getLog().isDebugEnabled() ? 0 : 1, "console"));
        File target = new File(FileUtils.getTempDirectory(), CopyTemplatesMojo.class.getSimpleName());
        FileUtils.deleteQuietly((File)target);
        target.mkdir();
        unzip.setDestDirectory(target);
        unzip.setFileSelectors(Collections.singletonList(new FileSelector(){

            public boolean isSelected(FileInfo fileInfo) throws IOException {
                return fileInfo.isFile() && fileInfo.getName().endsWith(".jar");
            }
        }).toArray(new FileSelector[0]));
        unzip.extract();
        File[] jars = target.listFiles();
        if (jars == null) {
            return;
        }
        for (File f : jars) {
            deployer.deployModule(f);
        }
    }
}

