/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitBuildNumberMojo
extends AbstractMojo {
    protected MavenProject project;
    private List<MavenProject> reactorProjects;
    protected boolean allBranches = false;
    protected int baseBuildNumber = 0;
    protected String baseGitRevision = "";
    private String buildNumberPropertyName;
    private boolean getRevisionOnlyOnce;
    protected File scmDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getProperties().get("maven.gitBuildNumber.alreadySet") != null) {
            return;
        }
        DefaultLog logger = new DefaultLog();
        ScmFileSet scmFileSet = new ScmFileSet(this.scmDirectory);
        RevisionCountConsumer consumer = new RevisionCountConsumer((ScmLogger)logger);
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        Commandline cli = GitCommandLineUtils.getBaseGitCommandLine((File)scmFileSet.getBasedir(), (String)"rev-list");
        if (this.allBranches) {
            cli.createArg().setValue("--all");
            String currentRevision = this.getCurrentRevision((ScmLogger)logger, stderr, scmFileSet.getBasedir());
            consumer.setStartCountFrom(currentRevision);
            if (this.baseGitRevision != null && !"".equals(this.baseGitRevision)) {
                consumer.setStopCountAt(this.baseGitRevision);
            }
        } else {
            cli.createArg().setValue("HEAD");
        }
        try {
            int exitCode = GitCommandLineUtils.execute((Commandline)cli, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)logger);
            if (exitCode == 0) {
                String revision = null;
                if (this.allBranches) {
                    revision = Integer.toString(consumer.getCount() + this.baseBuildNumber);
                } else {
                    String currentBranch = GitBranchCommand.getCurrentBranch((ScmLogger)logger, null, (ScmFileSet)scmFileSet);
                    revision = currentBranch + "-" + (consumer.getCount() + this.baseBuildNumber);
                }
                this.getLog().info((CharSequence)("Setting build number property " + this.buildNumberPropertyName + " to revision " + revision));
                this.project.getProperties().put(this.buildNumberPropertyName, revision);
                if (this.getRevisionOnlyOnce && this.reactorProjects != null) {
                    for (MavenProject mavenProject : this.reactorProjects) {
                        mavenProject.getProperties().put(this.buildNumberPropertyName, revision);
                        mavenProject.getProperties().put("maven.gitBuildNumber.alreadySet", "true");
                    }
                }
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getCurrentRevision(ScmLogger logger, CommandLineUtils.StringStreamConsumer stderr, File basedir) throws MojoExecutionException {
        try {
            Commandline cli = GitCommandLineUtils.getBaseGitCommandLine((File)basedir, (String)"rev-parse");
            cli.createArg().setValue("HEAD");
            LineConsumer lineConsumer = new LineConsumer(logger);
            int exitCode = GitCommandLineUtils.execute((Commandline)cli, (StreamConsumer)lineConsumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)logger);
            if (exitCode == 0) {
                return lineConsumer.getResult();
            }
        }
        catch (ScmException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return null;
    }

    private static class RevisionCountConsumer
    extends AbstractConsumer {
        private int count = 0;
        private String startCountFrom = null;
        private String stopCountAt = null;

        public RevisionCountConsumer(ScmLogger logger) {
            super(logger);
        }

        public void setStartCountFrom(String startCountFrom) {
            this.startCountFrom = startCountFrom;
        }

        public void setStopCountAt(String stopCountAt) {
            this.stopCountAt = stopCountAt;
        }

        public void consumeLine(String s) {
            if (this.startCountFrom != null) {
                if (!s.equals(this.startCountFrom)) {
                    return;
                }
                this.startCountFrom = null;
            }
            if (this.stopCountAt != null && (s.equals(this.stopCountAt) || "stopped".equals(this.stopCountAt))) {
                this.stopCountAt = "stopped";
                return;
            }
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class LineConsumer
    extends AbstractConsumer {
        private String result;

        public LineConsumer(ScmLogger logger) {
            super(logger);
        }

        public void consumeLine(String s) {
            this.result = s;
        }

        public String getResult() {
            return this.result;
        }
    }
}

