/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.jahia.configuration.configurators.JahiaGlobalConfigurator;
import org.jahia.utils.maven.plugin.contentgenerator.OutputService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.GroupBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.UserBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.CollectionService;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.CollectionBO;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class UserGroupService {
    private Log logger = new SystemStreamLog();
    private static String sep = System.getProperty("file.separator");

    public Document createUsersRepository(List<UserBO> users) {
        Document doc = new Document();
        Element contentNode = new Element("content");
        contentNode.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
        doc.setRootElement(contentNode);
        Element usersNode = new Element("users");
        contentNode.addContent((Content)usersNode);
        UserBO rootUser = new UserBO("root", JahiaGlobalConfigurator.encryptPassword((String)"root"));
        Element rootUserNode = rootUser.getJcrXml();
        usersNode.addContent((Content)rootUserNode);
        for (UserBO userBO : users) {
            usersNode.addContent((Content)userBO.getJcrXml());
        }
        return doc;
    }

    public File createFileTreeForUsers(List<UserBO> users, File tempDirectory) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        OutputService os = new OutputService();
        File f = new File(tempDirectory + sep + "content" + sep + "users");
        FileUtils.forceMkdir((File)f);
        for (UserBO userBO : users) {
            this.logger.debug((CharSequence)("Creates directories tree for user " + userBO.getName()));
            File dirUser = new File(f + sep + userBO.getDirectoryName(1) + sep + userBO.getDirectoryName(2) + sep + userBO.getDirectoryName(3) + sep + userBO.getName() + sep + "files" + sep + "profiles" + sep + "publisher.png");
            FileUtils.forceMkdir((File)dirUser);
            File thumbnail = new File(dirUser + sep + "publisher.png");
            os.writeInputStreamToFile(cl.getResourceAsStream("publisher.png"), thumbnail);
        }
        return f;
    }

    public Element generateJcrGroups(String siteKey, List<GroupBO> groups) {
        this.logger.info((CharSequence)"Users and groups generated, creation of JCR document...");
        Element groupsNode = new Element("groups");
        Element siteAdminNode = new Element("site-administrators");
        siteAdminNode.setAttribute("mixinTypes", "jmix:systemNode", ContentGeneratorCst.NS_JCR);
        siteAdminNode.setAttribute("primaryType", "jnt:group", ContentGeneratorCst.NS_JCR);
        groupsNode.addContent((Content)siteAdminNode);
        Element jmembersSiteAdmin = new Element("members", ContentGeneratorCst.NS_J);
        jmembersSiteAdmin.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
        siteAdminNode.addContent((Content)jmembersSiteAdmin);
        Element rootUser = new Element("root");
        rootUser.setAttribute("member", "/users/root", ContentGeneratorCst.NS_J);
        rootUser.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
        jmembersSiteAdmin.addContent((Content)rootUser);
        Element sitePrivilegedNode = new Element("site-privileged");
        sitePrivilegedNode.setAttribute("mixinTypes", "systemNode", ContentGeneratorCst.NS_JMIX);
        sitePrivilegedNode.setAttribute("primaryType", "jnt:group", ContentGeneratorCst.NS_JCR);
        sitePrivilegedNode.setAttribute("hidden", "false", ContentGeneratorCst.NS_J);
        groupsNode.addContent((Content)sitePrivilegedNode);
        Element jmembersSitePrivileged = new Element("members", ContentGeneratorCst.NS_J);
        jmembersSitePrivileged.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
        sitePrivilegedNode.addContent((Content)jmembersSitePrivileged);
        Element siteAdminGroup = new Element("site-administrators");
        siteAdminGroup.setAttribute("member", "/sites/" + siteKey + "/groups/site-administrators", ContentGeneratorCst.NS_J);
        siteAdminGroup.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
        jmembersSitePrivileged.setContent((Content)siteAdminGroup);
        for (GroupBO group : groups) {
            Element groupNode = group.getJcrXml();
            groupsNode.addContent((Content)groupNode);
        }
        return groupsNode;
    }

    public List<UserBO> generateUsers(Integer nbUsers, Integer nbCollectionsPerUser, Integer nbFilesPerCollection, Integer nbFilesGenerated) {
        this.logger.info((CharSequence)(nbUsers + " users are going to be generated"));
        ArrayList<UserBO> users = new ArrayList<UserBO>();
        for (int userid = 0; userid < nbUsers; ++userid) {
            String username = "user" + userid;
            String pathJcr = this.getPathForUsername(username);
            List<CollectionBO> collections = new ArrayList<CollectionBO>();
            if (nbCollectionsPerUser != null && nbCollectionsPerUser.compareTo(0) > 0) {
                CollectionService collectionService = CollectionService.getInstance();
                collections = collectionService.generateCollections(nbCollectionsPerUser, nbFilesPerCollection, nbFilesGenerated, username);
            }
            UserBO user = new UserBO(username, JahiaGlobalConfigurator.encryptPassword((String)username), pathJcr, collections);
            users.add(user);
        }
        return users;
    }

    public List<GroupBO> generateGroups(Integer nbGroups, Integer nbUsersPerGroup, List<UserBO> users) {
        this.logger.info((CharSequence)(nbGroups + " groups are going to be generated"));
        ArrayList<GroupBO> groups = new ArrayList<GroupBO>();
        int cptUsers = 0;
        for (int cptGroups = 1; cptGroups <= nbGroups; ++cptGroups) {
            ArrayList<UserBO> usersForGroup = new ArrayList<UserBO>();
            int total = cptUsers + nbUsersPerGroup;
            while (cptUsers < total) {
                usersForGroup.add(users.get(cptUsers % users.size()));
                ++cptUsers;
            }
            GroupBO group = new GroupBO("group" + cptGroups, usersForGroup);
            groups.add(group);
        }
        return groups;
    }

    public String getPathForUsername(String username) {
        StringBuilder builder = new StringBuilder();
        int userNameHashcode = Math.abs(username.hashCode());
        String firstFolder = this.getFolderName(userNameHashcode).toLowerCase();
        userNameHashcode = Math.round(userNameHashcode / 100);
        String secondFolder = this.getFolderName(userNameHashcode).toLowerCase();
        userNameHashcode = Math.round(userNameHashcode / 100);
        String thirdFolder = this.getFolderName(userNameHashcode).toLowerCase();
        return builder.append("/users").append("/").append(firstFolder).append("/").append(secondFolder).append("/").append(thirdFolder).append("/").append(username).toString();
    }

    private String getFolderName(int userNameHashcode) {
        int i = userNameHashcode % 100;
        return Character.toString((char)(97 + Math.round(i / 10))) + Character.toString((char)(97 + i % 10));
    }

    public Integer getNbUsersPerGroup(Integer nbUsers, Integer nbGroups) {
        Integer nbUsersPerGroup = nbUsers / nbGroups;
        return nbUsersPerGroup;
    }

    public Integer getNbUsersRemaining(Integer nbUsers, Integer nbGroups) {
        Integer nbUsersRemaining = nbUsers % nbGroups;
        return nbUsersRemaining;
    }
}

