/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.NewsBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public abstract class ContentBO {
    protected Element element;
    protected String namePrefix;
    protected List<ContentBO> subContents;
    protected Map<String, ArticleBO> articles;
    protected String siteKey;
    protected String fileName;
    protected Integer numberBigText;
    protected Map<String, List<String>> acls;
    protected Integer idCategory;
    protected Integer idTag;
    protected Boolean visibilityEnabled;
    protected String visibilityStartDate;
    protected String visibilityEndDate;
    protected String description;
    protected String cmisSite;
    protected List<String> externalFilePaths;
    protected boolean personalized;
    protected int minPersonalizationVariants;
    protected int maxPersonalizationVariants;

    public ContentBO(String namePrefix, Map<String, ArticleBO> articles, List<ContentBO> subContents, String siteKey, String fileName, Integer numberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate, String description, String cmisSite, List<String> externalFilePaths, boolean personalized, int minPersonalizationVariants, int maxPersonalizationVariants) {
        this.subContents = subContents;
        this.articles = articles;
        this.namePrefix = namePrefix;
        this.siteKey = siteKey;
        this.fileName = fileName;
        this.numberBigText = numberBigText;
        this.acls = acls;
        this.idCategory = idCategory;
        this.idTag = idTag;
        this.visibilityEnabled = visibilityEnabled;
        this.visibilityStartDate = visibilityStartDate;
        this.visibilityEndDate = visibilityEndDate;
        this.description = description;
        this.cmisSite = cmisSite;
        this.externalFilePaths = externalFilePaths;
        this.personalized = personalized;
        this.minPersonalizationVariants = minPersonalizationVariants;
        this.maxPersonalizationVariants = maxPersonalizationVariants;
        this.buildElement();
    }

    public String getName() {
        if (this.personalized) {
            return this.namePrefix + "-personalized";
        }
        return this.namePrefix;
    }

    public Element getElement() {
        return this.element;
    }

    private void buildElement() {
        this.element = new Element(this.getName());
        if (null != this.subContents) {
            for (ContentBO contentBO : this.subContents) {
                this.element.addContent((Content)contentBO.getElement());
            }
        }
        if (this.idCategory != null) {
            this.element.setAttribute("jcategorized", "", ContentGeneratorCst.NS_JMIX);
            this.element.setAttribute("defaultCategory", "/sites/systemsite/categories/category" + this.idCategory, ContentGeneratorCst.NS_J);
        }
        if (this.idTag != null) {
            this.element.setAttribute("tags", "/sites/" + this.siteKey + "/tags/tag" + this.idTag, ContentGeneratorCst.NS_J);
        }
        for (Map.Entry entry : this.articles.entrySet()) {
            Element element = new Element("translation_" + (String)entry.getKey(), ContentGeneratorCst.NS_J);
            element.setAttribute("language", (String)entry.getKey(), ContentGeneratorCst.NS_JCR);
            element.setAttribute("mixinTypes", "mix:title", ContentGeneratorCst.NS_JCR);
            element.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            element.setAttribute("title", ((ArticleBO)entry.getValue()).getTitle(), ContentGeneratorCst.NS_JCR);
            if (StringUtils.isNotEmpty((String)this.description)) {
                element.setAttribute("description", this.description, ContentGeneratorCst.NS_JCR);
            }
            this.element.addContent((Content)element);
        }
        if (!this.acls.isEmpty()) {
            Element aclNode = new Element("acl", ContentGeneratorCst.NS_J);
            aclNode.setAttribute("inherit", "true", ContentGeneratorCst.NS_J);
            aclNode.setAttribute("primaryType", "jnt:acl", ContentGeneratorCst.NS_JCR);
            for (Map.Entry<String, List<String>> entry : this.acls.entrySet()) {
                String roles = "";
                for (String s : entry.getValue()) {
                    roles = roles + s + " ";
                }
                Element aceNode = new Element("GRANT_" + entry.getKey().replace(":", "_"));
                aceNode.setAttribute("aceType", "GRANT", ContentGeneratorCst.NS_J);
                aceNode.setAttribute("principal", entry.getKey(), ContentGeneratorCst.NS_J);
                aceNode.setAttribute("protected", "false", ContentGeneratorCst.NS_J);
                aceNode.setAttribute("roles", roles.trim(), ContentGeneratorCst.NS_J);
                aceNode.setAttribute("primaryType", "jnt:ace", ContentGeneratorCst.NS_JCR);
                aclNode.addContent((Content)aceNode);
            }
            this.element.addContent((Content)aclNode);
        }
        if (this.visibilityEnabled.booleanValue()) {
            Element visibilityNode = new Element("conditionalVisibility", ContentGeneratorCst.NS_J);
            visibilityNode.setAttribute("conditionalVisibility", null, ContentGeneratorCst.NS_J);
            visibilityNode.setAttribute("forceMatchAllConditions", "true", ContentGeneratorCst.NS_J);
            visibilityNode.setAttribute("primaryType", "jnt:conditionalVisibility", ContentGeneratorCst.NS_JCR);
            Element element = new Element("startEndDateCondition0", ContentGeneratorCst.NS_JNT);
            element.setAttribute("primaryType", "jnt:startEndDateCondition", ContentGeneratorCst.NS_JCR);
            element.setAttribute("start", this.visibilityStartDate);
            element.setAttribute("end", this.visibilityEndDate);
            visibilityNode.addContent((Content)element);
            this.element.addContent((Content)visibilityNode);
        }
    }

    protected void buildPersonalizedElements(Element element) {
        LinkedList<Element> personalizableElements = new LinkedList<Element>();
        if (StringUtils.startsWith((String)this.namePrefix, (String)"qa-list")) {
            ArrayList<String> languages = new ArrayList<String>();
            for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                languages.add(entry.getKey());
            }
            for (int i = 1; i <= ContentGeneratorCst.NB_NEWS_IN_QALIST; ++i) {
                Element newsNode = new NewsBO(this.namePrefix + "-news" + i, languages).getElement();
                element.addContent((Content)newsNode);
                if (i > ContentGeneratorCst.NB_NEWS_PER_PAGE_IN_QALIST) continue;
                personalizableElements.add(newsNode);
            }
        } else if (StringUtils.startsWith((String)this.namePrefix, (String)"events")) {
            for (int i = 1; i <= this.numberBigText; ++i) {
                Element bigTextNode = new Element("bigText_" + i);
                bigTextNode.setAttribute("primaryType", "jnt:bigText", ContentGeneratorCst.NS_JCR);
                bigTextNode.setAttribute("mixinTypes", "jmix:renderable", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    Element translationNode = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                    translationNode.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                    translationNode.setAttribute("text", entry.getValue().getContent());
                    bigTextNode.addContent((Content)translationNode);
                }
                element.addContent((Content)bigTextNode);
                personalizableElements.add(bigTextNode);
            }
        } else if (StringUtils.startsWith((String)this.namePrefix, (String)"qa-external")) {
            for (int i = 0; i < this.externalFilePaths.size(); ++i) {
                String externalFilePath = this.externalFilePaths.get(i);
                Element externalFileReference = new Element("external-file-reference-" + i);
                externalFileReference.setAttribute("node", "/mounts/cmisMountPoint/Sites/" + this.cmisSite + externalFilePath, ContentGeneratorCst.NS_J);
                externalFileReference.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
                personalizableElements.add(externalFileReference);
                element.addContent((Content)externalFileReference);
            }
        } else if (StringUtils.startsWith((String)this.namePrefix, (String)"qa-internal") && this.fileName != null) {
            Element randomFileNode = new Element("rand-file");
            randomFileNode.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
            Element fileTranslationNode = new Element("translation_en", ContentGeneratorCst.NS_J);
            fileTranslationNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            fileTranslationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            fileTranslationNode.setAttribute("title", "My file", ContentGeneratorCst.NS_JCR);
            randomFileNode.addContent((Content)fileTranslationNode);
            Element publicationNode = new Element("publication");
            publicationNode.setAttribute("primaryType", "jnt:publication", ContentGeneratorCst.NS_JCR);
            Element publicationTranslationNode = new Element("translation_en", ContentGeneratorCst.NS_J);
            publicationTranslationNode.setAttribute("author", "Jahia Content Generator");
            publicationTranslationNode.setAttribute("body", "&lt;p&gt;  Random publication&lt;/p&gt;");
            publicationTranslationNode.setAttribute("title", "Random publication", ContentGeneratorCst.NS_JCR);
            publicationTranslationNode.setAttribute("file", "/sites/" + this.siteKey + "/files/contributed/" + ISO9075.encode((String)this.fileName));
            publicationTranslationNode.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
            publicationTranslationNode.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
            publicationTranslationNode.setAttribute("source", "Jahia");
            publicationNode.addContent((Content)publicationTranslationNode);
            element.addContent((Content)publicationNode);
        }
        if (this.personalized) {
            if (personalizableElements.isEmpty()) {
                this.personalized = false;
                element.setName(this.getName());
            } else {
                Element persoElement = (Element)personalizableElements.get(ThreadLocalRandom.current().nextInt(personalizableElements.size()));
                int elementIndex = element.indexOf((Content)persoElement);
                element.removeContent((Content)persoElement);
                persoElement = this.getPersonalizedElement(persoElement);
                element.addContent(elementIndex, (Content)persoElement);
            }
        }
    }

    public String getJcrXml() {
        return this.getElement().getText();
    }

    private Element getPersonalizedElement(Element element) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Element personalizationElement = new Element("experience-" + element.getName());
        personalizationElement.setAttribute("primaryType", "wemnt:personalizedContent", ContentGeneratorCst.NS_JCR);
        personalizationElement.setAttribute("active", "true", ContentGeneratorCst.NS_WEM);
        personalizationElement.setAttribute("personalizationStrategy", "priority", ContentGeneratorCst.NS_WEM);
        String[] segments = ContentGeneratorCst.SEGMENTS[((Random)random).nextInt(ContentGeneratorCst.SEGMENTS.length)];
        int nbPersonalizationVariants = this.minPersonalizationVariants + ((Random)random).nextInt(this.maxPersonalizationVariants - this.minPersonalizationVariants + 1);
        if (nbPersonalizationVariants > segments.length) {
            nbPersonalizationVariants = segments.length;
        }
        for (int i = 0; i < nbPersonalizationVariants; ++i) {
            Element variantElement = (Element)element.clone();
            variantElement.setName(variantElement.getName() + "-" + (i + 1));
            Attribute mixinTypesAttribute = variantElement.getAttribute("mixinTypes", ContentGeneratorCst.NS_JCR);
            String mixinTypes = mixinTypesAttribute == null ? "" : mixinTypesAttribute.getValue() + " ";
            variantElement.setAttribute("mixinTypes", mixinTypes + "wemmix:editItem", ContentGeneratorCst.NS_JCR);
            String jsonFilter = "{\"parameterValues\":{\"subConditions\":[{\"type\":\"profileSegmentCondition\",\"parameterValues\":{\"segments\":[\"" + segments[i] + "\"]}}],\"operator\":\"and\"},\"type\":\"booleanCondition\"}";
            variantElement.setAttribute("jsonFilter", jsonFilter, ContentGeneratorCst.NS_WEM);
            personalizationElement.addContent((Content)variantElement);
        }
        return personalizationElement;
    }

    public List<ContentBO> getSubContents() {
        return this.subContents;
    }
}

