/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.ArrayList;
import java.util.List;
import org.jahia.utils.maven.plugin.contentgenerator.bo.UserBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Content;
import org.jdom.Element;

public class GroupBO {
    private String name;
    private List<UserBO> users;

    public GroupBO(String name, List<UserBO> users) {
        this.name = name;
        this.users = users;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getNbUsers() {
        return this.users.size();
    }

    public List<UserBO> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserBO> users) {
        this.users = users;
    }

    public List<String> getUserNames() {
        ArrayList<String> userNames = new ArrayList<String>();
        for (UserBO user : this.users) {
            userNames.add(user.getName());
        }
        return userNames;
    }

    public Element getJcrXml() {
        Element groupNode = new Element(this.name);
        groupNode.setAttribute("primaryType", "jnt:group", ContentGeneratorCst.NS_JCR);
        groupNode.setAttribute("hidden", "false", ContentGeneratorCst.NS_J);
        Element users = new Element("members", ContentGeneratorCst.NS_J);
        users.setAttribute("primaryType", "jnt:members", ContentGeneratorCst.NS_JCR);
        groupNode.addContent((Content)users);
        for (UserBO user : this.users) {
            Element userNode = new Element(user.getName());
            userNode.setAttribute("member", user.getPathJcr(), ContentGeneratorCst.NS_J);
            userNode.setAttribute("primaryType", "jnt:member", ContentGeneratorCst.NS_JCR);
            users.addContent((Content)userNode);
        }
        return groupNode;
    }
}

