/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.wise;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.bo.TagBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FileBO;
import org.jahia.utils.maven.plugin.contentgenerator.wise.bo.FolderBO;

public class FileAndFolderService {
    private Log logger = new SystemStreamLog();
    Random rand = new Random();
    private static FileAndFolderService instance;
    String sep = System.getProperty("file.separator");
    private static List<String> oftenUsedDescriptionWords;
    private static List<String> seldomUsedDescriptionWords;
    private static Integer currentOftenUsedDescriptionWordIndex;
    private static Integer currentSeldomUsedDescriptionWordIndex;
    private static Integer nbOfFilesUsedForOftenUsedDescriptionWords;
    private static Integer nbOfFilesUsedForSeldomUsedDescriptionWords;
    private static Integer nbOfOftenUsedDescriptionWords;
    private static Integer nbOfSeldomUsedDescriptionWords;
    private static int totalGeneratedFiles;
    private static long timestampDifference;
    private static long startTimestamp;

    private FileAndFolderService() {
        oftenUsedDescriptionWords = Arrays.asList(ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
        seldomUsedDescriptionWords = Arrays.asList(ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS.split("\\s*,\\s*"));
        currentOftenUsedDescriptionWordIndex = 0;
        currentSeldomUsedDescriptionWordIndex = 0;
        nbOfFilesUsedForOftenUsedDescriptionWords = ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS_COUNTER;
        nbOfFilesUsedForSeldomUsedDescriptionWords = ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS_COUNTER;
        nbOfOftenUsedDescriptionWords = oftenUsedDescriptionWords.size();
        nbOfSeldomUsedDescriptionWords = seldomUsedDescriptionWords.size();
    }

    public static FileAndFolderService getInstance() {
        if (instance == null) {
            instance = new FileAndFolderService();
        }
        return instance;
    }

    public void generateFolders(String docspaceName, ExportBO wiseExport) {
        docspaceName = StringUtils.lowerCase((String)docspaceName);
        double nbNodes = wiseExport.getNbFoldersPerLevel().doubleValue();
        double depth = wiseExport.getFoldersDepth().doubleValue();
        Double totalFolders = Math.pow(nbNodes, depth) - 1.0;
        totalFolders = totalFolders / (nbNodes - 1.0);
        totalFolders = totalFolders * nbNodes;
        Double totalFiles = totalFolders * (double)wiseExport.getNbFilesPerFolder().intValue();
        this.logger.info((CharSequence)("Folders generation is starting, " + totalFolders.intValue() + " folders to create, containing a total of " + totalFiles.intValue() + " files."));
        String currentPath = this.initializeContentFolder(wiseExport.getOutputDir() + this.sep + "wise", wiseExport.getSiteKey(), docspaceName);
        String currentNodePath = "/sites/" + wiseExport.getSiteKey() + "/files/docspaces/" + docspaceName;
        Integer nbFilesAvailable = wiseExport.getFileNames().size();
        if (wiseExport.getNbFilesPerFolder().compareTo(nbFilesAvailable) > 0) {
            this.logger.warn((CharSequence)("You asked for " + wiseExport.getNbFilesPerFolder() + " files per folder, but there are only " + nbFilesAvailable + " files in the pool, and we can't use them twice."));
            wiseExport.setNbFilesPerFolder(nbFilesAvailable);
        }
        File tmpTopFoldersDir = new File(ExportBO.tmp + this.sep + "top_folders");
        tmpTopFoldersDir.mkdir();
        File tmpFilesDir = new File(ExportBO.tmp + this.sep + "wise_files");
        tmpFilesDir.mkdir();
        startTimestamp = wiseExport.getStartCreationDateRange().getTime();
        long endTimestamp = wiseExport.getEndCreationDateRange().getTime();
        timestampDifference = endTimestamp - startTimestamp;
        this.generateFolders(1, currentPath, currentNodePath, wiseExport);
    }

    private List<FolderBO> generateFolders(Integer currentDepth, String currentPath, String currentNodePath, ExportBO wiseExport) {
        String depthName;
        Integer nbFoldersPerLevel = wiseExport.getNbFoldersPerLevel();
        Integer foldersDepth = wiseExport.getFoldersDepth();
        Integer filesPerFolder = wiseExport.getNbFilesPerFolder();
        List<String> fileNames = wiseExport.getFileNames();
        File filesDirectory = wiseExport.getFilesDirectory();
        switch (currentDepth) {
            case 1: {
                depthName = "aaa";
                break;
            }
            case 2: {
                depthName = "bbb";
                break;
            }
            case 3: {
                depthName = "ccc";
                break;
            }
            case 4: {
                depthName = "ddd";
                break;
            }
            case 5: {
                depthName = "eee";
                break;
            }
            case 6: {
                depthName = "fff";
                break;
            }
            case 7: {
                depthName = "ggg";
                break;
            }
            case 8: {
                depthName = "hhh";
                break;
            }
            case 9: {
                depthName = "iii";
                break;
            }
            default: {
                depthName = "aaa";
            }
        }
        ArrayList<FolderBO> folders = new ArrayList<FolderBO>();
        for (int i = 1; i <= nbFoldersPerLevel; ++i) {
            ObjectOutputStream oos;
            FileOutputStream tmpFile;
            if (currentDepth == 1) {
                this.logger.info((CharSequence)("Generating top folder " + i + "/" + nbFoldersPerLevel));
            }
            List<FolderBO> subFolders = null;
            Set<FileBO> files = this.generateFiles(filesPerFolder, currentNodePath + "/" + depthName + i, fileNames, wiseExport.getNumberOfUsers(), filesDirectory, wiseExport.getTags(), wiseExport.getSiteKey());
            File tmpWiseFilesDir = new File(ExportBO.tmp + this.sep + "wise_files");
            for (FileBO file : files) {
                try {
                    tmpFile = new FileOutputStream(tmpWiseFilesDir + this.sep + totalGeneratedFiles + ".ser");
                    oos = new ObjectOutputStream(tmpFile);
                    oos.writeObject(file);
                    oos.flush();
                    oos.close();
                    ++totalGeneratedFiles;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (currentDepth < foldersDepth) {
                subFolders = this.generateFolders(currentDepth + 1, currentPath + this.sep + depthName + i, currentNodePath + "/" + depthName + i, wiseExport);
            }
            FolderBO folder = new FolderBO(depthName + i, subFolders, files);
            folders.add(folder);
            if (currentDepth == 1) {
                File tmpTopFoldersDir = new File(ExportBO.tmp + this.sep + "top_folders");
                try {
                    tmpFile = new FileOutputStream(tmpTopFoldersDir + this.sep + i + ".ser");
                    oos = new ObjectOutputStream(tmpFile);
                    oos.writeObject(folder);
                    oos.flush();
                    oos.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                folder = null;
            }
            File newFolder = new File(currentPath + this.sep + depthName + i);
            newFolder.mkdirs();
            for (FileBO fileBO : files) {
                File sourceFile = new File(filesDirectory + this.sep + fileBO.getFileName());
                File targetDirectory = new File(newFolder + this.sep + fileBO.getFileName());
                targetDirectory.mkdir();
                File targetFile = new File(targetDirectory + this.sep + fileBO.getFileName());
                try {
                    FileUtils.copyFile((File)sourceFile, (File)targetFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(folders);
        return folders;
    }

    public Set<FileBO> generateFiles(Integer nbFilesToGenerate, String currentNodePath, List<String> fileNames, Integer nbUsers, File filesDirectory, List<TagBO> tags, String wiseInstanceName) {
        TreeSet<FileBO> files = new TreeSet<FileBO>();
        ArrayList<String> fileNamesAvailable = new ArrayList<String>(fileNames);
        Integer nbAvailableFiles = fileNames.size();
        int currentFilenameIndex = 0;
        String[] imageExtensions = new String[]{".png", ".gif", ".jpeg", ".jpg"};
        String[] officeDocumentExtensions = new String[]{".doc", ".xls", ".ppt", ".docx", ".xlsx", ".pptx"};
        String creator = "root";
        String owner = "root";
        String editor = "root";
        String reader = "root";
        int nbOfTags = tags.size();
        String extractedContent = "";
        FileBO newFile = null;
        while (files.size() < nbFilesToGenerate) {
            String fileName = "";
            if (nbFilesToGenerate.compareTo(nbAvailableFiles) >= 0) {
                fileName = fileNames.get(currentFilenameIndex);
                ++currentFilenameIndex;
            } else {
                int remainingNbAvailableFiles = fileNamesAvailable.size() - 1;
                int randFilenameIndex = this.rand.nextInt(remainingNbAvailableFiles);
                fileName = (String)fileNamesAvailable.get(randFilenameIndex);
                fileNamesAvailable.remove(randFilenameIndex);
            }
            String mixin = "";
            if (nbUsers != null && nbUsers.compareTo(0) > 0) {
                int idCreator = this.rand.nextInt(nbUsers - 1);
                creator = "user" + idCreator;
                int idOwner = this.rand.nextInt(nbUsers - 1);
                owner = "user" + idOwner;
                int idEditor = this.rand.nextInt(nbUsers - 1);
                editor = "user" + idEditor;
                int idReader = this.rand.nextInt(nbUsers - 1);
                reader = "user" + idReader;
            }
            String fileExtension = this.getFileExtension(fileName);
            if (Arrays.asList(imageExtensions).contains(fileExtension)) {
                mixin = " jmix:image";
            } else if (Arrays.asList(officeDocumentExtensions).contains(fileExtension)) {
                mixin = " jmix:document";
            }
            File f = new File(filesDirectory + this.sep + fileName);
            String mimeType = this.getMimeType(f);
            Metadata metadata = new Metadata();
            if (mimeType != null) {
                metadata.set("Content-Type", mimeType);
            }
            try {
                extractedContent = new Tika().parseToString(f);
            }
            catch (FileNotFoundException e) {
                this.logger.error((CharSequence)("File not found during text extraction " + f.getAbsoluteFile()));
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TikaException e) {
                e.printStackTrace();
            }
            String description = this.getCurrentOftenDescriptionWord() + " " + this.getCurrentSeldomDescriptionWord();
            int randomTagIndex = this.rand.nextInt(nbOfTags - 1);
            TagBO tag = tags.get(randomTagIndex);
            String creationDate = this.getRandomJcrDate(timestampDifference);
            newFile = new FileBO(fileName, mixin, mimeType, currentNodePath + "/" + fileName, creator, owner, editor, reader, extractedContent, description, tag.getTagName(), wiseInstanceName, creationDate);
            files.add(newFile);
        }
        return files;
    }

    public String initializeContentFolder(String outputDirPath, String wiseInstanceName, String docpaceKey) {
        File contentdirectory = new File(outputDirPath + this.sep + "content" + this.sep + "sites" + this.sep + wiseInstanceName + this.sep + "files" + this.sep + "docspaces" + this.sep + docpaceKey);
        contentdirectory.mkdirs();
        return contentdirectory.getAbsolutePath();
    }

    public String getFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46), fileName.length());
    }

    private String getCurrentOftenDescriptionWord() {
        String descriptionWord = "";
        if (currentOftenUsedDescriptionWordIndex < nbOfOftenUsedDescriptionWords) {
            descriptionWord = oftenUsedDescriptionWords.get(currentOftenUsedDescriptionWordIndex);
            Integer n = nbOfFilesUsedForOftenUsedDescriptionWords;
            Integer n2 = nbOfFilesUsedForOftenUsedDescriptionWords = Integer.valueOf(nbOfFilesUsedForOftenUsedDescriptionWords - 1);
            if (nbOfFilesUsedForOftenUsedDescriptionWords == 0) {
                n = currentOftenUsedDescriptionWordIndex;
                n2 = currentOftenUsedDescriptionWordIndex = Integer.valueOf(currentOftenUsedDescriptionWordIndex + 1);
                nbOfFilesUsedForOftenUsedDescriptionWords = ContentGeneratorCst.OFTEN_USED_DESCRIPTION_WORDS_COUNTER;
            }
        }
        return descriptionWord;
    }

    private String getCurrentSeldomDescriptionWord() {
        String descriptionWord = "";
        if (currentSeldomUsedDescriptionWordIndex < nbOfSeldomUsedDescriptionWords) {
            descriptionWord = seldomUsedDescriptionWords.get(currentSeldomUsedDescriptionWordIndex);
            Integer n = nbOfFilesUsedForSeldomUsedDescriptionWords;
            Integer n2 = nbOfFilesUsedForSeldomUsedDescriptionWords = Integer.valueOf(nbOfFilesUsedForSeldomUsedDescriptionWords - 1);
            if (nbOfFilesUsedForSeldomUsedDescriptionWords == 0) {
                n = currentSeldomUsedDescriptionWordIndex;
                n2 = currentSeldomUsedDescriptionWordIndex = Integer.valueOf(currentSeldomUsedDescriptionWordIndex + 1);
                nbOfFilesUsedForSeldomUsedDescriptionWords = ContentGeneratorCst.SELDOM_USED_DESCRIPTION_WORDS_COUNTER;
            }
        }
        return descriptionWord;
    }

    private String getRandomJcrDate(long timestampDifference) {
        Float f = Float.valueOf(this.rand.nextFloat());
        f = Float.valueOf(f.floatValue() * (float)timestampDifference);
        f = Float.valueOf(f.floatValue() + (float)startTimestamp);
        Date d = new Date(f.longValue());
        Calendar c = GregorianCalendar.getInstance();
        c.setTime(d);
        return ISO8601.format((Calendar)c);
    }

    public String getMimeType(File f) {
        Tika tikaParser = new Tika();
        String mimeType = "";
        try {
            mimeType = tikaParser.detect(f);
        }
        catch (IOException e) {
            this.logger.error((CharSequence)("Impossible to detect the MIME type for file " + f.getAbsoluteFile()));
            e.printStackTrace();
        }
        return mimeType;
    }

    static {
        totalGeneratedFiles = 0;
    }
}

