/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.osgi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.AetherAwareMojo;

public class FindPackagesMojo
extends AetherAwareMojo {
    protected List<String> packageNames = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.packageNames == null || this.packageNames.size() == 0) {
            this.getLog().warn((CharSequence)"No package names specified, will abort now !");
            return;
        }
        this.getLog().info((CharSequence)"Scanning project dependencies...");
        Map<String, List<String>> foundPackages = this.getAetherHelper().findPackages(this.project, this.packageNames);
        this.getLog().info((CharSequence)"=================================================================================");
        this.getLog().info((CharSequence)"SEARCH RESULTS");
        this.getLog().info((CharSequence)"---------------------------------------------------------------------------------");
        for (String packageName : this.packageNames) {
            if (!foundPackages.containsKey(packageName)) {
                this.getLog().warn((CharSequence)("Couldn't find " + packageName + " anywhere!"));
                continue;
            }
            this.getLog().info((CharSequence)("Found package " + packageName + " in " + StringUtils.join((Collection)foundPackages.get(packageName), (String)" -> ")));
        }
    }
}

