/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.reporting;

import com.sun.tlddoc.TLDDocGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public class TagLibraryDocMojo
extends AbstractMavenReport
implements MavenReport {
    private String description;
    private String destDir;
    private String docTitle;
    private String excludes;
    private String includes;
    private String name;
    private String outputDirectory;
    private String outputZipFile;
    private MavenProject project;
    private boolean quiet;
    private Renderer siteRenderer;
    private File srcDir;
    private String windowTitle;

    public boolean canGenerateReport() {
        return this.srcDir.isDirectory() && !this.getSourceFiles().isEmpty();
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.getLog().info((CharSequence)("Generating taglib documentation for resources in " + this.srcDir));
        List<File> files = this.getSourceFiles();
        if (files.isEmpty()) {
            return;
        }
        TLDDocGenerator generator = new TLDDocGenerator();
        generator.setDocTitle(this.docTitle);
        generator.setWindowTitle(this.windowTitle);
        File output = new File(this.getOutputDirectory());
        output.mkdirs();
        generator.setOutputDirectory(output);
        generator.setQuiet(this.quiet);
        for (File file : files) {
            String ext = FilenameUtils.getExtension((String)file.getName());
            if ("tld".equals(ext)) {
                this.getLog().debug((CharSequence)("Adding TLD " + file));
                generator.addTLD(file);
                continue;
            }
            this.getLog().debug((CharSequence)("Adding tag directory " + file.getParentFile()));
            generator.addTagDir(file.getParentFile());
        }
        try {
            generator.generate();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        if (this.outputZipFile != null && this.outputZipFile.length() > 0) {
            ZipArchiver zip = new ZipArchiver();
            zip.setDestFile(new File(this.outputDirectory, this.outputZipFile));
            DefaultFileSet fs = new DefaultFileSet();
            fs.setDirectory(output);
            try {
                zip.addFileSet((FileSet)fs);
                zip.createArchive();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)"Finished generating taglib documentation");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("taglibrarydoc", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getDescription(Locale locale) {
        return StringUtils.isNotEmpty((String)this.description) ? this.description : this.getBundle(locale).getString("report.taglibrarydoc.description");
    }

    public String getName(Locale locale) {
        return StringUtils.isNotEmpty((String)this.name) ? this.name : this.getBundle(locale).getString("report.taglibrarydoc.name");
    }

    protected String getOutputDirectory() {
        return new File(this.outputDirectory, this.destDir).getPath();
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    private List<File> getSourceFiles() {
        List files = Collections.emptyList();
        try {
            files = FileUtils.getFiles((File)this.srcDir, (String)this.includes, (String)this.excludes);
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (!file.isFile()) {
                    iterator.remove();
                    continue;
                }
                String ext = FilenameUtils.getExtension((String)file.getName());
                if (ext != null && ("tld".equals(ext) || "tag".equals(ext) || "tagx".equals(ext))) continue;
                iterator.remove();
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
        }
        if (files.isEmpty()) {
            this.getLog().info((CharSequence)("No *.tld, *.tag or *.tagx files found for processing in the folder " + this.srcDir + " using includes '" + this.includes + "' and excludes '" + this.excludes + "'"));
        }
        return files;
    }

    public boolean isExternalReport() {
        return true;
    }
}

