/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.jahia.utils.osgi.PackageUtils;
import org.jahia.utils.osgi.parsers.PackageInfo;
import org.jahia.utils.osgi.parsers.ParsingContext;

public final class MavenAetherHelperUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesJarHavePackageName(File jarFile, String packageName, Log log) {
        boolean bl;
        JarInputStream jarInputStream = null;
        if (jarFile == null) {
            log.warn((CharSequence)"File is null !");
            return false;
        }
        if (!jarFile.exists()) {
            log.warn((CharSequence)("File " + jarFile + " does not exist !"));
            return false;
        }
        log.debug((CharSequence)("Scanning JAR " + jarFile + "..."));
        try {
            jarInputStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String jarPackageName = jarEntry.getName().replaceAll("/", ".");
                if (jarPackageName.endsWith(".")) {
                    jarPackageName = jarPackageName.substring(0, jarPackageName.length() - 1);
                }
                if (!jarPackageName.equals(packageName)) continue;
                bl = true;
            }
        }
        catch (IOException e) {
            try {
                log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)jarInputStream);
            return false;
        }
        IOUtils.closeQuietly((InputStream)jarInputStream);
        return false;
        IOUtils.closeQuietly((InputStream)jarInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<PackageInfo> getJarPackages(File jarFile, boolean optionalJar, String version, ParsingContext parsingContext, Log log) {
        JarInputStream jarInputStream = null;
        LinkedHashSet<PackageInfo> packageInfos = new LinkedHashSet<PackageInfo>();
        if (jarFile == null) {
            log.warn((CharSequence)"File is null !");
            return packageInfos;
        }
        if (!jarFile.exists()) {
            log.warn((CharSequence)("File " + jarFile + " does not exist !"));
            return packageInfos;
        }
        log.debug((CharSequence)("Scanning JAR " + jarFile + "..."));
        try {
            jarInputStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String jarPackageName = jarEntry.getName().replaceAll("/", ".");
                if (jarPackageName.endsWith(".")) {
                    jarPackageName = jarPackageName.substring(0, jarPackageName.length() - 1);
                }
                if (jarPackageName.startsWith("META-INF") || jarPackageName.startsWith("WEB-INF") || jarPackageName.startsWith("OSGI-INF")) continue;
                packageInfos.addAll(PackageUtils.getPackagesFromClass((String)jarPackageName, (boolean)optionalJar, (String)version, (String)jarFile.getCanonicalPath(), (ParsingContext)parsingContext));
            }
        }
        catch (IOException e) {
            try {
                log.error((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)jarInputStream);
        }
        IOUtils.closeQuietly((InputStream)jarInputStream);
        return packageInfos;
    }

    public static String getCoords(Artifact artifact) {
        String artifactCoords = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getType()) && !"*".equals(artifact.getType())) {
            artifactCoords = artifactCoords + ":" + artifact.getType();
        }
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            artifactCoords = artifactCoords + ":" + artifact.getClassifier();
        }
        if (StringUtils.isNotEmpty((String)artifact.getBaseVersion()) && !"*".equals(artifact.getBaseVersion())) {
            artifactCoords = artifactCoords + ":" + artifact.getBaseVersion();
        }
        return artifactCoords;
    }

    public static String getDiskPath(Artifact artifact) {
        String artifactDiskPath = artifact.getGroupId();
        artifactDiskPath = artifactDiskPath.replaceAll("\\.", "/");
        artifactDiskPath = artifactDiskPath + "/" + artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getBaseVersion()) && !"*".equals(artifact.getBaseVersion())) {
            artifactDiskPath = artifactDiskPath + "/" + artifact.getBaseVersion();
        }
        artifactDiskPath = artifactDiskPath + "/" + artifact.getArtifactId();
        if (StringUtils.isNotEmpty((String)artifact.getBaseVersion()) && !"*".equals(artifact.getBaseVersion())) {
            artifactDiskPath = artifactDiskPath + "-" + artifact.getBaseVersion();
        }
        if (StringUtils.isNotEmpty((String)artifact.getClassifier())) {
            artifactDiskPath = artifactDiskPath + "-" + artifact.getClassifier();
        }
        if (StringUtils.isNotEmpty((String)artifact.getType()) && !"*".equals(artifact.getType())) {
            artifactDiskPath = artifactDiskPath + "." + artifact.getType();
        }
        return artifactDiskPath;
    }

    static String getTrail(List<String> dependencyTrail) {
        return StringUtils.join(dependencyTrail, (String)" -> ");
    }

    static String getTrailPadding(Deque<String> dependencyTrail) {
        StringBuffer padding = new StringBuffer();
        for (int i = 0; i < dependencyTrail.size(); ++i) {
            padding.append("  ");
        }
        padding.append(dependencyTrail.peek());
        padding.append(" ");
        return padding.toString();
    }
}

