/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.bo;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ArticleBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBO {
    private Element pageElement;
    private String uniqueName;
    private Map<String, ArticleBO> articles;
    private Integer level;
    private List<PageBO> subPages;
    private PageBO parentPage;
    private Boolean hasVanity;
    private String siteKey;
    private String fileName;
    private Integer numberBigText;
    private Map<String, List<String>> acls;
    private Integer idCategory;
    private Integer idTag;
    private Boolean visibilityEnabled;
    private String visibilityStartDate;
    private String visibilityEndDate;

    public void setIdCategory(Integer idCategory) {
        this.idCategory = idCategory;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<PageBO> getSubPages() {
        return this.subPages;
    }

    public void setSubPages(List<PageBO> subPages) {
        this.subPages = subPages;
    }

    public PageBO getParentPage() {
        return this.parentPage;
    }

    public void setParentPage(PageBO parentPage) {
        this.parentPage = parentPage;
    }

    public Map<String, ArticleBO> getArticles() {
        return this.articles;
    }

    public void setArticles(Map<String, ArticleBO> articles) {
        this.articles = articles;
    }

    public Boolean getHasVanity() {
        return this.hasVanity;
    }

    public void setHasVanity(Boolean hasVanity) {
        this.hasVanity = hasVanity;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public void setSiteKey(String siteKey) {
        this.siteKey = siteKey;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Integer getNumberBigText() {
        return this.numberBigText;
    }

    public void setNumberBigText(Integer numberBigText) {
        this.numberBigText = numberBigText;
    }

    public Map<String, List<String>> getAcls() {
        return this.acls;
    }

    public void setAcls(Map<String, List<String>> acls) {
        this.acls = acls;
    }

    public Integer getIdTag() {
        return this.idTag;
    }

    public void setIdTag(Integer idTag) {
        this.idTag = idTag;
    }

    public void setVisibilityEnabled(Boolean visibilityEnabled) {
        this.visibilityEnabled = visibilityEnabled;
    }

    public void setVisibilityStartDate(String visibilityStartDate) {
        this.visibilityStartDate = visibilityStartDate;
    }

    public void setVisibilityEndDate(String visibilityEndDate) {
        this.visibilityEndDate = visibilityEndDate;
    }

    public PageBO(String pUniqueName, Map<String, ArticleBO> articles, int pLevel, List<PageBO> pSubPages, Boolean pHasVanity, String pSiteKey, String pFileName, Integer pNumberBigText, Map<String, List<String>> acls, Integer idCategory, Integer idTag, Boolean visibilityEnabled, String visibilityStartDate, String visibilityEndDate) {
        this.articles = articles;
        this.level = pLevel;
        this.subPages = pSubPages;
        this.uniqueName = pUniqueName;
        this.hasVanity = pHasVanity;
        this.siteKey = pSiteKey;
        this.fileName = pFileName;
        this.numberBigText = pNumberBigText;
        this.acls = acls;
        this.idCategory = idCategory;
        this.idTag = idTag;
        this.visibilityEnabled = visibilityEnabled;
        this.visibilityStartDate = visibilityStartDate;
        this.visibilityEndDate = visibilityEndDate;
    }

    public String getHeader() {
        XMLOutputter outputter = new XMLOutputter();
        String pageString = outputter.outputString(this.getElement());
        return StringUtils.removeEnd((String)pageString, (String)("</" + this.uniqueName + ">"));
    }

    public String getFooter() {
        return "</" + this.uniqueName + ">";
    }

    public String toString() {
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(this.getElement());
    }

    public Element getElement() {
        if (this.pageElement == null) {
            Element translation;
            this.pageElement = new Element(this.uniqueName);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JCR);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_NT);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JNT);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_TEST);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_SV);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_JMIX);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_J);
            this.pageElement.addNamespaceDeclaration(ContentGeneratorCst.NS_MIX);
            this.pageElement.setAttribute("templateNode", "/sites/" + this.siteKey + "/templates/base/events", ContentGeneratorCst.NS_J);
            StringBuffer mixinTypes = new StringBuffer();
            if (this.getHasVanity().booleanValue()) {
                mixinTypes.append(" jmix:vanityUrlMapped ");
            }
            if (this.idCategory != null) {
                mixinTypes.append(" jmix:categorized ");
            }
            mixinTypes.append("jmix:sitemap");
            this.pageElement.setAttribute("mixinTypes", mixinTypes.toString(), ContentGeneratorCst.NS_JCR);
            this.pageElement.setAttribute("primaryType", "jnt:page", ContentGeneratorCst.NS_JCR);
            this.pageElement.setAttribute("priority", "0.5");
            if (this.idCategory != null) {
                this.pageElement.setAttribute("defaultCategory", "/sites/systemsite/categories/category" + this.idCategory, ContentGeneratorCst.NS_J);
            }
            if (this.idTag != null) {
                this.pageElement.setAttribute("tags", "/sites/" + this.siteKey + "/tags/tag", ContentGeneratorCst.NS_J);
            }
            for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                Element translation2 = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                translation2.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                translation2.setAttribute("mixinTypes", "mix:title", ContentGeneratorCst.NS_JCR);
                translation2.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                translation2.setAttribute("title", this.formatForXml(entry.getValue().getTitle()), ContentGeneratorCst.NS_JCR);
                this.pageElement.addContent((Content)translation2);
            }
            Element list = new Element("listA");
            for (int i = 1; i <= this.numberBigText; ++i) {
                Element bigText = new Element("bigText_" + i);
                bigText.setAttribute("mixinTypes", "jmix:renderable", ContentGeneratorCst.NS_JCR);
                bigText.setAttribute("primaryType", "jnt:bigText", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    translation = new Element("translation_" + entry.getKey());
                    translation.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translation.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                    translation.setAttribute("text", this.formatForXml(entry.getValue().getContent()), ContentGeneratorCst.NS_JCR);
                    bigText.addContent((Content)translation);
                }
                list.addContent((Content)bigText);
            }
            this.pageElement.addContent((Content)list);
            if (this.getFileName() != null) {
                Element randomFile = new Element("random-file");
                randomFile.setAttribute("primaryType", "jnt:fileReference", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    Element translation3 = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                    translation3.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translation3.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                    translation3.setAttribute("title", "My File - " + entry.getKey(), ContentGeneratorCst.NS_JCR);
                    randomFile.addContent((Content)translation3);
                }
                list.addContent((Content)randomFile);
                Element publication = new Element("publication");
                publication.setAttribute("primaryType", "jnt:publication", ContentGeneratorCst.NS_JCR);
                for (Map.Entry<String, ArticleBO> entry : this.articles.entrySet()) {
                    translation = new Element("translation_" + entry.getKey(), ContentGeneratorCst.NS_J);
                    translation.setAttribute("author", "Jahia Content Generator");
                    translation.setAttribute("body", " Random publication");
                    translation.setAttribute("date", "01/01/1970");
                    translation.setAttribute("file", "/sites/" + this.getSiteKey() + "/files/contributed/" + this.getFileName());
                    translation.setAttribute("language", entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translation.setAttribute("primaryType", "jnt:translation", ContentGeneratorCst.NS_JCR);
                    translation.setAttribute("title", "Random publication - " + entry.getKey(), ContentGeneratorCst.NS_JCR);
                    translation.setAttribute("source", "Jahia");
                    publication.addContent((Content)translation);
                }
                list.addContent((Content)publication);
            }
            if (this.getHasVanity().booleanValue()) {
                Element vanity = new Element("vanityUrlMapping");
                vanity.setAttribute("primaryType", "jnt:vanityUrls", ContentGeneratorCst.NS_JCR);
                Element content = new Element("_x0025_2F");
                content.setAttribute("active", "true", ContentGeneratorCst.NS_J);
                content.setAttribute("default", "true", ContentGeneratorCst.NS_J);
                content.setAttribute("url", "/" + this.getUniqueName(), ContentGeneratorCst.NS_J);
                content.setAttribute("language", "en", ContentGeneratorCst.NS_JCR);
                content.setAttribute("primaryType", "jnt:vanityUrl", ContentGeneratorCst.NS_JCR);
                vanity.addContent((Content)content);
                this.pageElement.addContent((Content)vanity);
            }
            if (this.visibilityEnabled.booleanValue()) {
                Element visibility = new Element("conditionalVisibility", ContentGeneratorCst.NS_J);
                visibility.setAttribute("forceMatchAllConditions", "true", ContentGeneratorCst.NS_J);
                visibility.setAttribute("primaryType", "jnt:conditionalVisibility", ContentGeneratorCst.NS_JCR);
                Element startEndDateCondition = new Element("startEndDateCondition0", ContentGeneratorCst.NS_JNT);
                startEndDateCondition.setAttribute("start", this.visibilityStartDate);
                startEndDateCondition.setAttribute("end", this.visibilityEndDate);
                startEndDateCondition.setAttribute("primaryType", "jnt:startEndDateCondition", ContentGeneratorCst.NS_JCR);
                visibility.addContent((Content)startEndDateCondition);
                this.pageElement.addContent((Content)visibility);
            }
            if (null != this.subPages) {
                for (PageBO subPage : this.subPages) {
                    this.pageElement.addContent((Content)subPage.getElement());
                }
            }
        }
        return this.pageElement;
    }

    public String formatForXml(String s) {
        String formattedString = StringUtils.replace((String)s, (String)"&", (String)"&amp;");
        formattedString = StringUtils.replace((String)formattedString, (String)"\"", (String)" &quot;");
        formattedString = StringUtils.replace((String)formattedString, (String)"<", (String)"&lt;");
        formattedString = StringUtils.replace((String)formattedString, (String)">", (String)"&gt;");
        formattedString = StringUtils.replace((String)formattedString, (String)"'", (String)"&#39;");
        return formattedString;
    }
}

