/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.mojo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.contentgenerator.ContentGeneratorService;
import org.jahia.utils.maven.plugin.contentgenerator.FileService;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.properties.ContentGeneratorCst;
import org.jahia.utils.maven.plugin.contentgenerator.properties.DatabaseProperties;

public abstract class ContentGeneratorMojo
extends AbstractMojo {
    protected String mysql_host;
    protected String mysql_login;
    protected String mysql_password;
    protected String mysql_db;
    protected String mysql_table;
    protected Integer nbPagesOnTopLevel;
    protected Integer nbSubLevels;
    protected Integer nbPagesPerLevel;
    protected String outputDirectory;
    protected String outputFileName;
    protected Boolean pagesHaveVanity;
    protected String siteKey;
    protected String siteLanguages;
    protected String addFiles;
    protected String poolDirectory;
    protected Integer numberOfFilesToGenerate;
    protected Integer numberOfBigTextPerPage;
    protected Integer numberOfUsers;
    protected Integer numberOfGroups;
    protected Integer numberOfUsersPerGroup;
    protected double groupAclRatio;
    protected double usersAclRatio;
    protected Integer numberOfSites;
    protected Integer numberOfCategories;
    protected Integer numberOfCategoryLevels;
    protected Integer numberOfTags;
    protected Boolean visibilityEnabled;
    protected String visibilityStartDate;
    protected String visibilityEndDate;

    public abstract void execute() throws MojoExecutionException, MojoFailureException;

    protected ExportBO initExport() throws MojoExecutionException {
        ExportBO export = new ExportBO();
        ContentGeneratorService contentGeneratorService = ContentGeneratorService.getInstance();
        DatabaseProperties.HOSTNAME = this.mysql_host;
        if (this.mysql_db == null) {
            throw new MojoExecutionException("No database name provided");
        }
        DatabaseProperties.DATABASE = this.mysql_db;
        if (this.mysql_login == null) {
            throw new MojoExecutionException("No database user provided");
        }
        DatabaseProperties.USER = this.mysql_login;
        if (this.mysql_password == null) {
            throw new MojoExecutionException("No database user password provided");
        }
        DatabaseProperties.PASSWORD = this.mysql_password;
        if (this.mysql_table == null) {
            this.getLog().info((CharSequence)"No MySQL table name provided, uses default \"articles\"");
            DatabaseProperties.TABLE = "articles";
        } else {
            DatabaseProperties.TABLE = this.mysql_table;
        }
        export.setNbPagesTopLevel(this.nbPagesOnTopLevel);
        export.setNbSubLevels(this.nbSubLevels);
        export.setNbSubPagesPerPage(this.nbPagesPerLevel);
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("outputDirectory property can not be null");
        }
        File fOutputDirectory = new File(this.outputDirectory);
        if (!fOutputDirectory.exists()) {
            fOutputDirectory.mkdirs();
        }
        File outputFile = new File(this.outputDirectory, this.outputFileName);
        export.setOutputFile(outputFile);
        export.setOutputDir(this.outputDirectory);
        File outputMapFile = new File(this.outputDirectory, "sitemap.txt");
        export.setMapFile(outputMapFile);
        export.setPagesHaveVanity(this.pagesHaveVanity);
        export.setSiteKey(this.siteKey);
        export.setSiteLanguages(Arrays.asList(this.siteLanguages.split(",")));
        export.setAddFilesToPage(this.addFiles);
        if ("all".equals(export.getAddFilesToPage()) || "random".equals(export.getAddFilesToPage())) {
            if (this.poolDirectory == null) {
                throw new MojoExecutionException("Pool directory property can not be null");
            }
            File fPoolDirectory = new File(this.poolDirectory);
            if (!fPoolDirectory.exists()) {
                fPoolDirectory.mkdirs();
            }
            export.setFilesDirectory(fPoolDirectory);
            FileService fileService = new FileService();
            List<String> filesNamesAvailable = fileService.getFileNamesAvailable(export.getFilesDirectory());
            export.setFileNames(filesNamesAvailable);
        }
        export.setNumberOfBigTextPerPage(this.numberOfBigTextPerPage);
        export.setNumberOfUsers(this.numberOfUsers);
        export.setNumberOfGroups(this.numberOfGroups);
        export.setNumberOfUsersPerGroup(this.numberOfUsersPerGroup);
        export.setNumberOfFilesToGenerate(this.numberOfFilesToGenerate);
        export.setGroupAclRatio(this.groupAclRatio);
        export.setUsersAclRatio(this.usersAclRatio);
        export.setNumberOfSites(this.numberOfSites);
        export.setNumberOfCategories(this.numberOfCategories);
        export.setNumberOfCategoryLevels(this.numberOfCategoryLevels);
        export.setNumberOfTags(this.numberOfTags);
        if (this.visibilityEnabled == null) {
            this.visibilityEnabled = Boolean.FALSE;
        }
        export.setVisibilityEnabled(this.visibilityEnabled);
        export.setVisibilityStartDate(this.visibilityStartDate);
        export.setVisibilityEndDate(this.visibilityEndDate);
        Integer totalPages = contentGeneratorService.getTotalNumberOfPagesNeeded(this.nbPagesOnTopLevel, this.nbSubLevels, this.nbPagesPerLevel);
        export.setTotalPages(totalPages);
        if (export.getTotalPages().compareTo(ContentGeneratorCst.MAX_TOTAL_PAGES) > 0) {
            throw new MojoExecutionException("You asked to generate " + export.getTotalPages() + " pages, the maximum allowed is " + ContentGeneratorCst.MAX_TOTAL_PAGES);
        }
        return export;
    }
}

