/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.utils.maven.plugin.contentgenerator.mojo;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jahia.utils.maven.plugin.contentgenerator.bo.ExportBO;
import org.jahia.utils.maven.plugin.contentgenerator.mojo.ContentGeneratorMojo;
import org.jahia.utils.maven.plugin.contentgenerator.wise.WiseService;

public class GenerateWiseMojo
extends ContentGeneratorMojo {
    private Integer nbDocspaces;
    private Integer nbPolls;
    private Integer nbNotes;
    private Integer nbTasks;
    private Integer nbFoldersPerLevel;
    private Integer foldersDepth;
    private Integer nbFilesPerFolder;

    public ExportBO initExport() throws MojoExecutionException {
        ExportBO wiseExport = super.initExport();
        wiseExport.setNbDocspaces(this.nbDocspaces);
        wiseExport.setNbPolls(this.nbPolls);
        wiseExport.setNbNotes(this.nbNotes);
        wiseExport.setNbFoldersPerLevel(this.nbFoldersPerLevel);
        wiseExport.setFoldersDepth(this.foldersDepth);
        wiseExport.setNbFilesPerFolder(this.nbFilesPerFolder);
        wiseExport.setNbTasks(this.nbTasks);
        return wiseExport;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        WiseService wiseService = WiseService.getInstance();
        ExportBO wiseExport = this.initExport();
        this.getLog().info((CharSequence)"Jahia content generator for Wise starts");
        this.getLog().info((CharSequence)(wiseExport.getSiteKey() + " instance will be created"));
        try {
            String wiseRepositoryFile = wiseService.generateWise(wiseExport);
            this.getLog().info((CharSequence)("Wise instance archive created and available here: " + wiseRepositoryFile));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing output file");
            e.printStackTrace();
        }
    }
}

