/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.janusgraph.core.attribute.Geoshape;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.io.GeoJSONReader;
import org.locationtech.spatial4j.io.GeoJSONWriter;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.io.WKTWriter;
import org.locationtech.spatial4j.io.jts.JtsBinaryCodec;
import org.locationtech.spatial4j.io.jts.JtsGeoJSONWriter;
import org.locationtech.spatial4j.io.jts.JtsWKTWriter;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class JtsGeoshapeHelper {
    protected JtsSpatialContext context;
    protected WKTReader wktReader;
    protected WKTWriter wktWriter;
    protected GeoJSONReader geojsonReader;
    protected GeoJSONWriter geojsonWriter;
    protected JtsBinaryCodec binaryCodec;
    protected JtsSpatialContextFactory factory = new JtsSpatialContextFactory();

    public JtsGeoshapeHelper() {
        this.factory.geo = true;
        this.factory.useJtsPoint = false;
        this.factory.useJtsLineString = true;
        this.factory.datelineRule = DatelineRule.none;
        this.context = new JtsSpatialContext(this.factory);
        this.wktReader = new WKTReader((SpatialContext)this.context, (SpatialContextFactory)this.factory);
        this.wktWriter = new JtsWKTWriter(this.context, this.factory);
        this.geojsonReader = new GeoJSONReader((SpatialContext)this.context, (SpatialContextFactory)this.factory);
        this.geojsonWriter = new JtsGeoJSONWriter(this.context, (SpatialContextFactory)this.factory);
        this.binaryCodec = new JtsBinaryCodec(this.context, this.factory);
    }

    public Geoshape geoshape(Geometry geometry) {
        return new Geoshape(this.context.getShapeFactory().makeShapeFromGeometry(geometry));
    }

    public Shape readShape(DataInputStream dataInput) throws IOException {
        if (dataInput.readByte() == 0) {
            return this.binaryCodec.readJtsGeom((DataInput)dataInput);
        }
        return this.binaryCodec.readShape((DataInput)dataInput);
    }

    public void write(DataOutputStream dataOutput, Geoshape attribute) throws IOException {
        if (this.isJts(attribute.getShape())) {
            dataOutput.writeByte(0);
            this.binaryCodec.writeJtsGeom((DataOutput)dataOutput, attribute.getShape());
        } else {
            dataOutput.writeByte(1);
            this.binaryCodec.writeShape((DataOutput)dataOutput, attribute.getShape());
        }
    }

    public Geoshape polygon(List<double[]> coordinates) {
        Preconditions.checkArgument((coordinates.size() >= 4 ? 1 : 0) != 0, (Object)"Too few coordinate pairs provided");
        Preconditions.checkArgument((coordinates.get(0) != coordinates.get(coordinates.size() - 1) ? 1 : 0) != 0, (Object)"Polygon is not closed");
        ShapeFactory.PolygonBuilder builder = this.getContext().getShapeFactory().polygon();
        for (double[] coordinate : coordinates) {
            Preconditions.checkArgument((coordinate.length == 2 && Geoshape.isValidCoordinate(coordinate[1], coordinate[0]) ? 1 : 0) != 0, (Object)"Invalid coordinate provided");
            builder.pointXY(coordinate[0], coordinate[1]);
        }
        return new Geoshape(builder.build());
    }

    public Geoshape.Type getType(Shape shape) {
        Geoshape.Type type;
        if (JtsGeometry.class.isAssignableFrom(shape.getClass()) && "LineString".equals(((JtsGeometry)shape).getGeom().getGeometryType())) {
            type = Geoshape.Type.LINE;
        } else if (JtsGeometry.class.isAssignableFrom(shape.getClass())) {
            try {
                type = Geoshape.Type.fromGson(((JtsGeometry)shape).getGeom().getGeometryType());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unrecognized shape type");
            }
        } else if (Point.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.POINT;
        } else if (Circle.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.CIRCLE;
        } else if (Rectangle.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.BOX;
        } else if (BufferedLineString.class.isAssignableFrom(shape.getClass())) {
            type = Geoshape.Type.LINE;
        } else if (ShapeCollection.class.isAssignableFrom(shape.getClass())) {
            Set types = ((ShapeCollection)shape).getShapes().stream().map(this::getType).collect(Collectors.toSet());
            switch (types.size() == 1 ? (Geoshape.Type)((Object)types.iterator().next()) : Geoshape.Type.GEOMETRYCOLLECTION) {
                case POINT: {
                    type = Geoshape.Type.MULTIPOINT;
                    break;
                }
                case LINE: {
                    type = Geoshape.Type.MULTILINESTRING;
                    break;
                }
                case POLYGON: {
                    type = Geoshape.Type.MULTIPOLYGON;
                    break;
                }
                default: {
                    type = Geoshape.Type.GEOMETRYCOLLECTION;
                    break;
                }
            }
        } else {
            throw new IllegalStateException("Unrecognized shape type: " + shape.getClass());
        }
        return type;
    }

    public int size(Shape shape) {
        switch (this.getType(shape)) {
            case LINE: 
            case POLYGON: 
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                return ((JtsGeometry)shape).getGeom().getCoordinates().length;
            }
            case POINT: {
                return 1;
            }
            case CIRCLE: {
                return 1;
            }
            case BOX: {
                return 2;
            }
            case GEOMETRYCOLLECTION: {
                return ((ShapeCollection)shape).getShapes().stream().map(s -> s).mapToInt(s -> this.size((Shape)s)).sum();
            }
        }
        throw new IllegalStateException("size() not supported for type: " + (Object)((Object)this.getType(shape)));
    }

    public Geoshape.Point getPoint(Geoshape geoshape, int position) {
        Shape shape = geoshape.getShape();
        if (position < 0 || position >= this.size(shape)) {
            throw new ArrayIndexOutOfBoundsException("Invalid position: " + position);
        }
        switch (this.getType(shape)) {
            case LINE: 
            case POLYGON: 
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                Coordinate coordinate = ((JtsGeometry)shape).getGeom().getCoordinates()[position];
                return new Geoshape.Point(coordinate.y, coordinate.x);
            }
            case POINT: 
            case CIRCLE: {
                return geoshape.getPoint();
            }
            case BOX: {
                if (position == 0) {
                    return new Geoshape.Point(shape.getBoundingBox().getMinY(), shape.getBoundingBox().getMinX());
                }
                return new Geoshape.Point(shape.getBoundingBox().getMaxY(), shape.getBoundingBox().getMaxX());
            }
            case GEOMETRYCOLLECTION: {
                return ((ShapeCollection)shape).getShapes().stream().flatMap(internShape -> IntStream.range(0, this.size((Shape)internShape)).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Shape, Integer>((Shape)internShape, i))).skip(position).findFirst().map(entry -> this.getPoint(new Geoshape((Shape)entry.getKey()), (Integer)entry.getValue())).orElse(null);
            }
        }
        throw new IllegalStateException("getPoint(int) not supported for type: " + (Object)((Object)this.getType(shape)));
    }

    public boolean isJts(Shape shape) {
        return shape instanceof JtsGeometry;
    }

    public SpatialContext getContext() {
        return this.context;
    }

    public WKTReader getWktReader() {
        return this.wktReader;
    }

    public WKTWriter getWktWriter() {
        return this.wktWriter;
    }

    public GeoJSONReader getGeojsonReader() {
        return this.geojsonReader;
    }

    public GeoJSONWriter getGeojsonWriter() {
        return this.geojsonWriter;
    }

    public JtsBinaryCodec getBinaryCodec() {
        return this.binaryCodec;
    }
}

