/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.util.BackendOperation;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.util.system.IOUtils;

public class JanusGraphCleanup {
    @Deprecated
    public static final void clear(JanusGraph graph) {
        Preconditions.checkNotNull((Object)graph);
        Preconditions.checkArgument((boolean)(graph instanceof StandardJanusGraph), (String)"Invalid graph instance detected: %s", (Object[])new Object[]{graph.getClass()});
        StandardJanusGraph g = (StandardJanusGraph)graph;
        Preconditions.checkArgument((!g.isOpen() ? 1 : 0) != 0, (Object)"Graph needs to be shut down before it can be cleared.");
        final GraphDatabaseConfiguration config = g.getConfiguration();
        BackendOperation.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Backend backend = config.getBackend();
                try {
                    backend.clearStorage();
                }
                finally {
                    IOUtils.closeQuietly(backend);
                }
                backend.getIndexInformation().forEach((name, index) -> {
                    try {
                        ((IndexProvider)index).clearStorage();
                    }
                    catch (BackendException e) {
                        throw new RuntimeException(e);
                    }
                });
                return true;
            }

            public String toString() {
                return "ClearBackend";
            }
        }, Duration.ofSeconds(20L));
    }
}

